
.include "m8515def.inc"

.def null=r0
.def eins=r1

.def temp=r16
.def temp2=r17
.def temp3=r18
.def Bits=r19
.def NextOp=r20
.def tempm=r21
.def Flag=r22

.def Spalte=r25

.def XAdresseLow=r26
.def Zeile=r27

.def AdresseLow	=r30
.def AdresseHigh=r31

;PortE
.equ 	EnLCD=0

;PortD
.equ 	XSCL=3
.equ 	LP=4
.equ 	FLM=5

.org 0000
rjmp reset

.org OVF0addr					;Timer 0
rjmp TOV

.org URXCaddr                   ; Interruptvektor fr UART-Empfang
rjmp RXRoutine

.org 32
reti

TOV:
	ldi tempm, 100
	out Tcnt0, tempm	
	ser Flag
reti

Reset:
ldi		r16, low(RAMEND)
out		SPL, r16				; setup stack pointer

ldi		r16, high(RAMEND)
out		SPH, r16				; setup stack pointer

clr null
clr NextOp
ldi temp, 1
mov eins, temp

ldi temp, 252
out ddrd, temp

ser temp

out ddre, temp
out portd, temp

cbi portd, XSCL

sbi porte, EnLCD

ldi temp,63+128
out ddrb, temp

ldi temp, 2					
out TCCR0, temp					
						
out TCNT0, null				
						
ldi temp, 2					
out TIMSK, temp			
						
clr AdresseLow				
ldi AdresseHigh, 3

ldi Zeile, 3		;Zeile = Beginn XRAM
cbr Spalte, 128
ldi XAdresseLow, 36	;Startadresse -2*62, um Header vom BMP zu entfernen

clr Bits		

clr Spalte

 ; Baudrate einstellen
ldi temp, 9							;9 fr 115,2k bei 18,432MHz
out UBRR, temp
ldi temp, (1<<RXEN)|(1<<TXEN)|(1<<RXCIE)
out UCSRB, temp 					; RX, TX aktivieren

ldi temp,128+32
out mcucr, temp

clr AdresseLow				
ldi AdresseHigh, 4

cbi porte, EnLCD

	in r16, WDTCR
  	ori r16, (1<<WDCE) | (1<<WDE)
  	out WDTCR, r16
  	ldi r16, (1<<WDE) | (1<<WDP1) | (1<<WDP0)
  	out WDTCR, r16
	wdr
sei

DataOut:
	cpi Flag, 255
	brne DataOut
	clr Flag


Xshift:
	ld temp, Z+
	ld temp, Z+
	ld temp, Z+
	ld temp, Z+
	cpi AdresseLow, 164
	brlo XShift

	sbi portd, LP			;HSync
	nop
	nop
	cbi portd, LP

	cbi portd, FLM			;VSync Ende

	cpi AdresseHigh, 245	;VSync ?
	brne SkipFLM
	sbi portd, FLM
	wdr						;Watchdog Reset beim VSync
	ldi AdresseHigh, 3		;Adresszhler Reset
SkipFLM:

	clr AdresseLow			;Adresszhler auf nchste Zeile setzen
	inc AdresseHigh

warte:						;Delay, um exakt 75fps zu erreichen und um eventuelle Verzgerungen durch Interrupts zu beheben.
	nop
	sleep
	nop
	
	rjmp DataOut

RXRoutine:
	in r9, sreg
	in temp, udr

	sbi portd, XSCL
	sbrc Spalte, 7
	rjmp untereHalfte

obereHalfte:
	ld temp2, X
	andi temp2, 15		;obere Datenhlfte behalten
	mov temp3, temp
	andi temp3, 240		;erste Hlfte behalten
	or temp2, temp3
	st X+,temp2

	ld temp2, X
	andi temp2, 15		;obere Datenhlfte behalten
	swap temp
	andi temp, 240		;erste Hlfte behalten
	or temp2, temp
	st X+,temp2

	cpi XAdresseLow, 160;Spalten Adresse > Max ?
	brne normal
	clr XAdresseLow		;Spalten Adresse = 0
	inc Zeile			;Zeilen Adresse ++
	cpi Zeile, 244		;Zeilen Adresse in untere Displayhlfte  ?
	brne normal
	ldi Zeile, 4		;Zeile = Beginn XRAM
	sbr Spalte, 128		;MSB Spalten Adresse = Displayhlfte
	cbi portd, XSCL
	out sreg, r9
reti

untereHalfte:
	swap temp
	ld temp2, X
	andi temp2, 240		;untere Datenhlfte behalten
	mov temp3, temp
	andi temp3, 15		;erste Hlfte behalten
	or temp2, temp3
	st X+,temp2

	ld temp2, X
	andi temp2, 240		;untere Datenhlfte behalten
	swap temp
	andi temp, 15		;erste Hlfte behalten
	or temp2, temp
	st X+,temp2

	cpi XAdresseLow, 160;Spalten Adresse > Max ?
	brne normal
	clr XAdresseLow		;Spalten Adresse = 0
	inc Zeile			
	cpi Zeile, 244		;Zeilen Adresse in untere Displayhlfte  ?
	brne normal
	ldi Zeile, 3		;Zeile = Beginn XRAM
	cbr Spalte, 128
	ldi XAdresseLow, 36	;Startadresse -2*62, um Header vom BMP zu entfernen
normal:
	cbi portd, XSCL		;MSB Spalten Adresse = Displayhlfte
	out sreg, r9
reti

