;****************************************************************************
;*																			*
;*					LCD Controller fr Dualscan 640x480 LCD					*
;*																			*
;*								Paralleler Datenbus							*
;*																			*
;*			!!!!!!!! Testversion mit einer Menge Fehler !!!!!!!				*
;*																			*
;****************************************************************************
;*																			*
;*	Einfacher LCD Controller fr ein SW 640x480 LCD, wie es in vielen alten	*
;*	Notebooks verbaut ist.													*
;*	Auer einem mega8515, einem 74HC32, dem 74x573 Adresslatch im Datenbus, *
;*	und einem 64kB SRAM (mit 55ns oder schneller) werden keine weiteren		*
;*	Bauteile bentig. Neue Daten werden ber ein paralleles Interface mit	*
;*	bis zu 100kByte (mit einem einfachen QBasic Programm schaffe ich rund 	*
;*	50kByte/s) in den Speicher geladen. 								 	*			
;*	Aufgrund der hohen Datenrate des Parallelports und der LCD Ausgang, 	*
;*	luft der AVR mit 18,432MHz und steuert das LCD mit rund 65Hz an.		*
;*																			*
;*	Der Datentransfer ber den Parallelport behindert die Datenausgabe auf	*
;*	dem LCD nicht, man sieht also kein Flackern oder hnliches. 		 	*
;*																			*
;*	Die Datenbertragung luft ber 3 Leitungen und den 8bit Datenbus:		*
;*	Write, Command/Data und Busy dienen zur Steuerung des Datenbusses		*
;*	Da das Interface Softwaremig gelst wurde, muss man ein paar Details	*
;*	beachten: 																*				
;*	Bei der fallenden Flanke von Write werden nach etwa 0,3-1,5us die Daten	*
;*	gespeichert. Command/Data und die Daten mssen also solange stabil 		*
;*	bleiben, bis diese Zeit vorber ist, oder Busy auf High Pegel geht.		*
;*	Der Writeimpuls selber wird Hardwaremig abgefragt und muss mindestens	*
;*	100ns lang sein. Alle Write Impulse die whrend der Ausfhrung eines 	*
;*	Befehls ankommen, werden ignoriert (es ginge auch anderst, aber dies 	*
;* 	dient zur "Entprellung", da beim Betrieb am LPT sonst Strungen 		*
;*	auftreten. Mit einen 1,5m Kabel habe ich keine Strungen, bei 2m ist es	*
;*	nahezu unbrauchbar. Auf jedenfall bentigen Write und Command/Data 		*
;*	PullUps gegen +5V. Diese sollten etwa 400-1000 Ohm haben.				*
;*																			*
;*	Befehle:																*
;*																			*
;*	001		Set Cursor. Gefolgt von zwei Parametern, nmlich der Zeilen		*
;*			und Spaltenadresse. Die Zeilenadresse liegt im Bereich 0-239,	*
;*			und die Spaltenadresse im Bereich 0-79 (plus 128, falls die 	*
;*			Position in der unteren Displayhlfte liegt.) 					*
;*																			*
;*	010		Clear Line. Dieser Befehl bentigt keinen Parameter und lscht	*
;*			die aktuelle Zeile. Danach wird der Cursor auf den Beginn der	*
;*			nchsten Zeile gesetzt. So kann man 480 mal diesen Befehl 		*
;*			senden, um das ganze LCD zu lschen. Allerdings ist dieser		*
;*			Befehl sehr komplex, und bentigt daher einiges an Zeit. Sendet	*
;*			man also diesen Befehl fters ohne Pause, dann kommt es zu		*
;*			einem kurzen Flackern des LCDs.									*
;*																			*
;*	011		Clear LCD. Dieser Befehl lscht das LCD in extrem kurzer Zeit.	*
;*			Aber wie auch schon beim Clear Line Befehl, bentigt er einiges	*
;*			an Zeit um den kompletten Speicher zu lschen. Das LCD Timing	*
;*			wird zwar nicht ganz eingehalten, aber man merkt nichts davon.	*
;*																			*
;*	Daten:	Nach dem Senden eines Datenwertes wird dieser in den Speicher	*
;*			geschrieben, und der Adresszhler anschlieend erhht.			*
;*			Jedes Byte enthlt 8 nebeneinanderliegende Pixel. Im SRAM 		*
;*			werden dagegen 4 nebeneinander liegende Pixel aus der oberen,	*
;*			und 4 nebeneinander liegende Pixel aus der unteren Hlfte 		*
;*			gespeichert. Das mach das Laden von Daten etwas komplizierter,	* 
;*			vereinfacht und beschleunigt die Ausgabe aber extrem.			*
;*																			*
;*	IO Pins:																*
;*																			*
;*	PB0-7	Daten	8 Bit Befehle/Daten fr den Controller					*
;*	PD0		C/D		Command/Data: Auswahl Befehl (high) und Daten (low)		*
;*	PD1		Busy	Status des Display Controllers: Busy=high, Ready=low	*
;*	PD2		WR\		Write Eingang. Ein Low Impuls ld die Daten				*
;*	PD3		EXSCL	Aktivierung fr XSCL. Dieser Pin aktiviert ber ein 	*
;*					74HC32 den Schiebetakt fr die Daten					*
;*	PD4		LP		Latchpuls. Der Impuls ld die Daten aus dem Schiebe-	*
;*					register ins Display. Dient als HSync.					*
;*	PD5		FLM		VSync fr das LCD. Das LCD springt in die erste Zeile.	*
;*	PD6		VWR\	Write Enable fr das SRAM.								*
;*	PD7		VRD\	Output Enable fr das SRAM und XSCL ber den 74HC32 	*
;*					fr das LCD. Bei jedem Lesevorgang werden die Daten ins	*
;*					LCD geladen												*
;*	PE0		EnLCD	Schaltet ber einen PNP und einen PNP Transistor die	*
;*					LCD Spannung, damit im Falle eines Fehlers (z.B. Ausfall*
;*					der +5V) das LCD nicht zerstrt wird.					*
;*	PE2		PWM 	PWM Ausgang, z.B. fr Displaykontrast (geht noch nicht)	*	
;*																			*
;****************************************************************************

.include "m8515def.inc"		;@18,432MHz

.def null	=r0
.def eins	=r1
.def voll	=r2

.def temp	=r16
.def temp2	=r17
.def temp3	=r18
.def Bits	=r19
.def NextOp	=r20			;Zhler fr Parameter eines Befehls
.def tempm	=r21
.def Flags	=r22

.def XAdresseLow=r26		;Writepointer Spalte
.def ZeileL		=r27		;Writepointer Zeile LSB

.def AdresseLow	=r30		;Readpointer Spalte
.def AdresseHigh=r31		;Readpointer Zeile

;PortB	
; 8bit IO Data

;PortD
.equ 	CD		=0			;Command/Data
.equ 	Busy	=1			;Controller Busy
.equ	WR		=2			;Write Data: min. 1us Low
.equ 	XSCL	=3			;Enable XSCL
.equ 	LP		=4			;HSync
.equ 	FLM		=5			;VSync

;PortE
.equ 	EnLCD	=0			;LCD Spannung einschalten

;Flags
.equ	Frame	=0			;Warten bis 1/(60fps * 242 Zeilen) Sekunden vorbei ist, ehe die nchste Zeile ausgegeben wird.
.equ 	ZeileH	=7			;Writepointer Zeile MSB, entscheidet zwischen obere und untere Displayhlte, also zwischen Hig und Low Nibble eines RAM Bytes

.org 0000
rjmp reset

.org INT0addr  				;Interruptvektor fr Daten-Empfang
	in temp2, pind
	in temp, pinb
rjmp Write

.org OVF0addr				;Timer 0
rjmp Framestart

.org 32
reti

Framestart:
	out Tcnt0, tempm	
	sbr Flags, (1<<Frame)
reti

Reset:
ldi	temp, low(RAMEND)
out	SPL, temp				;setup stack pointer

ldi	temp, high(RAMEND)
out	SPH, temp				;setup stack pointer

clr null
clr NextOp
ldi temp, 1
mov eins, temp

ser temp,
mov voll, temp

ldi temp, 128+64+32+16+8+2
out ddrd, temp

out portd, voll
out ddre, voll

cbi portd, XSCL

sbi porte, EnLCD

ldi temp, 255

ldi temp, 2					;2,7648MHz Takt
out TCCR0, temp					
						
out TCNT0, null				
						
ldi temp, 2					;TOV Interrupt
out TIMSK, temp	

ldi temp, (1<<INT0)			;INT0 Interrupt
out GICR, temp	

ldi tempm, 90				;Timer Reloadwert
						
clr XAdresseLow	
ldi ZeileL, 4				;Begin XRAM		

clr Bits		

ldi temp, (1<<SRE)|(1<<ISC01)
out mcucr, temp

;ldi temp, (1<<COM1B1)|(1<<COM1B0)|(1<<WGM10)	;Enable PWM
;out TCCR1A, temp

;ldi temp, 128
;out OCR1BL, temp			;PWM: 50% Duty Cycle

;ldi temp, (1<<CS10)			;72kHz PWM Frequenz
;out TCCR1B, temp

clr AdresseLow				
ldi AdresseHigh, 4			;Begin XRAM

cbi porte, EnLCD			;Displayspannung einschalten
cbi Portd, Busy				;Busy lschen

in temp, WDTCR
ori temp, (1<<WDCE) | (1<<WDE)
out WDTCR, temp
ldi temp, (1<<WDE) | (1<<WDP2)
out WDTCR, temp
wdr
sei

DataOut:
	sbrs Flags, Frame		;Delay, um exakt 75fps zu erreichen. Eventuelle Verzgerungen durch Interrupts werden dadurch ausgeglichen
	rjmp DataOut
	cbr Flags, (1<<Frame)
Xshift:
	ld temp, Z+
	ld temp, Z+
	ld temp, Z+
	ld temp, Z+
	cpi AdresseLow, 164
	brlo XShift

	sbi portd, LP			;HSync
	nop
	nop
	cbi portd, LP			;HSync

	cbi portd, FLM			;VSync Ende

	cpi AdresseHigh, 245	;VSync ?
	brne SkipFLM
	sbi portd, FLM
	wdr						;Watchdog Reset beim VSync
	ldi AdresseHigh, 3		;Adresszhler Reset
SkipFLM:

	clr AdresseLow			;Adresszhler auf nchste Zeile setzen
	inc AdresseHigh
	rjmp DataOut

Write:
	sbi portd, Busy
	in r9, sreg
	sbrc temp2, CD			;Befehl oder Daten ?	(gesetzt fr Com, gelscht fr Dat)
	rjmp Comm
Daten:
	cpi NextOp, 0			;Paramter oder Daten ?
	brne Next
	sbi portd, XSCL
	sbrc Flags, ZeileH
	rjmp untereHalfte

obereHalfte:
	ld temp2, X
	andi temp2, 15			;obere Datenhlfte behalten
	mov temp3, temp
	andi temp3, 240			;erste Hlfte behalten
	or temp2, temp3
	st X+,temp2

	ld temp2, X
	andi temp2, 15			;obere Datenhlfte behalten
	swap temp
	andi temp, 240			;erste Hlfte behalten
	or temp2, temp
	st X+,temp2

	cpi XAdresseLow, 160	;Spalten Adresse > Max ?
	brne normal
	clr XAdresseLow			;Spalten Adresse = 0
	inc ZeileL				;Zeilen Adresse ++
	cpi ZeileL, 244			;Zeilen Adresse in untere Displayhlfte  ?
	brne normal
	ldi ZeileL, 4			;Zeile = Beginn XRAM
	sbr Flags, (1<<ZeileH)	;MSB Spalten Adresse = Displayhlfte
	cbi portd, XSCL
	out sreg, r9
	out GIFR, voll
	cbi portd, Busy
reti

untereHalfte:
	swap temp
	ld temp2, X
	andi temp2, 240			;untere Datenhlfte behalten
	mov temp3, temp
	andi temp3, 15			;erste Hlfte behalten
	or temp2, temp3
	st X+,temp2

	ld temp2, X
	andi temp2, 240			;untere Datenhlfte behalten
	swap temp
	andi temp, 15			;erste Hlfte behalten
	or temp2, temp
	st X+,temp2

	cpi XAdresseLow, 160	;Spalten Adresse > Max ?
	brne normal
	clr XAdresseLow			;Spalten Adresse = 0
	inc ZeileL			
	cpi ZeileL, 244			;Zeilen Adresse in untere Displayhlfte  ?
	brne normal
	ldi ZeileL, 4			;Zeile = Beginn XRAM
	cbr Flags, (1<<ZeileH)	;MSB Spalten Adresse = Displayhlfte
normal:
	cbi portd, XSCL			
	out sreg, r9
	out GIFR, voll
	cbi portd, Busy
reti

Next:
	cpi Nextop, 1			;Lade Zeilenadresse
	brne skipn1	
	ldi ZeileL, 4
	add ZeileL, temp
	brcs overflow
	ldi Nextop, 2
	out sreg, r9
	out GIFR, voll
	cbi portd, Busy
	reti
overflow:
	ldi ZeileL, 4	
	ldi Nextop, 2
	out sreg, r9
	out GIFR, voll
	cbi portd, Busy
	reti

skipn1:
	cpi Nextop, 2			;Lade Spaltenadresse + MSB Zeilenadresse
	brne skipn2
	mov XAdresseLow, temp
	lsl XAdresseLow

	bst temp, 7				;Lade Zeilenadresse MSB
	bld Flags, ZeileH
	ldi Nextop,0
	out sreg, r9
	out GIFR, voll
	cbi portd, Busy
	reti
skipn2:
	ldi Nextop,0
	out sreg, r9
	out GIFR, voll
	cbi portd, Busy
reti

Comm:
	clr Nextop
	cpi temp, 1				;Set Adress
	brne skip1
	ldi Nextop,1
	out sreg, r9
	out GIFR, voll
	cbi portd, Busy
	reti
skip1:
	clr Nextop
	cpi temp, 10			;Clear Line
	brne skip10
	sbrc Flags, ZeileH		;Untere Displayhlfte ?
	rjmp Lower
	clr XAdresseLow
	sbi portd, XSCL
czeil:	
	ld temp, X
	andi temp, 15			;Obere Hlfte lschen, untere behalten
	st X+, temp
	cpi XAdresseLow, 160
	brne czeil
	cbi portd, XSCL
	clr XAdresseLow
	inc ZeileL
	cpi ZeileL, 244
	brne exint1
	ldi ZeileL, 4
	sbr Flags, (1<<ZeileH)
exint1:
	ldi Nextop,0
	out sreg, r9
	out GIFR, voll
	cbi portd, Busy
	reti
Lower:
	clr XAdresseLow
	sbi portd, XSCL
czeil1:	
	ld temp, X
	andi temp, 240			;Untere Hlfte lschen, obere behalten
	st X+, temp
	cpi XAdresseLow, 160
	brne czeil1
	cbi portd, XSCL
	clr XAdresseLow
	inc ZeileL
	cpi ZeileL, 244
	brne exint1
	ldi ZeileL, 4
	cbr Flags, (1<<ZeileH)
	ldi Nextop,0
	out sreg, r9
	out GIFR, voll
	cbi portd, Busy
	reti
skip10:
	cpi temp, 11			;Clear LCD
	brne skip11
	clr XAdresseLow
	ldi ZeileL, 4
czeil2:	
	st X+, null
	st X+, null
	st X+, null
	st X+, null
	st X+, null
	st X+, null
	st X+, null
	st X+, null
	cpi XAdresseLow, 160
	brne czeil2
	sbi portd, LP			;HSync simulieren
	clr XAdresseLow
	inc ZeileL
	cbi portd, LP			;HSync simulieren
	cpi ZeileL, 244
	brne czeil2
	ldi ZeileL, 4
	cbr Flags, (1<<ZeileH)
skip11:
	mov temp2, temp
	andi temp2, 240
	cpi temp2, 16			;Set/Clear Pixel
	brne skip16
	clr Nextop
	sbi portd, XSCL
	mov temp2, temp			;in temp ist nur noch Bit 3 wichtig: setzen oder lschen von Pixel ?
	sbrs temp2, 3			;>Bit3 ? Dann im nchsten Byte lesen
	inc XAdresseLow
	andi temp2, 3			;zu lschendes Bit (Bit 0-39	
	clr temp3 
	clc
	inc temp2
	ser temp3
pow:
	rol temp3	
	dec temp2
	brne pow				;temp3 enthlt nun (1<<temp2) (invertiert)
	sbrc Flags, ZeileH
	swap temp3				;Nibbles vertauschen, fr obere Hlfte
	ld temp2, X
	and temp2, temp3		;Bit lschen, restliche Bits behalten
	sbrs temp, 3			;Pixel lschen ? Wenn ja, dann sind wir fertig
	rjmp fertig
	com temp3				;zu Setzendes Bit auf 1 schalten
	or temp2, temp3			;Bit lschen, restliche Bits behalten
fertig:
	st X+, temp2
	sbrc temp, 3			;<Bit4 ? Dann ein Byte berspringen
	inc XAdresseLow
	cpi XAdresseLow, 160
	brne exint
	inc ZeileL
	cpi ZeileL, 244
	brne exint
	ldi ZeileL, 4
	sbrs Flags, ZeileH
	rjmp setbit
	cbr Flags, (1<<ZeileH)
	out sreg, r9
	out GIFR, voll
	cbi portd, Busy
	reti
setbit:
	sbr Flags, (1<<ZeileH)
	out sreg, r9
	out GIFR, voll
	cbi portd, Busy
reti
	
skip16:

exint:
	out sreg, r9
	out GIFR, voll
	cbi portd, Busy
reti







