//*****************************************************************************
//* BootLoader 3.1avr-gcc for MegaLoad 3.0							 						 
//* 		
//* Devices supported at this time	  	  										 
//* ATMega8	  	  										 
//* ATMega16												 
//* ATMega32												 
//* ATMega64												 
//* ATMega128											 
//* ATMega162											 
//* ATMega169											 
//* ATMega8515											 
//* ATMega8535		
//* ATMega2313 not tested, please give me feedback!									 
//* 														 
//* Version 3.0 Dec 2003								 
//* 1.0 : First Release									 
//* 1.1 : Add auto baud rate, code smaller				 
//* 1.2 : Correct a bug with file larger than 65280 bytes.
//* 2.0 : All in one source file that fit in 512 Words  
//* 3.0 : Add EEprom programming 
//* 	  Add RS485 half duplex support   
//* 	  Add LockBit programming
//* 3.1 : Correct a problem with interupt vector for M8/16/32/162/8515/8535
//*		  Change some #define to be more clear
//* 3.1avr-gcc : First version for the avr-gcc compiler.
//*              - No 512kB possible, so you should include EEPROM
//*              - Autobaud not working as expected.
//*              Modifications: Werner Boellmann 
//* 	   	 	   											 
//* Sylvain.Bissonnette@MicroSyl.com						 
//*****************************************************************************
//
// To setup the bootloader for your project you must
// remove the comment below to fit with your hardware
// recompile it using ICCAVR setup for bootloader
// with 1024 word for flash and eeprom programming.
//
//*****************************************************************************
#include <avr/io.h>
#include <avr/interrupt.h>

//*****************************************************************************
// Bootload on UART x
//*****************************************************************************
//#define UART        0
#define UART       1

//*****************************************************************************
// BaudRate
// If you don't specify the baudrate divisor the bootloader
// will automaticaly be in AutoBaudRate mode
//*****************************************************************************
#if !defined (BAUDRATE)
//#define BAUDRATE     38400
#endif
//*****************************************************************************
// Crystal speed
// frequancy of your MCU speed
// LOW  -> Xtal < 8Mhz
// HIGH -> Xtal >= 8Mhz
//*****************************************************************************
#if (F_CPU < 8000000)
  #define LOW
#else  
  #define HIGH
#endif  

//*****************************************************************************
// EEprom programming
// enable EEprom programing via bootloader
// YOU MUST SET TO 1024 WORD THE BOOTLOADER SIZE IF EEPROM
// PROGRAMMING IS USE
//*****************************************************************************
#define EEPROM

//*****************************************************************************
// LockBit programming
// enable LOCKBIT programing via bootloader
//*****************************************************************************
//#define LOCKBIT

//*****************************************************************************
// RS485
// if you use RS485 half duplex for bootloader 
// make the appropriate change for RX/TX transceiver switch
//*****************************************************************************
//#define RS485DDR	DDRB
//#define RS485PORT	PORTB
//#define RS485TXE	0x08

//*****************************************************************************
// HomeNet
// Only use for Sylvain Bissonnette personal projects
// For normal use don't define HOMENET
//*****************************************************************************
//#define HOMENET

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//!!!!!!!!!!!!!! DO NOT CHANGE ANYTHING BELOW THIS LINE !!!!!!!!!!!!!!!!!!!!!!!
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

#define Tiny2313   	   	  'O'
#define Tiny13			  'P'
#define Mega8			  'A'
#define Mega16			  'B'
#define Mega32			  'E'
#define Mega48			  'L'
#define Mega64			  'C'
#define Mega88			  'M'
#define Mega128			  'D'
#define Mega162			  'F'
#define Mega163			  'J'
#define Mega168			  'N'
#define Mega169			  'G'
#define Mega323			  'K'
#define Mega8515		  'H'
#define Mega8535		  'I'


#define Flash1k	   	   	  'g'
#define Flash2k			  'h'
#define Flash4k			  'i'
#define Flash8k			  'l'
#define Flash16k		  'm'
#define Flash32k		  'n'
#define Flash64k		  'o'
#define Flash128k		  'p'
#define Flash256k		  'q'

#define EEprom64		  '.'
#define EEprom128		  '/'
#define EEprom256		  '0' 
#define EEprom512		  '1'
#define EEprom1024		  '2'
#define EEprom2048		  '3'
#define EEprom4096		  '4'

#define Boot128		  	  'a'
#define Boot256		  	  'b'
#define Boot512		  	  'c'
#define Boot1024	  	  'd'
#define Boot2048	  	  'e'
#define Boot4096	  	  'f'

#define Page32		  	  'Q'
#define Page64		  	  'R'
#define Page128		  	  'S'
#define Page256		  	  'T'
#define Page512		  	  'U'


//#if (((MEGATYPE == 64) || (MEGATYPE == 128) || (MEGATYPE == 162)) && !(defined UART))
#if ((defined(__AVR_ATmega64__) || defined(__AVR_ATmega128__) || defined(__AVR_ATmega162__)) && !(defined UART))
  #error "UART ch must be defined for this part"
#endif
/*
 * :-(( Because of the "huge" startup code of avr-libC startup code, no Boot512 is possible (no trick helps). 
 */
//#ifdef EEPROM
  #define	 BootSize	 Boot1024
//#endif

//#ifndef EEPROM
//  #define	 BootSize	 Boot512
//#endif

#if defined(__AVR_ATmega8__)
#define	 DeviceID  	 	 Mega8
#define	 FlashSize	 	 Flash8k
#define	 PageSize	 	 Page64
#define	 EEpromSize	 	 EEprom512
#define  PageByte 	 	 64 
#define  NSHIFTPAGE	 	 6
#define	 INTVECREG	 	 GICR
#define  PULLUPPORT  	 PORTD
#define	 PULLUPPIN	 	 0x01
#endif

#if defined(__AVR_ATmega16__)
#define	 DeviceID  	 	 Mega16
#define	 FlashSize	 	 Flash16k
#define	 PageSize	 	 Page128
#define	 EEpromSize	 	 EEprom512
#define  PageByte 	 	 128    
#define  NSHIFTPAGE	 	 7
#define	 INTVECREG	 	 GICR
#define  PULLUPPORT  	 PORTD
#define	 PULLUPPIN	 	 0x01
#endif

#if defined(__AVR_ATmega32__)
#define	 DeviceID  	 	 Mega32
#define	 FlashSize	 	 Flash32k
#define	 PageSize	 	 Page128
#define	 EEpromSize	 	 EEprom1024
#define  PageByte 	 	 128   
#define  NSHIFTPAGE	 	 7
#define	 INTVECREG	 	 GICR
#define  PULLUPPORT  	 PORTD
#define	 PULLUPPIN	 	 0x01
#endif

#if defined(__AVR_ATmega64__)
#define	 DeviceID  	 	 Mega64
#define	 FlashSize	 	 Flash64k
#define	 PageSize	 	 Page256
#define	 EEpromSize	 	 EEprom2048
#define  PageByte 	 	 256   
#define  NSHIFTPAGE	 	 8
#define	 INTVECREG	 	 MCUCR
 #if (UART == 0)
 #define PULLUPPORT		 PORTE
 #define PULLUPPIN	 	 0x01
 #endif
 
 #if (UART == 1)
 #define PULLUPPORT		 PORTD
 #define PULLUPPIN	 	 0x04
 #endif 
#endif

#if defined(__AVR_ATmega128__)
#define	 DeviceID  	 	 Mega128
#define	 FlashSize	 	 Flash128k
#define	 PageSize	 	 Page256
#define	 EEpromSize	 	 EEprom4096
#define  PageByte 	 	 256    
#define  NSHIFTPAGE	 	 8
#define	 INTVECREG	 	 MCUCR
#define  RAMPZ_FLAG 
 #if (UART == 0)
 #define PULLUPPORT	 	 PORTE
 #define PULLUPPIN	 	 0x01
 #endif
 
 #if (UART == 1)
 #define PULLUPPORT	 	 PORTD
 #define PULLUPPIN	 	 0x04
 #endif 
#endif

#if defined(__AVR_ATmega162__)
#define	 DeviceID  	 	 Mega162
#define	 FlashSize	 	 Flash16k
#define	 PageSize	 	 Page128
#define	 EEpromSize	 	 EEprom512
#define  PageByte 	 	 128    
#define  NSHIFTPAGE	 	 7
#define	 INTVECREG	 	 GICR
 #if (UART == 0)
 #define PULLUPPORT	 	 PORTD
 #define PULLUPPIN	 	 0x01
 #endif
 
 #if (UART == 1)
 #define PULLUPPORT  	 PORTB
 #define PULLUPPIN	 	 0x04
 #endif 
#endif

#if defined(__AVR_ATmega169__)
#define	 DeviceID  	 	 Mega169
#define	 FlashSize	 	 Flash16k
#define	 PageSize	 	 Page128
#define	 EEpromSize	 	 EEprom512
#define  PageByte 	 	 128    
#define  NSHIFTPAGE	 	 7
#define	 INTVECREG	 	 MCUCR
#define  PULLUPPORT  	 PORTE
#define	 PULLUPPIN	 	 0x01
#endif

#if defined(__AVR_ATmega8515__)
#define	 DeviceID  	 	 Mega8515
#define	 FlashSize	 	 Flash8k
#define	 PageSize	 	 Page64
#define	 EEpromSize	 	 EEprom512
#define  PageByte 	 	 64    
#define  NSHIFTPAGE	 	 6
#define	 INTVECREG	 	 GICR
#define  PULLUPPORT  	 PORTD
#define	 PULLUPPIN	 	 0x01
#endif

#if defined(__AVR_ATmega8535__)
#define	 DeviceID  	 	 Mega8535
#define	 FlashSize	 	 Flash8k
#define	 PageSize	 	 Page64
#define	 EEpromSize	 	 EEprom512
#define  PageByte 	 	 64    
#define  NSHIFTPAGE	 	 6
#define	 INTVECREG	 	 GICR
#define  PULLUPPORT  	 PORTD
#define	 PULLUPPIN	 	 0x01
#endif

#if defined(__AVR_ATtiny2313__)
#define	 DeviceID  	 	 Tiny2313
#define	 FlashSize	 	 Flash2k
#define	 PageSize	 	 Page32
#define	 EEpromSize	 	 EEprom128
#define  PageByte 	 	 32    
#define  NSHIFTPAGE	 	 5
#define  PULLUPPORT  	 PORTD
#define	 PULLUPPIN	 	 0x01
#endif

// Serial Port defenition

#ifndef UDR
 #define PE UPE
 #if (UART == 0)
 #define  UCSRA 		 UCSR0A
 #define  UCSRB  	 	 UCSR0B
 #define  UCSRC 		 UCSR0C
 #define  UBRRL		 	 UBRR0L
 #define  UBRRH 		 UBRR0H
 #define  UDR		 	 UDR0
 #endif
 
 #if (UART == 1)
 #define  UCSRA 		 UCSR1A
 #define  UCSRB  	 	 UCSR1B
 #define  UCSRC 		 UCSR1C
 #define  UBRRL		 	 UBRR1L
 #define  UBRRH 		 UBRR1H
 #define  UDR		 	 UDR1
 #endif 
#endif

#define  FALSE		 	 0
#define  TRUE		 	 1

/*********************************************************/
/*                   I N C L U D E    		             */
/*********************************************************/	
#include "assembly.h"

/*********************************************************/
/*           P R O T O T Y P E 							 */
/*********************************************************/	
void FlashLoad(void);
void EEpromLoad(void);
void WriteEEprom(void);
char CheckEEprom(void);
void EEPROMwrite(int location, unsigned char byte);
unsigned char EEPROMread(int location);
void SendDeviceID(void);
void GetPageNumber(void);
void ExecCode(void);
char GetPage(void);
void WriteFlash(void);
char CheckFlash(void);
void LockBit(void);
#define IsChar() (UCSRA & 0x80)
//unsigned char IsChar(void);
#define RxChar() (UDR)
//unsigned char RxChar(void);
unsigned char getRxChar(void);
void TxChar(unsigned char ch);
void Wait(void);
char HomeNet(void);
int main(void);

/*****************************************************************************/
/*           G L O B A L    V A R I A B L E S			                     */
/*****************************************************************************/	
unsigned char PageBuffer[PageByte];
unsigned int PageAddress;
unsigned int RealPageAddress;

/*****************************************************************************/
/* Flash Programing Code								                     */
/*****************************************************************************/
void FlashLoad(void)
{
    TxChar('!');
    while (1)
	{
	    GetPageNumber();

	    if (RealPageAddress == 0xffff) 
	        return;

	    if (GetPage())
		{
		    WriteFlash();
		    if (CheckFlash()) 
		        TxChar('!');
		    else
            {
		        TxChar('@');
            }
		}
	    else 
	        TxChar('@');
	 }
}

/*****************************************************************************/

void GetPageNumber(void)
{
    unsigned char PageAddressHigh;
    unsigned char PageAddressLow;

    PageAddressHigh = getRxChar();

    PageAddressLow = getRxChar();

    RealPageAddress = (int)((PageAddressHigh << 8) + PageAddressLow);
    PageAddress = RealPageAddress << NSHIFTPAGE;

#if defined (RAMPZ)
    if (PageAddressHigh) 
        RAMPZ = 1; 
    else 
        RAMPZ = 0;
#endif
}

/*****************************************************************************/

char GetPage(void)
{
    unsigned int i;
    unsigned char LocalCheckSum = 0;
    unsigned char CheckSum = 0;

    for (i=0;i<PageByte;i++)
	{
	    PageBuffer[i] = getRxChar();
	    LocalCheckSum += PageBuffer[i];
   	}
		   
    CheckSum = getRxChar(); 
    return (LocalCheckSum == CheckSum);
}

/*****************************************************************************/

void WriteFlash(void)
{
    unsigned int i;
    unsigned int TempInt;

    for (i=0; i<PageByte; i+=2)
   	{
   	    TempInt = PageBuffer[i] + (PageBuffer[i+1]<<8);
   	    fill_temp_buffer(TempInt,i);    //call asm routine.
   	}
	
    write_page(PageAddress,0x03);       //Perform page ERASE
    write_page(PageAddress,0x05);       //Perform page write
   
    enableRWW();
}

/*****************************************************************************/

char CheckFlash(void)
{
    unsigned int i;							
    unsigned int TempInt;
    unsigned int TempInt2;

    for (i=0;i<PageByte;i+=2)
    {
	    TempInt = read_program_memory(PageAddress + i,0x00);
	    TempInt2 = PageBuffer[i] +(PageBuffer[i+1]<<8);
	    if (TempInt != TempInt2)    
	        return 0;
    }
    return 1;
}

/*****************************************************************************/
/* EEprom Programing Code								                     */
/*****************************************************************************/
#ifdef EEPROM
void EEpromLoad()
{
    unsigned char ByteAddressHigh;
    unsigned char ByteAddressLow;
    unsigned int ByteAddress;
    unsigned char Data;
    unsigned char LocalCheckSum;
    unsigned char CheckSum;

    TxChar(')');
    TxChar('!');
    while (1)
	{
	    LocalCheckSum = 0;
	  
	    ByteAddressHigh = getRxChar();
	    LocalCheckSum += ByteAddressHigh;
	  
	    ByteAddressLow = getRxChar();
	    LocalCheckSum += ByteAddressLow;
	  
	    ByteAddress = (ByteAddressHigh<<8)+ByteAddressLow;
	  
	    if (ByteAddress == 0xffff) 
	        return;
	  
	    Data = getRxChar();
	    LocalCheckSum += Data;
	  
	    CheckSum = getRxChar();	
	  
	    if (CheckSum == LocalCheckSum)	
	  	{  
		    EEPROMwrite(ByteAddress, Data);
	  	    if (EEPROMread(ByteAddress) == Data) 
	  	        TxChar('!');
	  	    else 
	  	        TxChar('@');
		}
	    else
	    {
		    TxChar('@');
		}
	}
}
#endif

/*****************************************************************************/

#ifdef EEPROM
void EEPROMwrite( int location, unsigned char byte)
{
    while (EECR & 0x02)    // Wait until any earlier write is done
        ;
    EEAR = location;
    EEDR = byte;
    EECR |= 0x04;          // Set MASTER WRITE enable
    EECR |= 0x02;          // Set WRITE strobe
} 
#endif         

/*****************************************************************************/

#ifdef EEPROM
unsigned char EEPROMread( int location)
{
    while (EECR & 0x02)
        ;
    EEAR = location;
    EECR |= 0x01;                       // Set READ strobe
    return (EEDR);                      // Return byte
}
#endif 

/*****************************************************************************/
/* LockBit Code										                         */
/*****************************************************************************/
#ifdef LOCKBIT
void LockBit(void)
{
    unsigned char Byte;

    TxChar('%');

    Byte = getRxChar();

    if (Byte == ~getRxChar()) 
        write_lock_bits(~Byte);
}
#endif
/*****************************************************************************/
/* Serial Port Code										                     */
/*****************************************************************************/
/*****************************************************************************/
unsigned char getRxChar(void)
{
    while(!IsChar())
        ;
    return UDR;
}

/*****************************************************************************/
void TxChar(unsigned char ch)
{
    while(!(UCSRA & 0x20))   // wait for empty transmit buffer
        ;
#ifndef RS485DDR
    UDR = ch;     	 		 // write char
#endif

#ifdef RS485DDR
    RS485PORT |= RS485TXE;	 // RS485 in TX mode
    UDR = ch;     	 		 // write char
    while(!(UCSRA & 0x40))   // Wait for char to be cue off
        ;
    UCSRA |= 0x40;			 // Clear flag
    RS485PORT &= ~RS485TXE;	 // RS485 in RX mode
#endif
}

/*****************************************************************************/
/* Helpers Code											                     */
/*****************************************************************************/
void Wait()
{
    int i;
#ifdef LOW 
    for (i=0;i<32000;i++)
        asm volatile ("nop" ::);
#endif
#ifdef HIGH 
    for (i=-32000;i<32000;i++)
        asm volatile ("nop" ::);
#endif
}

/*****************************************************************************/

void SendDeviceID(void)
{
    TxChar(DeviceID);
    TxChar(FlashSize);
    TxChar(BootSize);
    TxChar(PageSize);
    TxChar(EEpromSize);
    RxChar();
}

/*****************************************************************************/

void ExecCode(void)
{
#if defined (RAMPZ)
    RAMPZ = 0;
#endif
#if defined (INTVECREG)
    INTVECREG = 0x01;	   	 // Enable interrupt vector select
    INTVECREG = 0x00;	   	 // Move interrupt vector to flash
#endif
    asm("jmp 0x0000" : :);       // Run application code   
}

/*****************************************************************************/
#ifdef HOMENET
char HomeNet(void)
{
    unsigned char i;
    unsigned char Exec = 0;
    unsigned char Boot = 0;
    unsigned char Address;

    EEAR = 0x01;
    EECR |= 0x01;                       // Set READ strobe
    Address = EEDR;                     // Return byte

    while(1)
	{
		i = getRxChar();
		
		if (i == '>') 
		    Exec++;
		else 
		    Exec = 0;
		
		if (i == '+') 
		    Boot++;
		else 
		    Boot = 0;
		
		if (Exec >= 3) 
		    return 1;
		if (Boot >= 5) 
		{
		    if (getRxChar() != Address) 
		        return 1;
		    return 0;
	    }
    }
    return 1;
}
#endif
/*****************************************************************************/

int main(void)
{
    cli();          		      // disable all interrupts

    PULLUPPORT = PULLUPPIN;       // Pull up on RX line

    UCSRB = 0x00; 				  //disable while setting baud rate
    UCSRA = 0x00; 
    UCSRC = 0x86; 				  // Asyn,NoParity,1StopBit,8Bit,
    UBRRH = 0x00; 				  //set baud rate hi
    UCSRB = 0x18; 				  // Rx enable Tx Enable

#ifdef RS485DDR
    RS485DDR |= RS485TXE;		  // RS485 Tranceiver switch pin as output
    RS485PORT &= ~RS485TXE;		  // RS485 in Rx mode 
#endif

// Fr c't Microkontroller im Lan Projekt
#if defined (CT_PROJ)
    DDRB  |= 0x07;  // Multiplexleitungen seriell PB0-2 als Ausgang
#if defined (DEST_XPORT)
    PORTB &= 0xFC;  // 0bxxxxxx00                   // PB0=0; PB1=0  ==> Z=Z0 Y=Y0
    PORTB |= 0x04;  // 0b00000100                   // PB2=1 ==> (X=X1)
#else //defined (DEST_COM)
    PORTB |=  0x03; // 0bxxxxxx11                   // PB0=1; PB1=1  ==> Z=Z1 Y=Y1
    PORTB &=  0xFB; // 0bxxxxx0xx                   // PB2=0 ==> (X=X0) (eigentlich don't care)
#endif

	Wait();
#endif

    // Auto-find baudrate if BAUDRATE is undefine

#ifdef BAUDRATE
    {
        UBRRL = (F_CPU/16/BAUDRATE)-1;
#else
    for (unsigned char i = 0; i < 255; ++i)
    {
        UBRRL = i;
#endif

#ifdef HOMENET
	    if (HomeNet()) 
	        ExecCode();
	    Wait();
#endif
        RxChar();
	    TxChar('>');
	    Wait();
        // ADDED wb :: (UCSRA & (_BV(FE)|_BV(UPE))) == 0 &&   :: Framing Error +/* Parity Error is BAD
	    if ((UCSRA & (_BV(FE)|_BV(PE)|_BV(RXC))) == _BV(RXC) && RxChar() == '<') 
	    {
	        SendDeviceID();
	        FlashLoad();
	   #ifdef EEPROM
	        EEpromLoad();
	   #endif
	   #ifdef LOCKBIT
	        LockBit();
	   #endif
	        ExecCode();
	    }
	}
    ExecCode();
    return 0;
}
