#define F_CPU 8000000

#include <stdlib.h>
#include <avr/interrupt.h>   // Interrupts and timers
#include <util/delay.h>      // Blocking delay functions
#include <avr/wdt.h>     // Watchdog timer to repair lockups
#include <avr/sleep.h>

#include "system/header/nano_os.h"
#include "user/user.h"

#include "user/user.c"
//#include "system/util.c"
#include "system/scheduler.c"
#include "system/kernel.c"
#include "system/tasks.c"
#include "system/idle.c"

#ifdef TASK_USE_MEM
#include "system/memory.c"
#endif

#ifdef TASK_USE_MESSAGE
#include "system/message.c"
#endif

#ifdef TASK_USE_SEMAPHORE
#include "system/semaphore.c"
#endif

int main()
{
  kernel();
}
