//+++++++++++++++++++++GLOBAL DEFINE+++++++++++++++++++

// undefine to save memory if signal & wait are not needed
// #define TASK_USE_SIGNAL

// undefine to save memory if task anhilate is not needed
#define TASK_USE_ANHILATE

// undefine to save memory if message queue is not needed
#define TASK_USE_MESSAGE

// undefine to save memory if semaphore is not needed
// #define TASK_USE_SEMAPHORE

// undefine to save memory if memory management is not needed
#define TASK_USE_MEM

// supported / tested devices
#if defined (__AVR_ATmega168__)
#define RAMSTART 	0x60
#define HEAPSTART	0x02FF
#define STACK_SIZE	64
#define TIMER_REG	TCCR0B
#define TIMER_ENABLE	TIMSK0
#define TIMER_VECTOR	TIMER0_OVF_vect
#define CLK1		_BV(CS00)
#define CLK1024		_BV(CS02) |_BV(CS00)
#else
#	error "unsupported device"
#endif

//some values

#define TRUE 1
#define FALSE 0
#define ERR 255

//makros

#define TASK_ENTER_CRITICAL sreg=SREG;wdt_disable();cli()
#define TASK_LEAVE_CRITICAL sei();wdt_enable(WDTO_2S);SREG=sreg
#define MULTITASKING_DISABLE wdt_disable(); TIMER_ENABLE &= ~_BV(TOIE0)
#define MULTITASKING_ENABLE wdt_enable(WDTO_2S); TIMER_ENABLE |= _BV(TOIE0)
#define CONVERT_POINTER_TYPE_TO_MESSAGE(pointer) (void*)pointer
#define CONVERT_POINTER_TYPE_FROM_MESSAGE(message,type) (type)message.pointer


//+++++++++++++++++++++++++MAX TASKS++++++++++++++++++++
// max number of tasks (depending on ram size)
#define NUMBER ((RAMEND-RAMSTART-100)/(STACK_SIZE+2))

//+++++++++++++++++++TASK Function Dummy++++++++++++++++
typedef void (*TaskFunction)();

//+++++++++++++++++++TASK Priorities++++++++++++++++++++
// times & cycles at CLK/1024:
typedef enum TaskPriority
{
	TaskPriorityLow		= 0xff,	// 1024 cycles
	TaskPriorityMedium	= 0xc0,	// 64*1024 cycles
	TaskPriorityHigh	= 0x00	// 256*1024 cycles
} TaskPrio;

//++++++++++++++++++TASK State++++++++++++++++++++++++++
#ifdef TASK_USE_SIGNAL
typedef enum TaskState
{
	TaskStateActive = 0, 
	TaskStateWaiting = 1,
	TaskStateWaitForLaps = 2
} TaskState;
#endif

//+++++++++++++++++TASK Control Structure+++++++++++++++
typedef volatile struct Task
{
	volatile uint8_t ID;
	volatile unsigned char sreg;
	volatile unsigned char *sp;
	volatile TaskPrio prio;
#ifdef TASK_USE_SIGNAL
	volatile TaskState state;
	volatile uint8_t laps;
#endif
	volatile unsigned char stack[STACK_SIZE];
} Task;

//+++++++++++++++++++++++SEMAPHORE+++++++++++++++++++++

#ifdef TASK_USE_SEMAPHORE

typedef volatile struct Semaphor
{
volatile uint8_t owner;
} Semaphor;

#endif

//+++++++++++++++++++++MESSAGE QUEUE+++++++++++++++++++

#ifdef TASK_USE_MESSAGE
#define MAXQUEUEDEPTH 2

typedef volatile struct Queue
{
volatile uint8_t item_size;
volatile uint8_t queueDepth;
volatile uint8_t number;
volatile void* ptr;
volatile unsigned char *message;
} Queue;

#endif

//+++++++++++++++++MEMORY MANAGEMENT+++++++++++++++++++
#ifdef TASK_USE_MEM
#define MAXBLOCKS 2
#define BLOCKSIZE 1

typedef volatile struct mem_block_intern
{
volatile uint8_t owner;
volatile void* ptr;
} mem_block_intern;

static volatile char data[MAXBLOCKS*BLOCKSIZE];
static volatile mem_block_intern blocks[MAXBLOCKS];

#endif

//+++++++++++++++++++++++PROTOTYPE+++++++++++++++++++++

static void kernel();
void scheduler();
void idle();

static void init_user_environment();

#ifdef TASK_USE_MESSAGE
uint8_t queue_init(Queue *qp, uint8_t MessageQueueDepth, uint8_t item_size);
uint8_t queue_anhilate(Queue *qp);
uint8_t queue_exists(Queue *qp); 
uint8_t queue_get_maximum_size(Queue *qp); 
uint8_t queue_get_free_size(Queue *qp);
uint8_t queue_get_mumber_of_messages(Queue *qp);
uint8_t queue_wait_for_message(Queue *qp);
unsigned char queue_read_byte(Queue *qp, uint8_t position, uint8_t delete_message);
uint8_t queue_read_item(Queue *qp, unsigned char* targetpointer, uint8_t position, uint8_t delete_message);
void* queue_read_pointer (Queue *qp);
uint8_t queue_write_byte (Queue *qp, unsigned char message);
uint8_t queue_write_item(Queue *qp, void* startpointer);
uint8_t queue_write_pointer (Queue *qp, void* pointer);
#endif

#ifdef TASK_USE_SEMAPHORE
void semaphore_init(Semaphor *s);
uint8_t semaphore_set(Semaphor *s);
uint8_t semaphore_free(Semaphor *s);
uint8_t semaphore_read(Semaphor *s);
uint8_t semaphore_wait(Semaphor *s);
#endif

#ifdef TASK_USE_MEM
uint8_t memory_get_free_blocks();
void* memory_allocate_block();
uint8_t memory_free_block(void* ptr);
#endif

void task_create(Task *t, TaskFunction f, TaskPrio prio);
void task_switch();
uint8_t task_new_prio(TaskPrio prio);

#ifdef TASK_USE_ANHILATE
uint8_t task_anhilate(Task *t);
#endif

#ifdef TASK_USE_SIGNAL
void task_signal(Task *t);
void task_wait(Task *t);
void task_wait_for_laps(Task *t, uint8_t laps);
#endif

//+++++++++++++++++++++Signal-Handler++++++++++++++++++

SIGNAL (SIG_OVERFLOW0)
{
scheduler();
}

//++++++++++++++++++++GlOBAL VARIABLES+++++++++++++++++

static volatile signed char currentTask = -1;
#ifdef TASK_USE_MEM
static volatile uint8_t currentBlocks = 0;
#endif
static volatile Task *tasks[NUMBER];
Task *current = 0;
static volatile uint8_t sreg = 0, sregsys = 0;



