#define PUSH(r) asm volatile("push r"#r)
#define POP(r) asm volatile("pop r"#r)

//****************************************************
//*scheduler()                                       *
//*                                                  *
//*      !!!INTERNAL FUNCTION!!!                     *
//*                                                  *
//* description: does the task switching             *
//* input: none                                      *
//* output: none                                     *
//****************************************************

void scheduler()
{
//save R0-31 to current->stack
PUSH(31);PUSH(30);PUSH(29);PUSH(28);PUSH(27);PUSH(26);PUSH(25);PUSH(24);
PUSH(23);PUSH(22);PUSH(21);PUSH(20);PUSH(19);PUSH(18);PUSH(17);PUSH(16);
PUSH(15);PUSH(14);PUSH(13);PUSH(12);PUSH(11);PUSH(10);PUSH( 9);PUSH( 8);
PUSH( 7);PUSH( 6);PUSH( 5);PUSH( 4);PUSH( 3);PUSH( 2);PUSH( 1);PUSH( 0);
TIMER_REG = CLK1024;
//save SREG and SP
if (currentTask >= 0)
	{
	current = tasks[currentTask];
	current->sreg = SREG;
	current->sp = (unsigned char *)(SP + 32);
	}
//switch to next task
do
	{
	currentTask++;
	if (currentTask >= NUMBER)
		{
		currentTask = 0;
		}
	current = tasks[currentTask];

	#ifdef TASK_USE_SIGNAL
	if (current && current->state == TaskStateWaitForLaps)
		{
		if (current->laps > 0)
			current->laps--;
		else
			current->state=TaskStateActive;
		}
	#endif

	}

#ifdef TASK_USE_SIGNAL
while (!(current && current->state==TaskStateActive));
#else
while (!current);
#endif

//restore this task (SREG, SP and R0...31)
if (current)
	{
	TCNT0 = current->prio;
	SREG = current->sreg;
	SP = (unsigned int)(current->sp - 32);
	}
POP( 0);POP( 1);POP( 2);POP( 3);POP( 4);POP( 5);POP( 6);POP( 7);
POP( 8);POP( 9);POP(10);POP(11);POP(12);POP(13);POP(14);POP(15);
POP(16);POP(17);POP(18);POP(19);POP(20);POP(21);POP(22);POP(23);
POP(24);POP(25);POP(26);POP(27);POP(28);POP(29);POP(30);POP(31);
asm volatile("reti");
}

