//****************************************************
//*semaphore_init(Semaphor *s)                       *
//*                                                  *
//* description: init semaphores                     *
//* input: Pointer to Semaphore                      *
//* output: none                                     *
//****************************************************

void semaphore_init(Semaphor *s)
{
s->owner = 0;
}

//****************************************************
//*semaphore_set(Semaphor *s)                        *
//*                                                  *
//* description: set semaphore                       *
//* input: Pointer to Semaphore                      *
//* output: TRUE(ok), NULL(error)                    *
//****************************************************

uint8_t semaphore_set(Semaphor *s)
{
sregsys = SREG;
cli();
if (s->owner != 0) 
	{
	SREG = sregsys;
	return 0;
	}
s->owner = currentTask ;
SREG = sregsys;
return TRUE;
}

//****************************************************
//*semaphore_free(Semaphor *s)                       *
//*                                                  *
//* description: free semaphore                      *
//* input: Pointer to Semaphore                      *
//* output: TRUE(ok), NULL(error)                    *
//****************************************************

uint8_t semaphore_free(Semaphor *s)
{
sregsys = SREG;
cli();
if (s->owner != currentTask) 
	{
	SREG = sregsys;
	return 0;
	}
s->owner = 0;
SREG = sregsys;
return TRUE;
}

//****************************************************
//*semaphore_read(Semaphor *s)                       *
//*                                                  *
//* description: read status of a semaphore          *
//* input: Pointer to Semaphore                      *
//* output: TRUE(free), NULL(error/non free)         *
//****************************************************

uint8_t semaphore_read(Semaphor *s) 
{
sregsys = SREG;
cli();
if (s->owner)
	{
	SREG = sregsys;
	return 0;
	}
SREG = sregsys;
return TRUE;
}

//****************************************************
//*semaphore_wait(Semaphor *s)                       *
//*                                                  *
//* description: wait for a semaphore                *
//* input: Pointer to Semaphore                      *
//* output: TRUE(is free), NULL(error)               *
//****************************************************

uint8_t semaphore_wait(Semaphor *s) 
{ 
//enable multitasking to avoid a deadrun 
wdt_enable(WDTO_2S); 
TIMER_ENABLE |= _BV(TOIE0); 
sei();
while (s->owner != 0)
	TCNT0 = 0xFF;	//Do a task switch if the semaphore is used; ; Do not set this to any other value than 0xFF, it won't work because we are in a loop!
return TRUE;
} 
