//****************************************************
//*task_create(Task *t,TaskFunction f,TaskPrio prio) *
//*                                                  *
//* description: register a task                     *
//* input: Task *t: Pointer to Task                  *
//*        TaskFunction f: Function name             *
//*        Prio: Priority                            * 
//* output: none                                     *
//****************************************************

void task_create(Task *t, TaskFunction f, TaskPrio prio)
{
sregsys = SREG;
cli();
signed char a;
unsigned char *s = (unsigned char *)(t->stack + sizeof(t->stack) - 3);
for (a=31; a>=0; a--) *s-- = 0;
//init kontext: sreg = 0, SP = Pointer to t->stack (which contains the stack section and the PC)
t->sreg = 0;
t->sp = (unsigned char *)(t->stack + sizeof(t->stack) - 3);
t->prio = prio;
t->stack[sizeof(t->stack)-2] = ((unsigned int)f)>>8;
t->stack[sizeof(t->stack)-1] = ((unsigned int)f)&0xff;
#ifdef TASK_USE_SIGNAL
t->state = TaskStateActive;
t->laps = 0;
#endif

for (a=0; a<NUMBER; a++)
	{
	if (!tasks[a])
		{
		t->ID = a;
		tasks[a] = t;
		break;
		}
	}
SREG = sregsys;
return;
}

//****************************************************
//*task_anhilate(Task *t)                            *
//*                                                  *
//* description: delete a task                       *
//*                                                  *
//*           USE WITH CAUTION!                      *
//*                                                  *
//* input: Task *t = Handle to task                  *
//* output: TRUE(ok)/NULL(error)                     *
//****************************************************

#ifdef TASK_USE_ANHILATE
uint8_t task_anhilate(Task *t)
{
sregsys=SREG;
cli();

#ifdef TASK_USE_MEM
uint8_t a,b;
#else
uint8_t a;
#endif

#ifdef TASK_USE_SEMAPHORE
//uint8_t *s = (uint8_t*) Semaphore;
//uint8_t i;
#endif

uint8_t ID = t->ID;
if (ID > NUMBER || ID == 0)
	{
	SREG=sregsys;
	return 0;
	}
a=ID;
//reset task values
if (ID == currentTask)	
	current = 0;	//to avoid problems when deleting the current task
tasks[a] = 0;		//this deletes the task

#ifdef TASK_USE_MEM
//release task memory blocks
//no reason to clear it here, because theres a clearing in memory_allocate_block()
for (a=0;a<currentBlocks;a++)
	{
	if ((blocks+a)->owner == ID)
		{
		(blocks+a)->ptr=0;
		(blocks+a)->owner=0;
		for (b=a;b<(currentBlocks-1);b++)
			blocks[b]=blocks[b+1];
		currentBlocks--;
		}
	}
#endif

#ifdef TASK_USE_SEMAPHORE
//release used semaphores
//for (i=0;i<MAXSEMAPHORE;i++)
//	{
//	if (*s == ID + 1)
//		*s = 0; 
//	s++;
//	}
#endif

if (ID != currentTask)
	{
	//go back to parent task
	SREG=sregsys;
	return TRUE;
	}
else
	{
	//switch to next task without going back to the deleted task if it's the parent task
	TIMER_REG = _BV(CS00);
	TCNT0 = 0xFF;
	currentTask = -1;
	set_sleep_mode(SLEEP_MODE_IDLE);
	sei();
	sleep_mode();
	}
}
#endif

//****************************************************
//*task_switch()                                     *
//*                                                  *
//*      !!!Internal Function!!!                     *
//*                                                  *
//* description: switch task / enable scheduler      *
//* input: none                                      *
//* output: none                                     *
//****************************************************

void task_switch()
{
cli();
set_sleep_mode(SLEEP_MODE_IDLE);
TCNT0 = 0xf0;
TIMER_REG = _BV(CS00);
TIMER_ENABLE |= _BV(TOIE0);
sei();
sleep_mode();
}

//****************************************************
//*task_signal(Task *t)/task_wait                    *
//*                                                  *
//* description: sleep/wake a task                   *
//* input: Task                                      *
//* output: none                                     *
//****************************************************

#ifdef TASK_USE_SIGNAL
void task_signal(Task *t)
{
cli();
t->state = TaskStateActive;
task_switch();
}

// Task Signal - wait 
void task_wait(Task *t)
{
cli();
t->state = TaskStateWaiting;
task_switch();
}

//****************************************************
//*task_wait_for_laps(Task *t, uint8_t laps)         *
//*                                                  *
//* description: sleep a task for a number of laps   *
//* input: Task, number of laps                      *
//* output: none                                     *
//****************************************************

void task_wait_for_laps(Task *t, uint8_t laps)
{
cli();
t->state = TaskStateWaitForLaps;
t->laps = laps;
task_switch();
}
#endif

//****************************************************
//*taskNewPrio(TaskPrio prio)                        *
//*                                                  *
//* description: set new priority for current Task   *
//* input: TaskPrio (low/medium/high)                *
//* output: new TaskPrio                             *
//****************************************************

uint8_t taskNewPrio(TaskPrio prio) {return current->prio = prio;}
