//+++Init user stuff+++
static void init_user_environment()
{
//Create Tasks for displaying minutes, hours and time calculation
task_create(&display_minutes_task, display_minutes, TaskPriorityLow);
task_create(&display_hours_task, display_hours, TaskPriorityLow);
task_create(&time_calc_task, time_calc, TaskPriorityLow);

//init Queues

queue_init(&minutes_queue,1,2);
queue_init(&hours_queue,1,1);
queue_init(&time_calc_queue,1,1);

semaphore_init(&PORTC_semaphor);
semaphore_init(&PORTD_semaphor);

//set DDRB and DDRC as output
DDRC=0xFF;
DDRD=0xFF;

//setup timer2 
TCCR2B = _BV(CS22) | _BV(CS21); // div by 256
// We will overflow 122 times a second, and call an interrupt
// enable interrupt
TIMSK2 = _BV(TOIE2);

//Enable pullup resistor on PIN PB1 and PB2 
PORTB = _BV(PB1) | _BV(PB2);

//These are the interrupts for the buttons
PCICR = _BV(PCIE0);
PCMSK0 = _BV(PCINT1) | _BV(PCINT2);
}

//+++Task functions+++

//this is the display task for the minutes
void display_minutes()
{
if (!(queue_exists(&minutes_queue)) || !(memory_get_free_blocks()))
	task_anhilate(&display_minutes_task);
unsigned char* min_ptr = memory_allocate_block();
char *ptr;
if (min_ptr == 0)
	task_anhilate(&display_minutes_task);
while (1)
	{
	//Wait for new minute message
	queue_wait_for_message(&minutes_queue);
	//set PORTD to new minute value
	queue_read_item(&minutes_queue,min_ptr,0,1);								
	semaphore_wait(&PORTD_semaphor);
	semaphore_set(&PORTD_semaphor);
	PORTD = min_ptr[1];
	semaphore_free(&PORTD_semaphor);
	task_wait_for_laps(&display_minutes_task, 20);
	}
}

//this is the display task for the hours
void display_hours()
{
if (!(queue_exists(&hours_queue)) || !(memory_get_free_blocks()))
	task_anhilate(&display_hours_task);
unsigned char* hrs_ptr = memory_allocate_block();
if (hrs_ptr == 0)
	task_anhilate(&display_hours_task);
while (1)
	{
	//Wait for new hour message
	queue_wait_for_message(&hours_queue);
	//set PORTC to new hour value
	*hrs_ptr = queue_read_byte(&hours_queue,0,1);
	semaphore_wait(&PORTC_semaphor);
	semaphore_set(&PORTC_semaphor);
	PORTC = *hrs_ptr;
	semaphore_free(&PORTC_semaphor);
	task_wait_for_laps(&display_hours_task, 20);
	}
}

//this calculates the time
void time_calc()
{
uint8_t h,m,s,a[2],temp;
unsigned char calc_msg;
while (1)
	{
	//wait for message. A message appears every second or when a button is pressed. 
	queue_wait_for_message(&time_calc_queue);
	calc_msg = queue_read_byte(&time_calc_queue,0,1);
	// if button 1 is pressed increase hours
	if (calc_msg == 1)
		{
		if (h < 23)
			h++;
		else
			h = 0;
		}
	// if button 2 is pressed increase minutes
	else if (calc_msg == 2)
		{
		if (m < 59)
			m++;
		else
			m = 0;
		}
	// else it must be a new second
	else
		{
		TASK_ENTER_CRITICAL;
		s++;
		if (s == 60)
			{
			s = 0;
			m++;
			if (m == 60)
				{
				m = 0;
				h++;
				if (h == 24)
					h = 0;
				}
			}
		TASK_LEAVE_CRITICAL; 
		}
	//send time to display tasks;
	a[0] = 60-m;
	a[1] = m;
	//a[0]=a[2]=a[3]=0;
	queue_write_item(&minutes_queue,a);
	queue_write_byte(&hours_queue,h);
	}
}		 

//+++ISR - Interrupt Service Routine+++

//ISR for Timer2 - Clock timer
void tick_time()
{
static uint8_t zaehler;
zaehler++;
if (zaehler == 122)	 //Interrupt is called @ 8 Mhz / (256*256) = 122 times per second
	{
	//we have a new second so send a message to time_calc task;
	zaehler = 0;
	queue_write_byte(&time_calc_queue, 128); //anything but 1 or 2
	}
//debounce for buttons (enable button interrupts again after 0,3 seconds;
else if (!(zaehler % 30))
	{
	PCMSK0 |= _BV(PCINT1);	
	PCMSK0 |= _BV(PCINT2);	
	}

}

//ISR for Pin Change Interrupts - Buttons

void button_press_12()
{
// button1 is pressed
if (! (PINB & _BV(PB1))) 
	{
	//disable interrupt fpr debounce
	PCMSK0 &= ~_BV(PCINT1);					
	//Button 1 is pressed so send a "1" to time_calc_task
	queue_write_byte(&time_calc_queue, 1);
	return;
	}
// button2 is pressed
if (! (PINB & _BV(PB2))) 
	{
	//disable interrupt fpr debounce
	PCMSK0 &= ~_BV(PCINT2);		
	//Button 2 is pressed so send a "2" to time_calc_task					
	queue_write_byte(&time_calc_queue, 2);
	return;
	}
}

