library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;



entity COUNTER is
  port (	SRAMWE		:out STD_LOGIC;
  		SRAMADDR	:out STD_LOGIC_VECTOR(15 downto 0);	-- Adresse
        	SRAMDATAIN	:out STD_LOGIC_VECTOR(7 downto 0);	-- Daten zum SRAM
        	SRAMDATOUT	:in STD_LOGIC_VECTOR(7 downto 0);	-- Daten vom SRAM
        	FPGACLK		:in STD_LOGIC;
        	SRAMCLK		:out STD_LOGIC;
        	RESET		:in STD_LOGIC        	
        );
end COUNTER;

architecture COUNTER_BEHAV of COUNTER is
SIGNAL write_strb: STD_LOGIC;				-- write-signal
SIGNAL data_reg: STD_LOGIC_VECTOR (7 downto 0);		-- Daten fr den SRAM
SIGNAL sramaddr_reg: STD_LOGIC_vector (15 downto 0);	-- Adresse 


begin

process(fpgaclk)
begin
sramclk <= fpgaclk;
end process;


process(reset,fpgaclk,sramaddr_reg)	-- zhlt die Adressem bis zum Grenzwert hoch
begin
if(reset='0') then
	write_strb <= '1';
	sramaddr_reg <= "0000000001100000";
	sramaddr <= sramaddr_reg;
elsif rising_edge(FPGACLK) then
		if (sramaddr_reg = "0000000011111111") then
					write_strb <= '1';
		else
				write_strb <= write_strb;
				sramaddr_reg <= sramaddr_reg + 1;			
				sramaddr <= sramaddr_reg;
		end if;
end if;
end process;



process(reset,fpgaclk)		-- stellt unterschiedliche Daten bereit
begin
if(reset='0') then
	data_reg <= "00000000";
elsif rising_edge(FPGACLK) then
	if (sramaddr_reg(0)='0') then
		data_reg <= "10101010";
	else
		data_reg <= "01010101";
	end if;
end if;
end process;

process(reset,fpgaclk)		-- schreibt die Daten in den SRAM
begin
if(reset='0') then
	sramdatain <= "00000000";
	sramwe <= '1';
elsif rising_edge(FPGACLK) then
	sramdatain <= data_reg;
	sramwe <= write_strb;
end if;
end process;

end COUNTER_BEHAV;