#include <stdio.h>
#include <time.h>
#include <sys\stat.h>
#include <utime.h>

typedef struct
 {
 int aktiv;
 char Name[200];
 char Formel[200];
 } satz;

double X[1024],Y[1024];
double Ddummy[1024];
int Geduld=0;

#include "parse.h"

FILE *outfile;
satz *feld;
int Inspalten=8,spalten,Minzeit=0,Intervall=0,Startzeit=0,SatzNr=0;
struct stat src_stat;

int Ausg(time_t t)
 {
  int a;
  struct tm *pTime;
  pTime=localtime(&t);
  fprintf(outfile,"%02d.%02d.%04d;%02d:%02d:%02d",pTime->tm_mday,
                                               pTime->tm_mon+1,
                                               pTime->tm_year+1900,
                                               pTime->tm_hour,
                                               pTime->tm_min,
                                               pTime->tm_sec);
  for(a=1;a<spalten;a++)
   {
    if(feld[a].aktiv) fprintf(outfile,";%lf",Y[a]);
   }
 Geduld++;
 if(Geduld>1000)
  {
  Geduld=0;
  printf("\r%02d.%02d.%04d",pTime->tm_mday,
                                               pTime->tm_mon+1,
                                               pTime->tm_year+1900);  
  }  
 fprintf(outfile,"\n");
 return 0;
 }

int main(int argc,char **argv)
 {
 int Separator=',',
      MinInterval=0,
      a,c,umgesetzt=0,monat,jahr;
 double wert;
 FILE *config,*infile;
 char st1[2000],*cp,*cp1,*cp2,ch;
 time_t altzeit,aktzeit;
 struct tm t;
 struct utimbuf times;

 for(a=0;a<1024;a++) X[a]=Y[a]=0;
  
 if(argc<2)
  {
  printf("Benutzung:\nconv <rohdatei> [configdatei] [zieldatei]\n");
  return -1;
  }
 
 strcpy(st1,"config.txt");
 if(argc>2) strcpy(st1,argv[2]);
 /*Konfigurationsdatei ffnen*/
 config=fopen(st1,"r");
 if(!config)
  {
  printf("Configdatei %s nicht gefunden!\n",st1);
  return -1;
  }

 /* Erfassen, wie viele Zeilen Musterzeilen enthalen (mindestens 1 Semikolon) */

 /* erste Zeile lesen */
 spalten=0;
 while(!feof(config))
  {
  /* nchste Zeile lesen */
  memset(st1,0,1990);
  fgets(st1,1990,config);
  if(st1[0]!=' ')		/* Kommentarzeile */
  if(cp=strchr(st1+1,';')) spalten++;
  }
 printf ("%d Spalten\n",spalten);
 rewind(config);
 

 /*Speicher reservieren*/
 feld=calloc(spalten+5,sizeof(satz));
 cp=st1;

 /*Jetzt die Config richtig einlesen*/
 a=0;
 while (!feof(config))
  {
   memset(st1,0,20);
   fgets(st1,1990,config);
   /* CR durch Semikolon ersetzen */
   if(cp=strchr(st1,'\n')) *cp=';';
   
   if(cp=strchr(st1,'='))
    {
     /* Parameterzeile */
     *cp=0;
     cp++;
     cp1=st1;
     if(*cp1=='"') cp1++;
     if(!strcmp(cp1,"Separator"))
      {
      sscanf(cp,"%d;",&Separator);
      }
     if(!strcmp(cp1,"Minzeit"))
      {
      sscanf(cp,"%d;",&Minzeit);
      }
     if(!strcmp(cp1,"Spalten"))
      {
      sscanf(cp,"%d;",&Inspalten);
      }
     if(!strcmp(cp1,"Startzeit"))
      {
      sscanf(cp,"%d;",&Startzeit);
      }
     if(!strcmp(cp1,"Intervall"))
      {
      sscanf(cp,"%d;",&Intervall);
      }
    }
   else
    { 
    c=0;
    cp=st1;
    while(cp=strchr(cp+1,';')) c++;
    if ((c>1)&&(st1[0]!=' '))
    {
      /* Kanalzeile */
     if(cp1=strchr(st1,';'))
      {
      *cp1=0;
      cp1++;		/* Anfang Formel */
      cp=st1;
      if(*cp=='"')
       {
        cp++;
        if(cp2=strchr(cp,'"')) *cp2=0;
       }
      strcpy(feld[a].Name,cp);
      cp=cp1;
      /* Kommas durch Punkte ersetzen*/
      while(cp1=strchr(cp1,',')) *cp1='.';

      if(cp1=strchr(cp,';')) *cp1=0;    
      if(cp1=strchr(cp,' ')) *cp1=0; /* Kommentar nach der Formel */
      strcpy(feld[a].Formel,cp);
      a++;
      }
     }
    }
  } 
 fclose(config);
 printf(" %d gelesene Spalten\n",a);
 spalten=a;	/* so viele haben wir wirklich */
 
 /* Namen durchschauen nach disable-tag */
 for(a=1;a<spalten;a++)
  {
   feld[a].aktiv=1;
   if(cp=strchr(feld[a].Name,'#')) 	/* Die Farbe */
    {
    if(cp=strchr(cp+1,'#'))
     {	  	/* Der Enable-Tag */
     if(cp[1]=='2') feld[a].aktiv=0;
     }
    }
  }
 
 
 /* Tabelle auf Bildschirm */
 for(a=1;a<spalten;a++)
  {
  printf("%2d %30s %d %30s\n",a,feld[a].Name,feld[a].aktiv, feld[a].Formel);
  /* Formeln validieren */
  Y[a]=parse(feld[a].Formel,feld[a].Name);
  }

 printf("Beginne mit konvertieren...\n");
 aktzeit=0x10000000; /*rein Willkrlich festgelegt, um unterlauf zu vermeiden*/

 /* Versuchen Arbeitsdatei zu ffnen */
 stat(argv[1],&src_stat);	/* Zeitstempel Quelldatei merken */

 infile=fopen(argv[1],"r");
 if(!infile)
  {
  printf("Eingabedatei %s konnte nicht geffnet werden!\n",argv[1]);
  return -1;
  }
 
 switch (Startzeit)
  {
  case 1:
   {
   /* Ermittlung ber den Zeitstempel der Datei */
   aktzeit=src_stat.st_mtime; /* Datum der letzten nderung */
   a=0;
   while(!feof(infile))
    {
     fgets(st1,1990,infile);
     a++;
    }
   aktzeit-=(a*Intervall); /* fr jede gelesene Zeile ein Intervall zurck */
   rewind(infile);
   break;
   }
  }
 
 /* Ausgabedatei ffnen */
 strcpy(st1,"temp.csv");
 if(argc>3) strcpy(st1,argv[3]);
 outfile=fopen(st1,"w");
 /*Kopfzeile schreiben*/
 fprintf(outfile,"Datum;Zeit");
 for(a=1;a<spalten;a++)
  {
  if(feld[a].aktiv) fprintf(outfile,";%s",feld[a].Name);
  }
 fprintf(outfile,"\n");

 /* Werte konvertieren */
 while(!feof(infile))
  {
   memset(st1,0,200);
   fgets(st1,1990,infile);
   if(!feof(infile))
   {
    /* Kommas in Punkte umwandeln */
    cp=st1;
    if(Separator!=',') while(cp=strchr(cp,',')) *cp='.';
    /* Wagenrcklauf durch Separator ersetzen */
    if (cp=strchr(st1,'\n')) *cp=Separator;
    /* Separatoren zhlen */
    a=0;
    cp1=st1;
    while (cp1=strchr(cp1+1,Separator)) a++;
    if(a>=Inspalten)
    {
    /* Datensatz fr gltig befunden */
    /* Werte einlesen */
    cp=st1;
    if(!Intervall)
    {
     /* Datum einlesen */
     memset(&t,0,sizeof(t));   
     sscanf(cp,"%d.%d.%d",&t.tm_mday,&monat,&jahr);   
     cp1=strchr(cp,Separator);
     if(!cp1)
      {
      printf("Formatfehler: kein Semikolon hinter Datum!");
      getch();
      return -1;
      }
     *cp1=0;
     cp1++;			/* Zeigt jetzt auf Uhrzeit */
     /* Uhrzeit einlesen */
     sscanf(cp1,"%d:%d:%d",&t.tm_hour,&t.tm_min,&t.tm_sec);
     if(jahr<100) jahr+=2000;
     t.tm_isdst=-1;
     t.tm_mon=monat-1;
     t.tm_year=jahr-1900;
     aktzeit=mktime(&t);   
     if(Minzeit)
      {
      if((aktzeit>(altzeit+Minzeit))&&SatzNr)
       {
       /* Fge noch eine Zeile mit alten Werten ein */
       Ausg(aktzeit-Minzeit);
       }
      }
      
     cp=strchr(cp1,Separator);
     if(!cp)
      {
      printf("Formatfehler: kein Separator hinter Uhrzeit!");
      getch();
      return -1;
      }
     *cp=0;
     cp++;			/* Zeigt jetzt auf ersten Kanal */
    }
  
    cp1=cp;
    umgesetzt=0;
    a=1;
    while((*cp1)&&cp1)
     {
      if(cp=strchr(cp1,Separator))
       {
       *cp=0;
       cp++;
       }
      ch=*cp1;
     while((!isdigit(ch))&&(ch!='.')&&(ch!='-')&&(ch))
      {
      cp1++;
      ch=*cp1;
      }
     sscanf(cp1,"%lf",&X[a]);
     umgesetzt++;
     cp1=cp;
     a++;
    }

    /* Jetzt die Berechnungen */
    for(a=1;a<spalten;a++)
     {
     Y[a]=parse(feld[a].Formel,feld[a].Name);
     }
    Ausg(aktzeit);
    altzeit=aktzeit;
    if(Intervall) aktzeit+=Intervall;
    }
   }
  }
 fclose(outfile);
 fclose(infile);
 free(feld);
 times.modtime = times.actime = src_stat.st_mtime;
 if(argc>=4)
 utime(argv[3],&times); /* Zeitstempel Zieldatei setzen */
 else
 utime("temp.csv",&times); /* Zeitstempel Zieldatei setzen */
 if(!umgesetzt)
  {
  printf("Keine Daten umgesetzt!");
  getch();
  }
 return 0;
 }
