/* um dier erweiterten Styles von CommCtrls nutzen zu knnen*/
#define _WIN32_IE 0x0400

#include <stdio.h>
#include <time.h>
#include <sys\stat.h>
#include <windows.h>
#include <commctrl.h>
#include "main.h"
#include "dialog1.h"
#include "dialog2.h"
#include "dialog3.h"
#include "dialog4.h"
#include "dialog5.h"
#include "cmd_parser.c" /* zur Zerlegung der CMD-Line in argc und **argv */

HINSTANCE g_hInst;
HWND g_hWnd,g_hwndStatus,g_hWndUp,g_hWndDown,g_hWndLeft,g_hWndRight,g_hWndLv;
int paintcount,ColumnCount=0,LineCount=0,Zoom=360,Pairmode=0,
    littlestep=3600,bigstep=3600*24,aktstift=-1,KlickX,KlickY,
    Stackpointer=0,Stackfuel=0,Testmode,Timer=0;
char BUILT[]   = "Version 1.01 von "__DATE__ ", " __TIME__;
char FontName[300],DefUnit[30],IniFileName[300];    

float Scale=60,offset=0;
FILE *datei=0;
time_t Startzeit,Endzeit,Aktzeit,Cursorzeit;
double CursorValue;

struct
 {
 char name[320];
 char einheit[32];
 COLORREF farbe;
 int stil;
 int aktiv;
 int standart;
 double letzter;
 char *blk;
 }
 ColRec, *Spalten=NULL;

typedef struct FILTER
 {
 char ext[20];
 char name[30];
 char konverter[300];
 char konfig[300];
 struct FILTER *next; 
 } FILTER, *PFILTER;

FILTER *Filter=NULL;
 
struct {
         time_t Aktzeit;
         float offset,Scale;
         int Zoom;
        } ViewStack[256];

int FiltClear(void)
 {
 FILTER *fp,*fp1;
 if(!Filter) return 0;
 fp=Filter;
 while(fp)
  {
  fp1=fp->next;
  free(fp);
  fp=fp1;
  }
 }


int ViewPush(void)
 {
 Stackfuel++;
 if(Stackfuel>256) Stackfuel--; /* Stack schon voll: alte Werte berschreiben */
 ViewStack[Stackpointer].Aktzeit=Aktzeit;
 ViewStack[Stackpointer].Scale=Scale;
 ViewStack[Stackpointer].offset=offset;
 ViewStack[Stackpointer].Zoom=Zoom;
 Stackpointer++;
 if(Stackpointer>255) Stackpointer=0;
 }
 
int ViewPop(void)
 {
 /* gespeicherte Fensterposition restaurieren */
 if(!Stackfuel) return 0; /* nix zu poppen */
 Stackfuel--;
 Stackpointer--;
 if(Stackpointer<0) Stackpointer=255;
 Aktzeit=ViewStack[Stackpointer].Aktzeit;
 Scale=ViewStack[Stackpointer].Scale;
 offset=ViewStack[Stackpointer].offset;
 Zoom=ViewStack[Stackpointer].Zoom;
 InvalidateRect(g_hWnd,0,TRUE);
 }

int Center(float Faktor)
 {
              char st1[200];
              int a;
              time_t Mitte;
              RECT rcClient;
              
              ViewPush(); /* Ansicht speichern */

              /* Uhrzeit der Klickpos errechnen */
              Mitte=Aktzeit+((KlickX-60)*Zoom);

              /* Ansichtsgre verdoppeln */
              Zoom /=Faktor; 
              if(Zoom<1) Zoom=1;

              /* nutzbare Fensterbreite ermitteln */
	      GetClientRect(g_hWnd, &rcClient);
              a=(rcClient.right-60)/2*Zoom;
              Aktzeit=Mitte-a;
              InvalidateRect(g_hWnd,0,TRUE); 
 }
  

        /* Funktionsdeklarationen */

LRESULT CALLBACK WndProc (HWND, 
                          UINT, 
                          WPARAM,
                          LPARAM);

BOOL WINAPI Dialog1_DlgProc(HWND hWnd,
                    UINT wMsg,
                    WPARAM wParam,
                    LPARAM lParam);
                    
BOOL WINAPI Dialog2_DlgProc(HWND hWnd,
                    UINT wMsg,
                    WPARAM wParam,
                    LPARAM lParam);
                    
BOOL WINAPI Dialog3_DlgProc(HWND hWnd,
                    UINT wMsg,
                    WPARAM wParam,
                    LPARAM lParam);
                    
BOOL WINAPI Dialog4_DlgProc(HWND hWnd,
                    UINT wMsg,
                    WPARAM wParam,
                    LPARAM lParam);

BOOL WINAPI Dialog5_DlgProc(HWND hWnd,
                    UINT wMsg,
                    WPARAM wParam,
                    LPARAM lParam);


int Hilfe(void)
 {
 MessageBox(g_hWnd,"Pfeil links oder rechts: Verschieben horizontal um einen kleinen Schritt\n"
                   "<Strg>- Pfeil links oder rechts: um einen groen Schritt\n"
                   "Pfeil hoch oder runter: Verschieben vertikal um ein Zehntel\n"
                   "+: horizontal Vergrern, -: horizontal Verkleinern\n"
                   "h: vertikal Vergrern (hher), n: vertikal Verkleinern (hiedriger)\n" 
                   "<Umschalt>- Pfeil links: zurck zur vorherigen Ansicht"
 ,"Tastenbelegung",MB_OK);
 }

/* liefert den nchsten teilstring */
char *parse(char *cp)
 {
 char *cp2;
 cp+=strlen(cp);        /*jetzt zeigt er auf das NULL-Zeichen*/
 cp++;
 if(cp2=strchr(cp,';')) *cp2=0; /*Spaltentrennzeichen*/
 return cp;
 }


int FileClose()
 {
 FILE *datei1;	/* ini-Datei */
 char st1[300];
 WINDOWPLACEMENT wp;
 
 /* Einstellungen speichern */
 datei1=fopen(IniFileName,"w");
 GetWindowPlacement(g_hWnd,&wp);
 fprintf(datei1,"%d\n",wp.rcNormalPosition.left);
 fprintf(datei1,"%d\n",wp.rcNormalPosition.right);
 fprintf(datei1,"%d\n",wp.rcNormalPosition.top);
 fprintf(datei1,"%d\n",wp.rcNormalPosition.bottom);
 fprintf(datei1,"%d\n",littlestep);
 fprintf(datei1,"%d\n",bigstep);
 fprintf(datei1,"%d\n",Zoom);
 fprintf(datei1,"%d\n",Pairmode);
 fprintf(datei1,"%d\n",Testmode);
 fprintf(datei1,"%s\n",FontName);
 fprintf(datei1,"%s\n",DefUnit);
 fclose(datei1);

 if(datei)
  {
  Stackfuel=0;
  fclose(datei);
  datei=0;
  }
  ColumnCount=0;
  if(Spalten) free(Spalten);
  SendMessage(g_hwndStatus,SB_SETTEXT,(WPARAM) 0,(LPARAM) "keine Datei geladen!");
 return 0;
 }

int MyStrCmp(char *st1, char *st2)
 {
 /* Nicht case-sensitives strcmp */
 while ((*st1)||(*st2))
  {
  if(tolower(*st1)!=tolower(*st2)) return 1;
  st1++;
  st2++;
  }
 return 0;
 }

int Convert(char *Quell, char *Ziel)
 {
 FILTER *fp;
 struct stat stat1,stat2;
 char *ext,cmdline[1200];
 
 if(!Filter) return 0; /* Garkein Filter definiert */
 /* passenden Filter raussuchen */
 ext=strrchr(Quell,'.');
 if(!ext) return 0;   /* keine Erweiterung */
 ext++;
 
 fp=Filter;
 while((fp)&&(MyStrCmp(ext,fp->ext))) fp=fp->next;
 if (!fp) return 0;	/* ext nicht gefunden */
 if(!strlen(fp->konverter)) return 0; /* kein Konverter eingetragen */

 /* Tempfilename erzeugen */
 GetEnvironmentVariable("USERPROFILE",Ziel,290);
 strcat(Ziel,"\\csv_view.tmp");
 
 /* gibt es die Datei schon? */
 if(!stat(Ziel,&stat2))
  {
  if(!stat(Quell,&stat1))
   {
   if((stat1.st_mtime==stat2.st_mtime)&&(!Testmode)) return 0; /* Zeitstempel gleich */
   }
  }
 
 if(strlen(fp->konfig))
  sprintf(cmdline,"%s \"%s\" \"%s\" \"%s\"",fp->konverter,
                                               Quell,
                                               fp->konfig,
                                               Ziel);
 else
  sprintf(cmdline,"%s \"%s\" \"%s\"",fp->konverter,
                                         Quell,
                                         Ziel);

 /* Konverter aufrufen */
// MessageBox(0,cmdline,"Diagnosemeldung-Konverteraufruf",MB_OK);
 system(cmdline); 
 return 0;
 }

int FileOpen(char *name)
 {
 FILE *datei1=0;
 char st1[1500],TempFileName[300],*cp,*cp2,Datum1[20],Datum2[20];
 int a,c=0,jahr,monat,tag,stunde,minute,sekunde,Mantisse,Exponent;
 float x,minimum=1E20;
 SCROLLINFO si;
 struct tm *tmBuf,t;
 time_t t1;

 if(datei) 
  {
   FileClose(); /* alte Datei schlieen */
  }

 /* versuchen, passende INI-Datei einzulesen */
 if(argc>2)
  {
  /* als Kommandozeilenparameter mitgegeben */
  strcpy(IniFileName,argv[2]);
  datei1=fopen(IniFileName,"r");
  }

 if(!datei1)
  {
  /* Versuchen eine "dateiname.ini" einzulesen */
  strcpy(IniFileName,name);
  cp=strrchr(IniFileName,'.');
  if (cp)
   {
   strcpy(cp,".ini");
   datei1=fopen(IniFileName,"r");  
   }
  }

 if(!datei1)
  {
  /* Versuchen eine "csv_view.ini" im Dateiverzeichnis einzulesen */
  strcpy(IniFileName,name);
  cp=strrchr(IniFileName,'\\');
  if (cp)
   {
   strcpy(cp,"\\csv_view.ini");
   datei1=fopen(IniFileName,"r");  
   }
  }

// MessageBox(0,IniFileName,"IniFile=",MB_OK);

 if(!datei1)
  {
  /* ansonsten die aus dem %userprofile% */
  GetEnvironmentVariable("USERPROFILE",IniFileName,290);
  strcat(IniFileName,"\\csv_view.ini");
  datei1=fopen(IniFileName,"r");  
  }

 if(datei1)
  {
   int left, right, top, bottom;
   
   if(fgets(st1,200,datei1)) sscanf(st1,"%d\n",&left);
   if(fgets(st1,200,datei1)) sscanf(st1,"%d\n",&right);
   if(fgets(st1,200,datei1)) sscanf(st1,"%d\n",&top);
   if(fgets(st1,200,datei1)) sscanf(st1,"%d\n",&bottom);
   if(fgets(st1,200,datei1)) sscanf(st1,"%d\n",&littlestep);
   if(fgets(st1,200,datei1)) sscanf(st1,"%d\n",&bigstep);
   if(fgets(st1,200,datei1)) sscanf(st1,"%d\n",&Zoom);
   if(fgets(st1,200,datei1)) sscanf(st1,"%d\n",&Pairmode);
   if(fgets(st1,200,datei1)) sscanf(st1,"%d\n",&Testmode);
   if(fgets(st1,200,datei1)) strcpy(FontName,st1);
   if(fgets(st1,200,datei1)) strcpy(DefUnit,st1);
   if(cp=strchr(FontName,'\n')) *cp=0;
   if(cp=strchr(DefUnit,'\n')) *cp=0;
   fclose(datei1);
   MoveWindow(g_hWnd,left,top,right-left,bottom-top,TRUE);
  }

 strcpy(TempFileName,name);
 Convert(name,TempFileName);    /* wenn ntig */
 datei1=fopen(TempFileName,"r");
 if(!datei1)
  {
  MessageBox(0,"Datei konnte nicht geffnet werden","Fehler",MB_OK);
  return 0;
  }
 
 
 Endzeit=0;
 Startzeit=0x7fffffff;
 
 memset(st1,0,1490); 
 fgets(st1,1490,datei1);
 if(cp=strchr(st1,'\n')) *cp=0;  /*Zeilenendezeichen umwandeln*/
 if(cp=strchr(st1,';')) *cp=0;  /*erster Separator*/
 
 /* jetzt die Kopfzeile parsen (wie viele Spalten?) */
 cp=st1;
 if(strcmp(cp,"Datum"))
  {
  FileClose();
  MessageBox(0,"Datei hat falsches Format (Spalte 1 ungleich Datum)!",name,MB_OK);
  datei=0;
  return 0;
  }
 cp=parse(cp);
 if((!cp)||(strcmp(cp,"Zeit")))
  {
  FileClose();
  MessageBox(0,"Datei hat falsches Format (Spalte 2 ungleich Zeit)!",name,MB_OK);
  datei=0;
  return 0;
  }
 do
  {
  cp=parse(cp);
  ColumnCount++;
  }
 while ((cp)&&(strlen(cp)));
 ColumnCount--;
 Spalten=calloc(ColumnCount+2,sizeof(ColRec));
 
 /* Jetzt die Kpfe vorbereiten */
 cp=st1+strlen(st1)+1; /*Das war das Datum*/
 cp=cp+strlen(cp)+1; /*Das war die Uhrzeit*/
 for(a=0;a<ColumnCount;a++)
  {
  char *cp1;
  int farbe,rot,gruen,blau;
  float winkel;
  const float pi   = 3.1418;
  strcpy(Spalten[a].name,cp);
  strcpy(Spalten[a].einheit,DefUnit);
  winkel=2*pi*a/ColumnCount;
  rot=127*(1+sin(winkel));
  gruen=127*(1+sin(winkel+(pi/3*2)));
  blau=127*(1+sin(winkel+2*(pi/3*2)));
  if(rot<0) rot=0;
  if(gruen<0) gruen=0;
  if(blau<0) blau=0;
  Spalten[a].farbe=RGB(rot,gruen,blau);
  Spalten[a].aktiv=Spalten[a].standart=1;
  Spalten[a].stil=PS_SOLID;
  if(cp1=strchr(Spalten[a].name,'#'))
   {
   *cp1=0;
   cp1++;
   sscanf(cp1,"%x",&Spalten[a].farbe);
   if(cp1=strchr(cp1,'#'))
    {
    cp1++;
    sscanf(cp1,"%d",&Spalten[a].aktiv);
    Spalten[a].standart=Spalten[a].aktiv;
    if(cp1=strchr(cp1,'#'))
     {
     cp1++;
     cp2=strchr(cp1,'#');
     if(cp2) *cp2=0;
     strcpy(Spalten[a].einheit,cp1);
     if(cp2)
      {
       cp2++;
        sscanf(cp2,"%d",&Spalten[a].stil);
      }
     }
    }
   }  
  cp=cp+strlen(cp)+1; /*weiterzhlen*/
  }
 Scale=0;
 SendMessage(g_hwndStatus,SB_SETTEXT,(WPARAM) 0,(LPARAM) "Datei wird geladen, bitte warten!");             
 do
  {
   memset(st1,0,1490);
   memset(&t,0,sizeof(t));
   fgets(st1,1490,datei1);
   cp=st1;
   /* Kommas durch Punkte ersetzen */
   while (cp=strchr(cp,',')) *cp='.';
   
   if((!feof(datei1))&&(strlen(st1)>12))
   {
   LineCount++;
   /* Maxima suchen */
   if(cp=strchr(st1,'\n')) *cp=0;  /*Zeilenendezeichen umwandeln*/

   /* Zeitstempel lesen */
   sscanf(st1,"%d.%d.%d;%d:%d:%d",&t.tm_mday,&monat,&jahr,
				  &t.tm_hour,&t.tm_min,&t.tm_sec);
   t.tm_mon=monat-1;
   t.tm_year=jahr-1900;
   t.tm_isdst=-1;
   t1=mktime(&t);
   if (t1>Endzeit) Endzeit=t1;
   if (t1<Startzeit) Startzeit=t1;
 
   if(cp=strchr(st1,';')) *cp=0;  /*erster Separator*/
   cp=parse(st1);
   if(cp)
   {
    for(a=0;a<ColumnCount;a++)
     {
     cp=parse(cp); /*weiterzhlen*/
     if(cp)
      {
      sscanf(cp,"%f",&x);
      if(x>Scale) Scale=x;
      if(x<minimum) minimum=x;
      }
     }
    c++; 
    }
    }
  } 
  while(!feof(datei1));
 rewind(datei1); 


 if(!c)
  {
  MessageBox(0,"In der Datei sind keine Daten enthalten!",
             "Fehler",MB_OK);
  fclose(datei1);
  FileClose();
  return 0;
  }


 /* Automatisch skalieren */
 if(minimum!=0)
 {
 sprintf(st1,"%E",minimum);
 sscanf(st1,"%d",&Mantisse);
 if(cp=strchr(st1,'E')) sscanf(cp+1,"%d",&Exponent);
 if(Mantisse>0) Mantisse++;
 else Mantisse--;
 sprintf(st1,"%d.0E%+d",Mantisse,Exponent);
 sscanf(st1,"%E",&offset);
 }

 sprintf(st1,"%E",Scale);
 sscanf(st1,"%d",&Mantisse);
 if(cp=strchr(st1,'E')) sscanf(cp+1,"%d",&Exponent);
 if(Mantisse>0) Mantisse++;
 else Mantisse--;
 sprintf(st1,"%d.0E%+d",Mantisse,Exponent);
 sscanf(st1,"%E",&Scale);


 Scale-=offset;


 if(Scale==0) Scale=1;
 Aktzeit=Startzeit;
 
 sprintf(st1,"%s - Ingos CSV-Viewer",name);
 SendMessage(g_hWnd,WM_SETTEXT,0,(LPARAM) st1);
 datei=datei1;
 return 0;
 }



COLORREF TestColor(COLORREF bg)
 {
 int rot,gruen,blau;
 
 rot=(bg&0xff)*1.2;
 gruen=((bg&0xff00)>>8)*1.4;
 blau=((bg&0xff0000)>>16)*1;
 if((rot+gruen+blau)>256)  return 0;
 else return 0xffffff;
 }



int Paint(HANDLE hdc, RECT rcClient,int Width)
 {
  HPEN *Stifte,penalt,Schwarz,Grau;
  HBRUSH *Hintergr,weiss,brushalt;
  HFONT hfnt,hOldFont;
  LOGFONT lf;
  HRGN hrgn;
  RECT fillrect;
  struct tm t,*pTime;
  time_t t1,tneu,modul,delta,lasttime;
  char st1[1500],lastline[1500],*blk,*cp,*cp1,date[40],olddate[40],time[40],einheit[40];
  int alttag,altstunde,a,x,xneu,xscale,ystep,yalt,yneu,
  monat,jahr,raster,mod2,Xbase,Ybase;
  double v;

  if((rcClient.bottom-rcClient.top<200)
   ||(rcClient.right-rcClient.left<100)
   ||(!datei)) return 0;

  Stifte=calloc(ColumnCount,sizeof(HPEN));
  Hintergr=calloc(ColumnCount,sizeof(HBRUSH));
  for(a=0;a<ColumnCount;a++)
   {
    if(a==aktstift) Stifte[a]=CreatePen(Spalten[a].stil,3,Spalten[a].farbe);
    else Stifte[a]=CreatePen(Spalten[a].stil,1,Spalten[a].farbe);
    Hintergr[a]=CreateSolidBrush(Spalten[a].farbe);
   }
   Schwarz=CreatePen(PS_SOLID,1,0);
   weiss=CreateSolidBrush(RGB(0xff,0xff,0xff));
   Grau=CreatePen(PS_SOLID,1,0xe0e0e0);
   penalt=(HPEN)SelectObject(hdc,Schwarz);
   brushalt=(HBRUSH)SelectObject(hdc,weiss);
   
   /* Die Palette ausgeben */
   SetTextAlign(hdc,TA_LEFT); 
   xscale=(rcClient.right+10-rcClient.left)/((ColumnCount+1)/2);
   xscale/=2;

   for (a=0;a<ColumnCount;a+=2)
    {
     SetTextColor(hdc,0x0); /* immer schwarze Schrift */

     fillrect.left=rcClient.left+xscale*a;
     fillrect.right=rcClient.left+xscale*(a+2)-1;
     fillrect.top=rcClient.bottom-5.5*Width;
     fillrect.bottom=rcClient.bottom-4.1*Width;

     if(Spalten[a].aktiv) 
      {
      SetTextColor(hdc,TestColor(Spalten[a].farbe));
      SetBkColor(hdc,Spalten[a].farbe);
      FillRect(hdc,&fillrect,Hintergr[a]);
      }
     else 
      {
      SetTextColor(hdc,0x0); /* schwarze Schrift */
      SetBkColor(hdc,0xffffff);
      FillRect(hdc,&fillrect,weiss);
      }
     sprintf(st1," %s ",Spalten[a].name);
     ZeroMemory(&lf,sizeof(LOGFONT));
     strcpy(lf.lfFaceName,FontName);
     lf.lfHeight=1.4*Width;
     lf.lfWidth=Width;
     if(aktstift==a) lf.lfWeight=FW_BLACK;
     else lf.lfWeight=FW_NORMAL;
     lf.lfEscapement=0;
     hfnt=CreateFontIndirect(&lf);
     hOldFont=SelectObject(hdc,hfnt);
     TextOut(hdc,rcClient.left+xscale*a,rcClient.bottom-5.5*Width,st1,strlen(st1));
     SelectObject(hdc,hOldFont);
     DeleteObject(hfnt);

     fillrect.left=rcClient.left+xscale*a;
     fillrect.right=rcClient.left+xscale*(a+2)-1;
     fillrect.top=rcClient.bottom-4.0*Width;
     fillrect.bottom=rcClient.bottom-2.5*Width;

     if(Pairmode)
      {
      if(Spalten[a].aktiv)
       {
        SetTextColor(hdc,TestColor(Spalten[a].farbe));
        SetBkColor(hdc,Spalten[a].farbe);
        FillRect(hdc,&fillrect,Hintergr[a]);
       }
      else
       {
        SetTextColor(hdc,0x0); /* schwarze Schrift */
        SetBkColor(hdc,0xffffff);
        FillRect(hdc,&fillrect,weiss);
       }
      }
      else 
      {
      if(Spalten[a+1].aktiv)
       {
        SetTextColor(hdc,TestColor(Spalten[a+1].farbe));
        SetBkColor(hdc,Spalten[a+1].farbe);
        FillRect(hdc,&fillrect,Hintergr[a+1]);
       }
      else
       {
        SetTextColor(hdc,0x0); /* schwarze Schrift */
        SetBkColor(hdc,0xffffff);
        FillRect(hdc,&fillrect,weiss);
       }
      }

      sprintf(st1," %s ",Spalten[a+1].name);

      ZeroMemory(&lf,sizeof(LOGFONT));
      strcpy(lf.lfFaceName,FontName);
      lf.lfHeight=1.4*Width;
      lf.lfWidth=Width;
      if((aktstift==a+1)|(Pairmode&(aktstift==a))) lf.lfWeight=FW_BLACK;
      else lf.lfWeight=FW_NORMAL;
      lf.lfEscapement=0;
      hfnt=CreateFontIndirect(&lf);
      hOldFont=SelectObject(hdc,hfnt);
      TextOut(hdc,rcClient.left+xscale*a,rcClient.bottom-4*Width,st1,strlen(st1));
      SelectObject(hdc,hOldFont);
      DeleteObject(hfnt);
     }


     SetTextColor(hdc,0x0); /* immer schwarze Schrift */
    /* Haben alle aktiven Kanle die gleiche Einheit? */
    strcpy(einheit,"");
    x=1;
    for(a=0;a<ColumnCount;a++)
     {
     if(Spalten[a].aktiv)
      {
      if(x)
       {
        strcpy(einheit,Spalten[a].einheit); /* erster Eintrag */
        x=0;
       }
      else if(strcmp(einheit,Spalten[a].einheit)) strcpy(einheit,"");
      }
     }

    /* Geometrie einstellen */

    Xbase=rcClient.left+8*Width;
    Ybase=rcClient.bottom-17*Width;
    /* Clipregion vorbereiten */
    hrgn=CreateRectRgn(Xbase,rcClient.top,rcClient.right,Ybase+2);

    /* Die Y-Skala ausgeben */
    ZeroMemory(&lf,sizeof(LOGFONT));
    strcpy(lf.lfFaceName,FontName);
    lf.lfHeight=1.4*Width;
    lf.lfWidth=0.9*Width;
    lf.lfWeight=FW_NORMAL;
    lf.lfEscapement=0;
    hfnt=CreateFontIndirect(&lf);
    hOldFont=SelectObject(hdc,hfnt);
      		
    /* wie viele Skalenstriche wollen wir machen? */
    ystep=Scale*100;
    a=Ybase-rcClient.top; /* Nutzbare Pixel */

    while (2*Width*ystep>a) ystep/=10;
    if (10*Width*ystep<a) ystep*=5;
    if (4*Width*ystep<a) ystep*=2;

    SelectObject(hdc,Grau); /* zum linien Zeichnen */
    SetBkColor(hdc,0xffffff);
    for(a=0;a<(ystep+1);a++)
     {
      v=Scale*a/ystep;
      if(Pairmode) v*=2;
      if(Scale>60) sprintf(st1,"%7.0lf %s",v+offset,einheit);
      else if (Scale>10) sprintf(st1,"%6.1lf %s",v+offset,einheit);
      else if (Scale>1) sprintf(st1,"%6.2lf %s",v+offset,einheit);
      else sprintf(st1,"%6.3lf %s",v+offset,einheit);
      TextOut(hdc,rcClient.left,Ybase-Width*0.6-((Ybase-rcClient.top)*a/ystep),st1,strlen(st1));
      MoveToEx(hdc,Xbase,Ybase-((Ybase-rcClient.top)*a/ystep),NULL);
      LineTo(hdc,rcClient.right,Ybase-((Ybase-rcClient.top)*a/ystep));
     }

    DeleteObject(hfnt);
    SelectObject(hdc,hOldFont);

    raster=30;
    mod2=1;
    if(Zoom*Width/10>1) raster=60;
    if(Zoom*Width/10>2) raster=120;
    if(Zoom*Width/10>3) raster=300; /* 5 Minuten */
    if(Zoom*Width/10>6) raster=600; /* 10 Minuten */
    if(Zoom*Width/10>12) raster=1200; /* 20 Minuten */
    if(Zoom/Width/10>18) raster=1800; /* 30 Minuten */                
    if(Zoom*Width/10>36) raster=3600; /* 1 Stunde */
    if(Zoom*Width/10>72) mod2=2; /* jede 2. Stunde */
    if(Zoom*Width/10>144) mod2=4;
    if(Zoom*Width/10>288) mod2=6;
    if(Zoom*Width/10>572) mod2=12;
    

    /* Zeitachse zeichnen */
    alttag=0;
    delta=raster-(Aktzeit%raster); /* aufgerundet */
    do
      {
       t1=Aktzeit+delta;
       x=(t1-Aktzeit)/Zoom+Xbase;
       pTime=localtime(&t1);                                  
       sprintf(time,"%02d:%02d:%02d",pTime->tm_hour,
                                     pTime->tm_min,
                                     pTime->tm_sec);
       if(Zoom<1500) /* Darber brauchen wir keine Stundenbeschriftung */
        {
        if(!(pTime->tm_hour%mod2))
         {
          /* Zeitachsenbeschriftung zeichnen */
      	  HFONT hfnt;
      	  LOGFONT lf;
      	  ZeroMemory(&lf,sizeof(LOGFONT));
      	  strcpy(lf.lfFaceName,FontName);
      	  lf.lfHeight=1.4*Width;
      	  lf.lfWidth=Width;
      	  lf.lfWeight=FW_NORMAL;
      	  lf.lfEscapement=900;
      	  hfnt=CreateFontIndirect(&lf);
      	  hOldFont=SelectObject(hdc,hfnt);
          SetBkColor(hdc,0xffffff);
          SetTextColor(hdc,0);
      	  TextOut(hdc,x-Width*0.6,rcClient.bottom-7.5*Width,time,strlen(time));
	  SelectObject(hdc,hOldFont);
          DeleteObject(hfnt);
       	  SelectObject(hdc,Grau);
      	  MoveToEx(hdc,x,Ybase,NULL);
      	  LineTo(hdc,x,rcClient.top);
      	 }
      	}
       /* Datum ausgeben */
       if((Zoom<4000)&&(pTime->tm_mday!=alttag)&&alttag)
        {
         /* Tag und Monat anzeigen */
         sprintf(date,"%02d.%02d.%02d",pTime->tm_mday,
                                   pTime->tm_mon+1,
                                   pTime->tm_year%100);
         if(Zoom<800)
         sprintf(date,"%02d.%02d.%04d",pTime->tm_mday,
                                   pTime->tm_mon+1,
                                   pTime->tm_year+1900);

      	 HFONT hfnt;
      	 LOGFONT lf;
      	 ZeroMemory(&lf,sizeof(LOGFONT));
      	 strcpy(lf.lfFaceName,FontName);
      	 lf.lfHeight=1.4*Width;
      	 lf.lfWidth=Width;
      	 lf.lfWeight=FW_NORMAL;
      	 lf.lfEscapement=0;
      	 if(Zoom>1499) lf.lfEscapement=900;
      	 hfnt=CreateFontIndirect(&lf);
      	 hOldFont=SelectObject(hdc,hfnt);
         SetBkColor(hdc,0xffffff);
         SetTextColor(hdc,0);
    	 TextOut(hdc,x-Width/2,rcClient.bottom-7*Width,date,strlen(date));
	 SelectObject(hdc,hOldFont);
         DeleteObject(hfnt);
       	 SelectObject(hdc,Schwarz);
       	 if(pTime->tm_mday!=alttag)
       	  {
      	   MoveToEx(hdc,x,Ybase,NULL);
      	   LineTo(hdc,x,rcClient.top);
      	  }                  
         }
        else
        {
         if((pTime->tm_mday==1)&&(pTime->tm_mday!=alttag))
         {
         /* Monat und Jahr anzeigen*/
         sprintf(date,"%02d.%02d",pTime->tm_mon+1,
                                   pTime->tm_year+1900);
      	 HFONT hfnt;
      	 LOGFONT lf;
      	 ZeroMemory(&lf,sizeof(LOGFONT));
      	 strcpy(lf.lfFaceName,FontName);
      	 lf.lfHeight=1.4*Width;
      	 lf.lfWidth=Width;
      	 lf.lfWeight=FW_NORMAL;
      	 lf.lfEscapement=0;
      	 if(Zoom>1499) lf.lfEscapement=900;
      	 hfnt=CreateFontIndirect(&lf);
      	 hOldFont=SelectObject(hdc,hfnt);
         SetBkColor(hdc,0xffffff);
         SetTextColor(hdc,0);
    	 TextOut(hdc,x-Width/2,rcClient.bottom-7*Width,date,strlen(date));
	 SelectObject(hdc,hOldFont);
         DeleteObject(hfnt);
       	 SelectObject(hdc,Schwarz);
       	 if((pTime->tm_mday!=alttag)&&alttag)
       	  {
      	   MoveToEx(hdc,x,Ybase,NULL);
      	   LineTo(hdc,x,rcClient.top);
      	  }
      	 } 
         }        
        alttag=pTime->tm_mday;
      	delta+=raster;                  
       } while (x<rcClient.right);


      /* Clipregion zuordnen */
      SelectClipRgn(hdc,hrgn);

      /* Die Kurven Zeichnen */
      SendMessage(g_hwndStatus,SB_SETTEXT,(WPARAM) 0,(LPARAM) "Diagramm wird gezeichnet, bitte warten!");             
      rewind (datei);
      fgets(st1,1490,datei); /* Die Kopfzeile haben wir schon */
      strcpy(st1,"");
      t1=0;

      /* bis zur Startposition vorspulen */
      if(Aktzeit)
       do
        {
         lasttime=t1;
         strcpy(lastline,st1);
         memset(st1,0,100);
         memset(&t,0,sizeof(t));
         fgets(st1,1490,datei); /* eine Zeile einlesen */
	 /* Zeitstempel lesen */
	 sscanf(st1,"%d.%d.%d;%d:%d:%d",&t.tm_mday,&monat,&jahr,
				  &t.tm_hour,&t.tm_min,&t.tm_sec);
	 t.tm_mon=monat-1;
         t.tm_year=jahr-1900;
         t.tm_isdst=-1;
         t1=mktime(&t);
        }
       while ((t1<Aktzeit)&&(!feof(datei)));
       if(!strlen(lastline)) 
        {
        strcpy(lastline,st1); /*war die erste Zeile*/
        lasttime=t1;
        }
		
       /* ersten Datensatz erfassen */
       cp=lastline;
       while (cp=strchr(cp,',')) *cp='.';
       if(cp=strchr(lastline,'\n')) *cp=0;  /*Zeilenendezeichen umwandeln*/
       if(cp=strchr(lastline,';')) *cp=0;  /*erster Separator*/
       cp=lastline;         /* das ist das Datum */
       cp=parse(cp);   /* das ist die Zeit */
       for(a=0;a<ColumnCount;a++)
        {
         cp=parse(cp);
         blk=strstr(cp,"#IN");
         sscanf(cp,"%lf",&v);
         if(Pairmode)
          {
           double v2;
           cp=parse(cp);
           sscanf(cp,"%lf",&v2);
           v=(v+v2)/2;
           v-=offset/2;
          }
         else v-=offset;
         v=v*(Ybase-rcClient.top)/Scale;
         Spalten[a].letzter=v;
         Spalten[a].blk=blk;
         if(Pairmode) a++;
        }
       /* folgende Datenstze erfassen */
       x=0;
       while ((x<rcClient.right)&&(!feof(datei)))
        {                
         memset(st1,0,1490);
         memset(&t,0,sizeof(t));
         fgets(st1,1490,datei); /* nchste Zeile einlesen */
         if(!feof(datei))
          {
 	   /* Zeitstempel lesen */
	   sscanf(st1,"%d.%d.%d;%d:%d:%d",&t.tm_mday,&monat,&jahr,
				  &t.tm_hour,&t.tm_min,&t.tm_sec);
	   t.tm_mon=monat-1;
           t.tm_year=jahr-1900;
           t.tm_isdst=-1;
           tneu=mktime(&t);
           if(tneu>Endzeit) Endzeit=tneu; /* Datei ist gewachsen */

           cp=st1;
           while (cp=strchr(cp,',')) *cp='.';
           if(cp=strchr(st1,'\n')) *cp=0;  /*Zeilenendezeichen umwandeln*/
           if(cp=strchr(st1,';')) *cp=0;  /*erster Separator*/
           cp=st1;         /* das ist das Datum */
           strcpy(date,cp);
           cp=parse(cp);   /* das ist die Zeit */
           strcpy(time,cp);

           for(a=0;a<ColumnCount;a++)
            {
             cp=parse(cp);
             if(Spalten[a].aktiv)
              {
               blk=strstr(cp,"#IN");
               sscanf(cp,"%lf",&v);
               if(Pairmode)
                {
                 double v2;
                 cp=parse(cp);
                 sscanf(cp,"%lf",&v2);
                 v=(v+v2)/2;
                 v-=offset/2;
                }
               else v-=offset;
               v=v*(Ybase-rcClient.top);
               v=v/Scale;
       	       SelectObject(hdc,Stifte[a]);
       	       x=Xbase+((lasttime-Aktzeit)/Zoom);
      	       xneu=Xbase+((tneu-Aktzeit)/Zoom);
      	       yalt=Spalten[a].letzter;
      	       yneu=v;
      	       if(((x!=xneu)
      	        ||(yalt!=yneu))
      	        &&(!blk)&&(!Spalten[a].blk))
                {
      	         MoveToEx(hdc,x,Ybase-yalt,NULL);
      	         LineTo(hdc,xneu,Ybase-yneu);
      	        }
               Spalten[a].letzter=v;
               Spalten[a].blk=blk;
              }
             else
              {
               if(Pairmode)
                {
                 double v2;
                 cp=parse(cp);
                }                   
              }
              if(Pairmode) a++;
             }
            lasttime=tneu;
           }
         }

 SendMessage(g_hwndStatus,SB_SETTEXT,(WPARAM) 0,(LPARAM) "bereit");             
 SelectObject(hdc,penalt);
 SelectClipRgn(hdc,NULL);
 for(a=0;a<ColumnCount;a++) 
  {
   DeleteObject(Stifte[a]);
   DeleteObject(Hintergr[a]);
  }
 DeleteObject(Schwarz);
 DeleteObject(Grau);
 DeleteObject(weiss);
 free(Stifte);
 free(Hintergr);
 DeleteObject(hrgn); 
 return 0;
 }


int SucheGraph(char *reslt)
 {
  char st1[2000],*cp,*blk;
  struct tm t,*pTime;
  time_t t1;
  int a,monat,jahr,BestCh=-1;
  double v,BestDiff,ActDiff;

  pTime=localtime(&Cursorzeit);
  
  sprintf(reslt,"Suche nach: %02d.%02d.%04d, %02d:%02d:%02d --> Wert = %lf ...",pTime->tm_mday,
                                               pTime->tm_mon+1,
                                               pTime->tm_year+1900,
                                               pTime->tm_hour,
                                               pTime->tm_min,
                                               pTime->tm_sec,
                                               CursorValue);
  rewind(datei);
  /* bis zur Startposition vorspulen */
  do
   {
    memset(st1,0,1490);
    memset(&t,0,sizeof(t));
   fgets(st1,1490,datei); /* eine Zeile einlesen */
   /* Zeitstempel lesen */
   sscanf(st1,"%d.%d.%d;%d:%d:%d",&t.tm_mday,&monat,&jahr,
				  &t.tm_hour,&t.tm_min,&t.tm_sec);
   t.tm_mon=monat-1;
   t.tm_year=jahr-1900;
   t.tm_isdst=-1;
   t1=mktime(&t);
   }
  while ((t1<Cursorzeit)&&(!feof(datei)));
  if(feof(datei)) return 0;
              
  /* Kommas in Punkte umwandeln */
  cp=st1;
  while (cp=strchr(cp,',')) *cp='.';
  if(cp=strchr(st1,'\n')) *cp=0;  /*Zeilenendezeichen umwandeln*/
  if(cp=strchr(st1,';')) *cp=0;  /*erster Separator*/
  cp=st1;         /* das ist das Datum */
  cp=parse(cp);   /* das ist die Zeit */
  /* Werte einlesen */
  for(a=0;a<ColumnCount;a++)
   {
    cp=parse(cp);
    blk=strstr(cp,"#IN");
    sscanf(cp,"%lf",&v);
    Spalten[a].letzter=v;
    Spalten[a].blk=blk;
   }

  /* Werte auswerten */
  if(Pairmode)
   {
   for(a=0;a<ColumnCount;a+=2)
    {
     if(Spalten[a].aktiv)
      {
       ActDiff=fabs(Spalten[a].letzter+Spalten[a+1].letzter-CursorValue);
       if(BestCh<0)
        {
        BestCh=a;
        BestDiff=ActDiff;
        }
       else
        {
        if(ActDiff<BestDiff)
         {
         BestCh=a;
         BestDiff=ActDiff;
         }
        }
      }
    }
    if(BestCh<0) return 0;        /* nichts gefunden */
    /* Auswertung */
    pTime=localtime(&t1);
    v=Spalten[BestCh].letzter+Spalten[BestCh+1].letzter;
    sprintf(reslt,"%s + %s %02d.%02d.%04d %02d:%02d:%02d = %lf %s (%lf und %lf)",
            Spalten[BestCh].name,Spalten[BestCh+1].name,pTime->tm_mday,pTime->tm_mon+1,pTime->tm_year,
            pTime->tm_hour,pTime->tm_min,pTime->tm_sec,v,Spalten[BestCh].einheit,Spalten[BestCh].letzter,Spalten[BestCh+1].letzter);
   }
  else
   {
   for(a=0;a<ColumnCount;a++)
    {
     if(Spalten[a].aktiv)
      {
       ActDiff=fabs(Spalten[a].letzter-CursorValue);
       if(BestCh<0)
        {
        BestCh=a;
        BestDiff=ActDiff;
        }
       else
        {
        if(ActDiff<BestDiff)
         {
         BestCh=a;
         BestDiff=ActDiff;
         }
        }
      }
    }
    if(BestCh<0) return 0;        /* nichts gefunden */
    /* Auswertung */
    pTime=localtime(&t1);
    sprintf(reslt,"%s %02d.%02d.%04d %02d:%02d:%02d = %lf %s",
            Spalten[BestCh].name,pTime->tm_mday,pTime->tm_mon+1,pTime->tm_year+1900,
	    pTime->tm_hour,pTime->tm_min,pTime->tm_sec,Spalten[BestCh].letzter,Spalten[BestCh].einheit);
   }
  return 0;
 }
 



int APIENTRY WinMain(HINSTANCE hInstance,
			HINSTANCE hPrevInstance,
			LPSTR	lpCmdLine,
			int	nCmdShow)
	{
	int left=0,top=0,right=800,bottom=600;
	char st1[900],*cp;
	FILE *datei;
        PFILTER *fpp;
        FILTER *fp;
	g_hInst=hInstance;
	InitCommonControls();
	WNDCLASS WndClass;
	WndClass.style =CS_OWNDC | CS_VREDRAW | CS_HREDRAW| CS_DBLCLKS;
	WndClass.cbClsExtra=0;	
	WndClass.cbWndExtra=0;
	WndClass.lpfnWndProc=WndProc;
	WndClass.hInstance=hInstance;	
	WndClass.hbrBackground=(HBRUSH)(COLOR_WINDOW+1);	
	WndClass.hCursor=LoadCursor(NULL,IDC_ARROW);
	WndClass.hIcon=LoadIcon(hInstance,MAKEINTRESOURCE(IDI_ICON1));
	WndClass.lpszMenuName=MAKEINTRESOURCE(IDM_MENU1);
	WndClass.lpszClassName="WinProg";
	RegisterClass(&WndClass);
	

	/* Kommandozeile in <int argc, char** argv> zerlegen */
	parseCmdLine(lpCmdLine);

        strcpy(FontName,"courier new");
        strcpy(DefUnit,"Erl");
	/* erstmal Versuchen, Standartinidatei einzusesen */
        GetEnvironmentVariable("USERPROFILE",st1,290);
        strcat(st1,"\\csv_view.ini");
	if(!(GetKeyState(VK_SHIFT)&0x80000000))
	{
         datei=fopen(st1,"r");
         if(datei)
          {
          if(fgets(st1,200,datei)) sscanf(st1,"%d\n",&left);
          if(fgets(st1,200,datei)) sscanf(st1,"%d\n",&right);
          if(fgets(st1,200,datei)) sscanf(st1,"%d\n",&top);
          if(fgets(st1,200,datei)) sscanf(st1,"%d\n",&bottom);
          if(fgets(st1,200,datei)) sscanf(st1,"%d\n",&littlestep);
          if(fgets(st1,200,datei)) sscanf(st1,"%d\n",&bigstep);
          if(fgets(st1,200,datei)) sscanf(st1,"%d\n",&Zoom);
          if(fgets(st1,200,datei)) sscanf(st1,"%d\n",&Pairmode);
          if(fgets(st1,200,datei)) sscanf(st1,"%d\n",&Testmode);
          if(fgets(st1,200,datei)) strcpy(FontName,st1);
          if(fgets(st1,200,datei)) strcpy(DefUnit,st1);
          if(cp=strchr(FontName,'\n')) *cp=0;
          if(cp=strchr(DefUnit,'\n')) *cp=0;
	  fclose(datei);
	  }
	}

	/* Versuchen, Filterdatei einzulesen */
        GetEnvironmentVariable("USERPROFILE",st1,290);
        strcat(st1,"\\csv_view.flt");
        datei=fopen(st1,"r");
        fpp=&Filter;
        if(datei)
         {
         int a;
         char *ext,*name,*konverter,*konfig,*cp;
         while(!feof(datei))
          {
          if(fgets(st1,899,datei))
           {
           ext=st1;
           name=strchr(ext,';');
           if(name)
            {
            *name=0;
            name++;
            konverter=strchr(name,';');
            if(konverter)
             {
             *konverter=0;
             konverter++;
             konfig=strchr(konverter,';');
             if(konfig)
              {
              *konfig=0;
              konfig++;
              if(cp=strchr(konfig,'\n')) *cp=0;
                         
              *fpp=calloc(1,sizeof(FILTER));
              fp=*fpp;
              strcpy(fp->ext,ext);
              strcpy(fp->name,name);
              strcpy(fp->konverter,konverter);
              strcpy(fp->konfig,konfig);              
              fp->next=NULL;
              fpp=&(fp->next);
              }
             }
            }
           }
          }
	  fclose(datei);
	  }

        /* Hauptfenster erzeugen */
	g_hWnd=CreateWindow("WinProg","keine Datei - Ingos CSV-Viewer",WS_OVERLAPPEDWINDOW,
				left,top,right-left,bottom-top,NULL,NULL,hInstance,NULL);
	ShowWindow(g_hWnd,nCmdShow);
	UpdateWindow((g_hWnd));
	
	MSG Message;
	while (GetMessage(&Message,NULL,0,0))
	 {
	 DispatchMessage(&Message);
	 TranslateMessage(&Message);
	 }
	 return(Message.wParam);	 
      }


LRESULT CALLBACK WndProc (HWND hWnd, UINT uiMessage,
					WPARAM wParam, LPARAM lParam)
	{
	  switch(uiMessage)
	  {
	   case WM_DESTROY:
	    {
	    char st1[300],*cp;
	    FILE *datei;
	    WINDOWPLACEMENT wp;
	    
	    /* aktive Datei und ini schlieen */
            FileClose();
            
	    /* Filterliste speichern */
            if(Filter)
            {
             GetEnvironmentVariable("USERPROFILE",st1,290);
             strcat(st1,"\\csv_view.flt");
             datei=fopen(st1,"w");
             FILTER *fp;
             fp=Filter;
             while(fp)
              {
              fprintf(datei,"%s;%s;%s;%s\n",fp->ext,fp->name,fp->konverter,fp->konfig);
              fp=fp->next;
              }
	     fclose(datei);
	    }
	    PostQuitMessage(0);
	    return 0;
	    }

	   case WM_CREATE:
	    { 
	     char st1[300],*cp,*cp1;

	     /* StatusBar erzeugen */
	     g_hwndStatus = CreateWindowEx( 
			0,                       // no extended styles 
			STATUSCLASSNAME,         // name of status window class 
			(LPCTSTR) NULL,          // no text when first created 
			SBARS_SIZEGRIP |         // includes a sizing grip 
			WS_VISIBLE |
			WS_CHILD,                // creates a child window 
			0, 0, 0, 0,              // ignores size and position 
			hWnd,              	      // handle to parent window 
			(HMENU) 0,       // child window identifier 
			g_hInst,                   // handle to application instance 
			NULL);                   // no window creation data 
              SendMessage(g_hwndStatus,SB_SETTEXT,(WPARAM) 0,(LPARAM) "keine Datei geladen!");             

              g_hWndLeft=CreateWindow("BUTTON","<",WS_VISIBLE | WS_CHILD |BS_BITMAP,
                    10,440, 
                    20,20,
                    hWnd,
                    (HMENU) CM_LEFT,
                    (HINSTANCE) GetWindowLong(hWnd, GWL_HINSTANCE), 
                    NULL);

              g_hWndRight=CreateWindow("BUTTON",">",WS_VISIBLE | WS_CHILD|BS_BITMAP ,
                    30,440, 
                    20,20,
                    hWnd,
                    (HMENU) CM_RIGHT,
                    (HINSTANCE) GetWindowLong(hWnd, GWL_HINSTANCE), 
                    NULL);

              g_hWndUp=CreateWindow("BUTTON","^",WS_VISIBLE | WS_CHILD|BS_BITMAP ,
                    20,420, 
                    20,20,
                    hWnd,
                    (HMENU) CM_UP,
                    (HINSTANCE) GetWindowLong(hWnd, GWL_HINSTANCE), 
                    NULL);

              g_hWndDown=CreateWindow("BUTTON","v",WS_VISIBLE | WS_CHILD|BS_BITMAP ,
                    20,460, 
                    20,20,
                    hWnd,
                    (HMENU) CM_DOWN,
                    (HINSTANCE) GetWindowLong(hWnd, GWL_HINSTANCE), 
                    NULL);

              SendMessage(g_hWndLeft,BM_SETIMAGE,IMAGE_BITMAP,
                          (LPARAM) LoadBitmap((HINSTANCE) GetWindowLong(hWnd, GWL_HINSTANCE),
                                            (LPCTSTR) IDB_LEFT));
              SendMessage(g_hWndRight,BM_SETIMAGE,IMAGE_BITMAP,
                          (LPARAM) LoadBitmap((HINSTANCE) GetWindowLong(hWnd, GWL_HINSTANCE),
                                            (LPCTSTR) IDB_RIGHT));
              SendMessage(g_hWndUp,BM_SETIMAGE,IMAGE_BITMAP,
                          (LPARAM) LoadBitmap((HINSTANCE) GetWindowLong(hWnd, GWL_HINSTANCE),
                                            (LPCTSTR) IDB_UP));
              SendMessage(g_hWndDown,BM_SETIMAGE,IMAGE_BITMAP,
                          (LPARAM) LoadBitmap((HINSTANCE) GetWindowLong(hWnd, GWL_HINSTANCE),
                                            (LPCTSTR) IDB_DOWN));

	      /* Datei in der Kommandozeile angegeben? */
              if(argc<2) return 0;
              strcpy(st1,argv[1]);
	      FileOpen(st1);
	      strcat(st1," - Ingos CSV-Viewer");
	      SendMessage(hWnd,WM_SETTEXT,0,(LPARAM) st1);		
	     }
	     return 0;

	    case WM_SIZE:
	     {
             int i,nw,inc,width[10];
             char puffer[300],*cp;
	     RECT rcClient;
             GetClientRect(hWnd, &rcClient);
             //einfach an den StatusBar weitergeben
             SendMessage(g_hwndStatus,WM_SIZE,wParam,lParam);
             MoveWindow(g_hWndLeft,10,rcClient.bottom-120,20,20,TRUE);
             MoveWindow(g_hWndRight,30,rcClient.bottom-120,20,20,TRUE);
             MoveWindow(g_hWndUp,20,rcClient.bottom-140,20,20,TRUE);
             MoveWindow(g_hWndDown,20,rcClient.bottom-100,20,20,TRUE);
             
		strcpy(puffer,GetCommandLine());
		if(cp=strstr(puffer,"/TOTAL"))
                 {		
		  time_t laenge;
                  Aktzeit=Startzeit;
	          laenge=Endzeit-Startzeit;
	          /*Bildschirmgre ermitteln*/
                  Zoom=laenge/(rcClient.right-60);
                  if(!Zoom) Zoom=1;
		 }

	     }
	     return 0;
	      
	    case WM_PAINT:
	     {
      		PAINTSTRUCT ps;
      		HDC hdc;
      		RECT rcClient;

      		hdc=BeginPaint(hWnd,&ps);
      		if(!datei)
      		 {
      		 EndPaint(hWnd,&ps);
      		 return 0;
      		 }
      		
		GetClientRect(hWnd, &rcClient);
      		rcClient.left+=0;
		rcClient.top+=20;
		rcClient.bottom-=0;
		rcClient.right-=10;
		
                Paint(hdc,rcClient,10);
		ReleaseDC(hWnd,hdc);
      		EndPaint(hWnd,&ps);
	     }	
	    return 0;

            case WM_MOUSEMOVE:
             {
             char st1[100];
             int x,y;
             double v;
	     RECT rcClient;
             time_t t1;
             struct tm *pTime;
             
             if(Timer) KillTimer(hWnd,1);
	     Timer=0;
             if(!datei)
              {
              return 0;
              }
             x=LOWORD(lParam);
             y=HIWORD(lParam);

	     /* Fenstergre ermitteln */
	     GetClientRect(hWnd, &rcClient);
	     if(y>rcClient.bottom-58)
	      {
	       /* Cursor ber der Palette */
	       int xscale;
               y-=rcClient.bottom;
               xscale=(rcClient.right-rcClient.left)/((ColumnCount+1)/2);
               xscale/=2;
	       x/=xscale;
	       x/=2;
	       x*=2;
	       if(y>-42) x++;
               /* x hat jetzt den gewhlten Kanal! */
               if(strlen(Spalten[x].einheit))
	        sprintf(st1,"%s (%s)",Spalten[x].name,Spalten[x].einheit);
	       else
	        sprintf(st1,"%s",Spalten[x].name);
	      }
	     else if(x>=80)
	     {
	      rcClient.bottom-=170; /* + 10 Punkte oberer Rand */
              t1=Aktzeit+((x-80)*Zoom);
              pTime=localtime(&t1);

	      v=(rcClient.bottom-y)*Scale/(rcClient.bottom-20);
	      if(Pairmode) v*=2;
	      v+=offset;
	      CursorValue=v;
	      Cursorzeit=t1;
              sprintf(st1,"%02d.%02d.%04d, %02d:%02d:%02d --> Wert = %lf",pTime->tm_mday,
                                               pTime->tm_mon+1,
                                               pTime->tm_year+1900,
                                               pTime->tm_hour,
                                               pTime->tm_min,
                                               pTime->tm_sec,
                                               v);
              Timer=SetTimer(hWnd,1,1000,NULL);
              }
             SendMessage(g_hwndStatus,SB_SETTEXT,(WPARAM) 0,(LPARAM) st1);
             }
             return 0;

	    case WM_TIMER:
	     {
             char st1[300];
             KillTimer(hWnd,1);
             SucheGraph(st1);
             SendMessage(g_hwndStatus,SB_SETTEXT,(WPARAM) 0,(LPARAM) st1);
	     
	     return 0;
	     }
	    case WM_CHAR:
	     {
	     switch (wParam)
	      {
	      case '+':
	       {
                RECT rcClient;
	        GetClientRect(hWnd, &rcClient);
                KlickX=rcClient.right/2+30; /* Zentrum Mitte des Diagramms */
                Center(2);
                return 0;  
	       }

	      case '-':
	       {
                RECT rcClient;
	        GetClientRect(hWnd, &rcClient);
                KlickX=rcClient.right/2+30; /* Zentrum Mitte des Diagramms */
                Center(0.5);
                return 0;  
	       }

	      case 'b':
	       {
                RECT rcClient;
	        GetClientRect(hWnd, &rcClient);
                KlickX=rcClient.right/2+30; /* Zentrum Mitte des Diagramms */
                Center(1.1);
                return 0;  
	       }

	      case 's':
	       {
                RECT rcClient;
	        GetClientRect(hWnd, &rcClient);
                KlickX=rcClient.right/2+30; /* Zentrum Mitte des Diagramms */
                Center(0.9);
                return 0;  
	       }

              case 'h':
               {
               char st1[16],*cp;
               float neuScale;
               neuScale=Scale*0.5;
               if(neuScale<0.05) neuScale=0.05;
               ViewPush();
               /* Skala normalisieren */
               sprintf(st1,"%E",neuScale);
               if(cp=strchr(st1,'.'))
                {
                cp++;
                while(*cp !='E') 
                 {
                 *cp='0';
                 cp++;
                 }
                }
               sscanf(st1,"%E",&neuScale);
               offset=offset*neuScale/Scale;
               Scale=neuScale;
               /* Offset normalisieren */
               sprintf(st1,"%E",offset);
               if(cp=strchr(st1,'.'))
                {
                cp++;
                while(*cp !='E') 
                 {
                 *cp='0';
                 cp++;
                 }
                }
              sscanf(st1,"%E",&offset);
              InvalidateRect(hWnd,0,TRUE);
              return 0;
               }
              case 'n':
               {
               char st1[16],*cp;
               float neuScale;
               neuScale=Scale*2;
               ViewPush();
               /* Skala normalisieren */
               sprintf(st1,"%E",neuScale);
               if(cp=strchr(st1,'.'))
                {
                cp++;
                while(*cp !='E') 
                 {
                 *cp='0';
                 cp++;
                 }
                }
               sscanf(st1,"%E",&neuScale);
               offset=offset*neuScale/Scale;
               Scale=neuScale;
               /* Offset normalisieren */
               sprintf(st1,"%E",offset);
               if(cp=strchr(st1,'.'))
                {
                cp++;
                while(*cp !='E') 
                 {
                 *cp='0';
                 cp++;
                 }
                }
              sscanf(st1,"%E",&offset);
              InvalidateRect(hWnd,0,TRUE);
              return 0;
               }
	      }
	     return 0;
	     }
	    case WM_KEYDOWN:
	     {
	      char st1[40];

	     switch(wParam)
	      {
	      case VK_LEFT:
	       {
	       if(GetKeyState(VK_SHIFT)&0x80000000)
	        {
                /* Umchalt-Pfeillinks : zurck */
	        ViewPop();
	        }
	       else
                {
                ViewPush();	       
	        if((GetKeyState(VK_LCONTROL)&0x80000000)
	          ||(GetKeyState(VK_RCONTROL)&0x80000000)) Aktzeit-=bigstep;
	        else Aktzeit-=littlestep;
	        if(Aktzeit<Startzeit) Aktzeit=Startzeit;
                InvalidateRect(hWnd,0,TRUE);	       
                }
	       return 0;
	       }
	      case VK_RIGHT:
	       {
	       ViewPush();
	       if((GetKeyState(VK_LCONTROL)&0x80000000)
	          ||(GetKeyState(VK_RCONTROL)&0x80000000)) Aktzeit+=bigstep;

	       else Aktzeit+=littlestep;
	       if(Aktzeit>Endzeit) Aktzeit=Endzeit;
               InvalidateRect(hWnd,0,TRUE);	       
	       return 0;
	       }
	      case VK_UP:
	       {
	       ViewPush();
	       offset+=Scale/10;
	       
               InvalidateRect(hWnd,0,TRUE);	       
	       return 0;
	       }
	      case VK_DOWN:
	       {
	       ViewPush();  
	       offset-=Scale/10;
               InvalidateRect(hWnd,0,TRUE);	       
	       return 0;
	       }

	      case VK_F1:	/* Hilfe */
	       {
	       Hilfe();
	       return 0;
	       }
	      }
	     return 0;
	     }

            case WM_LBUTTONDBLCLK:
             {
             char st1[200];
             int x,y,xscale;
             RECT rcClient;
             x=LOWORD(lParam);
             y=HIWORD(lParam);
             GetClientRect(hWnd,&rcClient);

             if(!datei)
              {
              return 0;
              }
             if(y>rcClient.bottom-60)
              {
               /* Die Palette */
               y-=rcClient.bottom;
               xscale=(rcClient.right-rcClient.left)/((ColumnCount+1)/2);
               xscale/=2;
	       x/=xscale;
	       x/=2;
	       x*=2;
	       if((y>-42)&&(!Pairmode)) x++;
               /* x hat jetzt den gewhlten Kanal! */
               if(x<ColumnCount)
               if(Spalten[x].aktiv) Spalten[x].aktiv=0;
               else Spalten[x].aktiv=1;
               InvalidateRect(hWnd,0,TRUE);
              }
             return 0;
             }

            case WM_LBUTTONDOWN:
             {
             char st1[200];
             int x,y,xscale;
             RECT rcClient;
             x=LOWORD(lParam);
             y=HIWORD(lParam);
             GetClientRect(hWnd,&rcClient);

             if(!datei)
              {
              return 0;
              }
             if(y>rcClient.bottom-60)
              {
               /* in die Palette geklickt*/
               y-=rcClient.bottom;
               xscale=(rcClient.right-rcClient.left)/((ColumnCount+1)/2);
               xscale/=2;
	       x/=xscale;
	       x/=2;
	       x*=2;
	       if((y>-42)&&(!Pairmode)) x++;
               /* x hat jetzt den gewhlten Kanal! */
               if(x<ColumnCount)
                { if(aktstift==x) aktstift=-1;
                  else aktstift=x;
                }
               InvalidateRect(hWnd,0,TRUE);
              }
             else
              /* Ins Diagramm geklickt */
              {
               char st1[100];
               float faktor;
               y-=rcClient.bottom-170;
               KlickX=LOWORD(lParam);	/* Die Mauspos brauchen wir noch */
               
               faktor=10;		/* Maximale Vergrerung */
               if(y>-40) faktor=5;
               if(y>-20) faktor=2;
               if(y>0) faktor=0.5;               
               if(y>20) faktor=0.2;
               if(y>40) faktor=0.1;
                              
               Center(faktor);
                              
              }
             return 0;
             }

  	    case WM_CONTEXTMENU:
             //wParam enthlt das hWnd des Fenster oder Controls!
             {
             int a;
             HMENU hmenu,hmenuTrack;
             RECT rcWnd,rcClient;
             KlickX=LOWORD(lParam);	/* Die Mauspos brauchen wir noch */
             KlickY=HIWORD(lParam);

             /* das ist Bildschirmkoordinate */
             GetWindowRect(hWnd,&rcWnd);
             GetClientRect(hWnd,&rcClient);

             /* Bildschirmkoordinaten in Fensterkoordinaten umrechnen */
             KlickX-=rcWnd.left+GetSystemMetrics(SM_CXSIZEFRAME);       /* v Fensterrahmen */
             KlickY-=rcWnd.top+GetSystemMetrics(SM_CYCAPTION)           /* Titelleiste */
                              +GetSystemMetrics(SM_CYMENUSIZE)          /* Menhhe */
                              +GetSystemMetrics(SM_CYSIZEFRAME);	/* h Fensterrahmen */
                              
                              
                              
             if(KlickY>rcClient.bottom-56)
              {             
               hmenu=LoadMenu(g_hInst,MAKEINTRESOURCE(IDM_MENU3));
               hmenuTrack = GetSubMenu(hmenu, 0);
	       TrackPopupMenuEx(hmenuTrack,
                       TPM_LEFTBUTTON,
                       LOWORD(lParam),HIWORD(lParam),
                       hWnd,
                       NULL);
               DestroyMenu(hmenu);             
              }
             else
              {
               hmenu=LoadMenu(g_hInst,MAKEINTRESOURCE(IDM_MENU2));
               hmenuTrack = GetSubMenu(hmenu, 0);
	       TrackPopupMenuEx(hmenuTrack,
                       TPM_LEFTBUTTON,
                       LOWORD(lParam),HIWORD(lParam),
                       hWnd,
                       NULL);
               DestroyMenu(hmenu);
              }
             return 0;
             }

	   case WM_COMMAND:
	     switch (LOWORD(wParam))
	     {

             case CM_DATEIOEFFNEN:
              {
                OPENFILENAME ofn;
                FILTER *fp;
                char FileName[300],FilterString[1000],*cp;
                ZeroMemory(&ofn,sizeof(ofn));
                ofn.lStructSize=sizeof(ofn);
                if(Filter)
                 {
                  cp=FilterString;
                  fp=Filter;
                  while(fp)
                  {
                   strcpy(cp,fp->name);
                   cp+=strlen(cp)+1;
                   strcpy(cp,"*.");
                   strcat(cp,fp->ext);
                   cp+=strlen(cp)+1;
                   fp=fp->next;
                  }
                  strcpy(cp,"alle Dateien");
                  cp+=strlen(cp)+1;
                  strcpy(cp,"*.*");
                  cp+=strlen(cp)+1;
                  *cp=0;
                  cp++;
                  *cp=0;                 
                 ofn.lpstrFilter=FilterString;
                 }
                else
                ofn.lpstrFilter="CSV-Dateien\0*.csv\0"
                                "Textdateien\0*.txt\0"
                                "alle Dateien\0*.*\0\0";
                ofn.hwndOwner=hWnd;
                ofn.lpstrFile=FileName;
                ofn.nMaxFile=300;
                ofn.lpstrTitle="Datei zum ffnen whlen!";
                ofn.Flags=OFN_FILEMUSTEXIST;
                strcpy(FileName,"*.*");
	             
                if(GetOpenFileName(&ofn))
                 {
                  FileOpen(FileName);
                 }
               InvalidateRect(hWnd,0,TRUE);
              }
              return 0;
              
             case CM_KLEINER:
              {
              RECT rcClient;
	      GetClientRect(hWnd, &rcClient);
              KlickX=rcClient.right/2+30; /* Zentrum Mitte des Diagramms */
              Center(0.5);
              return 0;
              }
             
             case CM_GROESSER:
              {
              RECT rcClient;
	      GetClientRect(hWnd, &rcClient);
              KlickX=rcClient.right/2+30; /* Zentrum Mitte des Diagramms */
              Center(2);
              return 0;  
              }

             case CM_VGROESSER:
              {
              char st1[16],*cp;
              float neuScale;
              neuScale=Scale*0.5;
              if(neuScale<0.05) neuScale=0.05;
              ViewPush();
              /* Skala normalisieren */
              sprintf(st1,"%E",neuScale);
              if(cp=strchr(st1,'.'))
               {
               cp++;
               while(*cp !='E') 
                {
                *cp='0';
                cp++;
                }
               }
              sscanf(st1,"%E",&neuScale);
              offset=offset*neuScale/Scale;
              Scale=neuScale;
              /* Offset normalisieren */
              sprintf(st1,"%E",offset);
              if(cp=strchr(st1,'.'))
               {
               cp++;
               while(*cp !='E') 
                {
                *cp='0';
                cp++;
                }
               }
              sscanf(st1,"%E",&offset);
              InvalidateRect(hWnd,0,TRUE);
              return 0;
              }
             
             case CM_VKLEINER:
              {
              char st1[16],*cp;
              float neuScale;
              neuScale=Scale*2;
              ViewPush();
              sprintf(st1,"%E",neuScale);
              if(cp=strchr(st1,'.'))
               {
               cp++;
               while(*cp !='E') 
                {
                *cp='0';
                cp++;
                }
               }
              sscanf(st1,"%E",&neuScale);
              offset=offset*neuScale/Scale;
              Scale=neuScale;
              /* Offset normalisieren */
              sprintf(st1,"%E",offset);
              if(cp=strchr(st1,'.'))
               {
               cp++;
               while(*cp !='E') 
                {
                *cp='0';
                cp++;
                }
               }
              sscanf(st1,"%E",&offset);
              InvalidateRect(hWnd,0,TRUE);
              return 0;
              }

             case CM_LEFT:
              {
               RECT rcClient;
               ViewPush(); /* Ansicht speichern */
               /* Halben Bildschirm nach rechts scrollen */
	       GetClientRect(hWnd, &rcClient);
               Aktzeit-=(rcClient.right-80)/2*Zoom;
	       if(Aktzeit<Startzeit) Aktzeit=Startzeit;
               InvalidateRect(hWnd,0,TRUE);
               SetFocus(hWnd);
              return 0;
              }

             case CM_RIGHT:
              {
               RECT rcClient;
               ViewPush(); /* Ansicht speichern */
               /* Halben Bildschirm nach links scrollen */
	       GetClientRect(hWnd, &rcClient);
               Aktzeit+=(rcClient.right-80)/2*Zoom;
	       if(Aktzeit>Endzeit) Aktzeit=Endzeit;
               InvalidateRect(hWnd,0,TRUE);	       
               SetFocus(hWnd);
              return 0;
              }

             case CM_UP:
              {
               ViewPush(); /* Ansicht speichern */
	       offset+=Scale/10;	       
               InvalidateRect(hWnd,0,TRUE);	       
               SetFocus(hWnd);
              return 0;
              }

             case CM_DOWN:
              {
               ViewPush(); /* Ansicht speichern */
	       offset-=Scale/10;	       
               InvalidateRect(hWnd,0,TRUE);	       
               SetFocus(hWnd);
              return 0;
              }
              
             case CM_TOTAL:
              {
               RECT rcClient;
               time_t laenge;
               
               ViewPush(); /* Ansicht speichern */
               Aktzeit=Startzeit;
	       laenge=Endzeit-Startzeit;
	       /*Bildschirmgre ermitteln*/
	       GetClientRect(hWnd, &rcClient);
               Zoom=laenge/(rcClient.right-80);
               if(!Zoom) Zoom=1;
               InvalidateRect(hWnd,0,TRUE);
               return 0;
              }

            case CM_ALLON:
             {
              int a;
              for(a=0;a<ColumnCount;a++)
               {
               Spalten[a].aktiv=1;
               }
              InvalidateRect(hWnd,0,TRUE);
              return 0;
             }

            case CM_ALLOFF:
             {
              int a;
              for(a=0;a<ColumnCount;a++)
               {
               Spalten[a].aktiv=0;
               }
              InvalidateRect(hWnd,0,TRUE);
              return 0;
             }

            case CM_DEFAULT:
             {
              int a;
              for(a=0;a<ColumnCount;a++)
               {
               Spalten[a].aktiv=Spalten[a].standart;
               }
              InvalidateRect(hWnd,0,TRUE);
              return 0;
             }

            case CM_EXCLUSIV:
             {
             char st1[200];
             int x,y,xscale;
             RECT rcClient;
             x=KlickX;
             y=KlickY;
             GetClientRect(hWnd,&rcClient);

             if(!datei)
              {
              return 0;
              }
              y-=rcClient.bottom;
               xscale=(rcClient.right-rcClient.left)/((ColumnCount+1)/2);
               xscale/=2;
	      x/=xscale;
	      x/=2;
	      x*=2;
	      if((y>-41)&&(!Pairmode)) x++;
              /* x hat jetzt den gewhlten Kanal! */
              if(x<ColumnCount)
               {
               for(y=0;y<ColumnCount;y++)
                {
                Spalten[y].aktiv=0;
                }
               Spalten[x].aktiv=1;
               }
              InvalidateRect(hWnd,0,TRUE);
             return 0;
             }

            case CM_PROPERTIES:
             {
             /* Eigenschaften eines Kanals */
             char st1[200];
             int x,y,xscale;
             RECT rcClient;
             x=KlickX;
             y=KlickY;
             GetClientRect(hWnd,&rcClient);

             if(!datei)
              {
              return 0;
              }
              y-=rcClient.bottom;
               xscale=(rcClient.right-rcClient.left)/((ColumnCount+1)/2);
               xscale/=2;
	      x/=xscale;
	      x/=2;
	      x*=2;
	      if((y>-42)&&(!Pairmode)) x++;
              /* x hat jetzt den gewhlten Kanal! */
              if(x<ColumnCount)
	      DialogBoxParam(g_hInst,MAKEINTRESOURCE(IDD_DIALOG1),
	                      hWnd,Dialog1_DlgProc,x);
              InvalidateRect(hWnd,0,TRUE);
             }
             return 0;

             case CM_MANUAL:
              {
              char *cp,st1[300];
              GetModuleFileName(NULL,st1,290);
              if(cp=strrchr(st1,'.'))
               {
               strcpy(cp,".pdf");
               ShellExecute(
		0,
		"open",
		st1,
		NULL,
		"",
		SW_RESTORE);
               }
              return 0;
              }

	     case CM_DATEIBEENDEN:
	      {
	       SendMessage(hWnd,WM_DESTROY,0,0);
	       return 0;
	      }
	     
	     case CM_SAVEPALETTE:
	      {
	       OPENFILENAME ofn;
	       char FileName[300];
	       FileName[0]=0;
               ZeroMemory(&ofn,sizeof(ofn));   	
               ofn.lStructSize=sizeof(ofn);
	       ofn.hwndOwner=hWnd;
	       ofn.lpstrFile=FileName;
	       ofn.lpstrFilter="CSV-Dateien\0*.csv\0Textdateien\0*.txt\0alle Dateien\0*.*\0\0\0";
	       ofn.lpstrDefExt="csv";
	       ofn.nMaxFile=300;
	       ofn.lpstrTitle="Datei zum Empfangen whlen!";
	       ofn.Flags=0;
	       if(GetSaveFileName(&ofn))
                {
                int a;
                FILE *datei;
                datei=fopen(FileName,"w");
                if(datei)
                 {
                 for(a=0;a<ColumnCount;a++)
                  {
                  fprintf(datei,"%s#%08X#%d#%s#%d\n",Spalten[a].name,
                                             Spalten[a].farbe,
                                             Spalten[a].aktiv,
                                             Spalten[a].einheit,
                                             Spalten[a].stil);
                  }
                 fclose(datei);
                 }
                }
	      return 0;
	      }  

             case CM_LIZENZ:
              {
       	       DialogBoxParam(g_hInst,MAKEINTRESOURCE(IDD_DIALOG2),
                      hWnd,Dialog2_DlgProc,0);
              return 0;
              }

             case CM_HELP:
              {
              Hilfe();
              return 0;
              }
              
             case CM_ABOUT:
              {
              MessageBox(hWnd,BUILT,"ber csv-Viewer",MB_OK);
              return 0;
              } 
              
             case CM_SETUP:
              {
       	       DialogBoxParam(g_hInst,MAKEINTRESOURCE(IDD_DIALOG3),
                      hWnd,Dialog3_DlgProc,0);              
              return 0;
              }
              
             case CM_GOTO:
              {
               ViewPush(); /* Ansicht speichern */
       	       DialogBoxParam(g_hInst,MAKEINTRESOURCE(IDD_GOTO),
                      hWnd,Dialog4_DlgProc,0);                            
              return 0;
              }

             case CM_CENTER:
              {
              Center(1);
              return 0;
              } 

             case CM_BACK:
              {
              ViewPop();
              return 0;
              } 

             case CM_FILTER:
              {
       	       DialogBoxParam(g_hInst,MAKEINTRESOURCE(IDD_FILTER),
                      hWnd,Dialog5_DlgProc,0);
              return 0;
              }

             case CM_DRUCKEN:
              {
               DOCINFO di;
               DEVMODE *dm;
               HANDLE hdc;
               PRINTDLG dlg;
               RECT rcClient,rcScreen;
               char st1[200];
               int Zoomalt,Zoomdruck;
               
               memset(&di,0,sizeof(di));
               memset(&dlg,0,sizeof(dlg));

               dlg.lStructSize=sizeof(dlg);
               dlg.hwndOwner=hWnd;
               dlg.Flags=PD_RETURNDC;

               if(PrintDlg(&dlg))
                {
                /* den DC auf Querformat umprogrammieren */
                dm=GlobalLock(dlg.hDevMode);
                dm->dmOrientation=DMORIENT_LANDSCAPE;
                ResetDC(dlg.hDC,dm);
                GlobalUnlock(dlg.hDevMode);

                hdc=dlg.hDC;
                di.cbSize = sizeof(DOCINFO); 
                di.lpszDocName = "Diagramm"; 
                di.lpszOutput = (LPTSTR) NULL; 
                di.fwType = 0; 
                StartDoc(hdc, &di);               
                StartPage(hdc);

		rcClient.left=250;
		rcClient.top=250;
		rcClient.bottom=GetDeviceCaps(hdc,VERTRES)-250;
		rcClient.right=GetDeviceCaps(hdc,HORZRES)-250;
	        Zoomalt=Zoom;
                /* Auflsung des Bildschirms ermitteln */
		GetClientRect(hWnd, &rcScreen);
		/* Zoomfaktor temporr anpassen */
                Zoom=Zoom*(rcScreen.right-rcScreen.left-60)
                         /(rcClient.right-rcClient.left-60);
                if(Zoom<1) Zoom=1;
                Paint(hdc,rcClient,50);
                /* und wieder restaurieren */
                Zoom=Zoomalt;
                EndPage(hdc);
                EndDoc(hdc);

                DeleteDC(hdc);
                }
              return 0;
              }
             case CM_MESSEN:
              {
              char st1[2000],tempfilename[350],*cp;
              struct tm t,*pTime;
              time_t t1,t2;
              int a,jahr,monat;
              FILE *tempfile;
              double v;

              GetModuleFileName(0,tempfilename,340);
              if (cp=strrchr(tempfilename,'.')) strcpy(cp,"_tmp.txt");
              tempfile=fopen(tempfilename,"w");

              /* Uhrzeit der Klickpos errechnen */
              a=KlickX-80;
              t2=Aktzeit+(a*Zoom);
              
              /* Stelle in der Datei aufsuchen */
             rewind (datei);
             fgets(st1,1490,datei); /* Die Kopfzeile haben wir schon */

             /* bis zur Startposition vorspulen */
                do
                 {
                  memset(st1,0,1490);
                  memset(&t,0,sizeof(t));
                  fgets(st1,1490,datei); /* eine Zeile einlesen */
		  /* Zeitstempel lesen */
		  sscanf(st1,"%d.%d.%d;%d:%d:%d",&t.tm_mday,&monat,&jahr,
				  &t.tm_hour,&t.tm_min,&t.tm_sec);
		  t.tm_mon=monat-1;
                  t.tm_year=jahr-1900;
                  t.tm_isdst=-1;
                  t1=mktime(&t);
                 }
                while ((t1<t2)&&(!feof(datei)));

              /* Werte auswerten */
              
              pTime=localtime(&t2);
              fprintf(tempfile,"geklickt %02d.%02d.%04d %02d:%02d:%02d\n"
                               ,pTime->tm_mday,
                                               pTime->tm_mon+1,
                                               pTime->tm_year+1900,
					       pTime->tm_hour,
                                               pTime->tm_min,
                                               pTime->tm_sec);
              pTime=localtime(&t1);
              fprintf(tempfile,"gefunden %02d.%02d.%04d %02d:%02d:%02d\n"
                               "============================\n",pTime->tm_mday,
                                               pTime->tm_mon+1,
                                               pTime->tm_year+1900,
					       pTime->tm_hour,
                                               pTime->tm_min,
                                               pTime->tm_sec);
              /* Kommas in Punkte umwandeln */
              cp=st1;
              while (cp=strchr(cp,',')) *cp='.';
              if(cp=strchr(st1,'\n')) *cp=0;  /*Zeilenendezeichen umwandeln*/

              cp=strchr(st1,';')+1;   /* das ist die Zeit */

                 for(a=0;a<ColumnCount;a++)
                  {
                   cp=strchr(cp,';');
                   if(cp)
                    {
                    cp++;
                    if(Spalten[a].aktiv)
                    {
                    v=1234.56;
                    sscanf(cp,"%lf",&v);
                    fprintf(tempfile,"%s = %lf %s\n",Spalten[a].name,v,Spalten[a].einheit);
                    }
                   }
                   else a=ColumnCount;
                  }              
              fclose(tempfile);
              ShellExecute(0,"open",tempfilename,NULL,"",SW_RESTORE);
              return 0;
              }
	     }
            return 0;
	   default:
	     return DefWindowProc (hWnd, uiMessage, wParam, lParam);  
	  }
	}


BOOL WINAPI Dialog1_DlgProc(HWND hWnd,
                    UINT wMsg,
                    WPARAM wParam,
                    LPARAM lParam)
   {
   static int Spalte;
   switch (wMsg)
     {
     case WM_INITDIALOG:
      {
       char st1[20];
       Spalte=lParam;
       sprintf(st1,"%08X",Spalten[Spalte].farbe);
       SendMessage(hWnd,WM_SETICON,ICON_BIG,(LPARAM)LoadIcon(g_hInst,MAKEINTRESOURCE(IDI_ICON1)));
       SendMessage(hWnd,WM_SETTEXT,0,(LPARAM) Spalten[Spalte].name);
       SendMessage(GetDlgItem(hWnd,IDC_EDIT1),WM_SETTEXT,0,(LPARAM) Spalten[Spalte].name);
       SendMessage(GetDlgItem(hWnd,IDC_UNIT),WM_SETTEXT,0,(LPARAM) Spalten[Spalte].einheit);
       SendMessage(GetDlgItem(hWnd,IDC_COLOR),WM_SETTEXT,0,(LPARAM) st1);
       if(Spalten[Spalte].aktiv) SendMessage(GetDlgItem(hWnd,IDC_VISIBLE),BM_SETCHECK,BST_CHECKED,0);
       else SendMessage(GetDlgItem(hWnd,IDC_VISIBLE),BM_SETCHECK,BST_UNCHECKED,0);
       if(Pairmode) SendMessage(GetDlgItem(hWnd,IDC_PAIRMODE),BM_SETCHECK,BST_CHECKED,0);
       else SendMessage(GetDlgItem(hWnd,IDC_PAIRMODE),BM_SETCHECK,BST_UNCHECKED,0);

       SetWindowLong(GetDlgItem(hWnd,IDC_COLORSEL),GWL_STYLE,WS_VISIBLE | WS_CHILD|BS_BITMAP);
       SendMessage(GetDlgItem(hWnd,IDC_COLORSEL),BM_SETIMAGE,IMAGE_BITMAP,
                          (LPARAM) LoadBitmap((HINSTANCE) GetWindowLong(hWnd, GWL_HINSTANCE),
                                            (LPCTSTR) IDB_COLOR));
       switch(Spalten[Spalte].stil)
        {

        case PS_DASH:
         {
         SendMessage(GetDlgItem(hWnd,IDC_DASH),BM_SETCHECK,BST_CHECKED,0);
         break;
         }

        case PS_DOT:
         {
         SendMessage(GetDlgItem(hWnd,IDC_DOT),BM_SETCHECK,BST_CHECKED,0);
         break;
         }

        case PS_DASHDOT:
         {
         SendMessage(GetDlgItem(hWnd,IDC_DASHDOT),BM_SETCHECK,BST_CHECKED,0);
         break;
         }

        case PS_DASHDOTDOT:
         {
         SendMessage(GetDlgItem(hWnd,IDC_DASHDOTDOT),BM_SETCHECK,BST_CHECKED,0);
         break;
         }

        default: SendMessage(GetDlgItem(hWnd,IDC_SOLID),BM_SETCHECK,BST_CHECKED,0);
        }

      }
      break;
     case WM_COMMAND:
      {
      switch (LOWORD(wParam))
       {
       case IDC_OK:
        {
         char st1[100];
         /* Eingegebene Werte speichern */

         SendMessage(GetDlgItem(hWnd,IDC_EDIT1),WM_GETTEXT,20,(LPARAM) Spalten[Spalte].name);
         SendMessage(GetDlgItem(hWnd,IDC_UNIT),WM_GETTEXT,20,(LPARAM) Spalten[Spalte].einheit);
         if(SendMessage(GetDlgItem(hWnd,IDC_VISIBLE),BM_GETCHECK,0,0)==BST_CHECKED)
          Spalten[Spalte].aktiv=1;
         else
          Spalten[Spalte].aktiv=0;
         if(SendMessage(GetDlgItem(hWnd,IDC_PAIRMODE),BM_GETCHECK,0,0)==BST_CHECKED)
          Pairmode=1;
         else
          Pairmode=0;
         SendMessage(GetDlgItem(hWnd,IDC_COLOR),WM_GETTEXT,20,(LPARAM) st1);
         sscanf(st1,"%x",&Spalten[Spalte].farbe);
         Spalten[Spalte].stil=PS_SOLID;
         if(SendMessage(GetDlgItem(hWnd,IDC_DASH),BM_GETCHECK,0,0)==BST_CHECKED) Spalten[Spalte].stil=PS_DASH;
         if(SendMessage(GetDlgItem(hWnd,IDC_DOT),BM_GETCHECK,0,0)==BST_CHECKED) Spalten[Spalte].stil=PS_DOT;
         if(SendMessage(GetDlgItem(hWnd,IDC_DASHDOT),BM_GETCHECK,0,0)==BST_CHECKED) Spalten[Spalte].stil=PS_DASHDOT;
         if(SendMessage(GetDlgItem(hWnd,IDC_DASHDOTDOT),BM_GETCHECK,0,0)==BST_CHECKED) Spalten[Spalte].stil=PS_DASHDOTDOT;
         EndDialog(hWnd,1);
        }
        break;
        
       case IDC_COLORSEL:
        {
        char st1[20];
        CHOOSECOLOR chk;
        COLORREF cc[16];
        ZeroMemory(&chk,sizeof(chk));
        SendMessage(GetDlgItem(hWnd,IDC_COLOR),WM_GETTEXT,19,(LPARAM) st1);
        sscanf(st1,"%x",&chk.rgbResult);
        chk.lStructSize=sizeof(chk);
        chk.hwndOwner=hWnd;
        chk.lpCustColors=cc;
        chk.Flags=CC_RGBINIT;
        if(ChooseColor(&chk))
         {
          sprintf(st1,"%08X",chk.rgbResult);
          SendMessage(GetDlgItem(hWnd,IDC_COLOR),WM_SETTEXT,0,(LPARAM) st1);
         }
        }
        break;
       
       case IDC_OTHERSOFF:
        {
        int a;
        for(a=0;a<ColumnCount;a++)
         {
         if(a!=Spalte) Spalten[a].aktiv=0;
         }
        SendMessage(GetDlgItem(hWnd,IDC_VISIBLE),BM_SETCHECK,BST_CHECKED,0); 
        }
        break;
                
       }  
      }
     break;
     case WM_SYSCOMMAND:
      {
       switch(wParam)
        {
         case SC_CLOSE:
         {
         EndDialog(hWnd,0);
         }
         break;
        }
      }
      break;  
     }
   return FALSE; 
   }


BOOL WINAPI Dialog2_DlgProc(HWND hWnd,
                    UINT wMsg,
                    WPARAM wParam,
                    LPARAM lParam)
   {
   switch (wMsg)
     {
     case WM_INITDIALOG:
      {
      char st1[65536],*cp,*cp1;
      FILE *datei;
      SendMessage(hWnd,WM_SETTEXT,0,(LPARAM) "Lizenzinformationen");
      GetModuleFileName(0,st1,290);
      cp=strrchr(st1,'\\');     /* wollen nur das Verzeichnis */
      if(cp) strcpy(cp,"\\gpl.txt");
      datei=fopen(st1,"rb");
      if(datei)
      {
      cp=st1;
      while(!feof(datei))
       {
       fgets(cp,200,datei);
       if(cp1=strchr(cp,13)) *cp1=0;
       strcat(cp,"\r\n");
       cp+=strlen(cp);
       }
      fclose(datei);
      cp=st1;
//      while(cp=strchr(cp,10)) *cp=13;
      }
      SendMessage(GetDlgItem(hWnd,IDC_DLG2_EDIT),WM_SETTEXT,0,(LPARAM) st1);
      }
      break;
     case WM_COMMAND:
      {
      switch (LOWORD(wParam))
       {
       case IDC_DLG2_OK:
        {
         EndDialog(hWnd,1);
        }
        break;                        
       }  
      }
     break;
     case WM_SYSCOMMAND:
      {
       switch(wParam)
        {
         case SC_CLOSE:
         {
         EndDialog(hWnd,0);
         }
         break;
        }
      }
      break;  
     }
   return FALSE; 
   }

BOOL WINAPI Dialog3_DlgProc(HWND hWnd,
                    UINT wMsg,
                    WPARAM wParam,
                    LPARAM lParam)
   {
   switch (wMsg)
     {
     case WM_INITDIALOG:
      {
      char st1[200];
      sprintf(st1,"%d",littlestep);
      SendMessage(GetDlgItem(hWnd,IDC_LITTLESTEP),WM_SETTEXT,0,(LPARAM) st1);
      sprintf(st1,"%d",bigstep);
      SendMessage(GetDlgItem(hWnd,IDC_BIGSTEP),WM_SETTEXT,0,(LPARAM) st1);
      sprintf(st1,"%d",Zoom);
      SendMessage(GetDlgItem(hWnd,IDC_HZOOM),WM_SETTEXT,0,(LPARAM) st1);
      sprintf(st1,"%f",Scale);
      SendMessage(GetDlgItem(hWnd,IDC_VZOOM),WM_SETTEXT,0,(LPARAM) st1);
      sprintf(st1,"%f",offset);
      SendMessage(GetDlgItem(hWnd,IDC_OFFSET),WM_SETTEXT,0,(LPARAM) st1);
      SendMessage(GetDlgItem(hWnd,IDC_FONT),WM_SETTEXT,0,(LPARAM) FontName);
      SendMessage(GetDlgItem(hWnd,IDC_DEFUNIT),WM_SETTEXT,0,(LPARAM) DefUnit);

      SetFocus(GetDlgItem(hWnd,IDOK));
      }
      break;
     case WM_COMMAND:
      {
      switch (LOWORD(wParam))
       {
       case IDOK:
        {
         char st1[200];
         SendMessage(GetDlgItem(hWnd,IDC_LITTLESTEP),WM_GETTEXT,190,(LPARAM) st1);
         sscanf(st1,"%d",&littlestep);
         SendMessage(GetDlgItem(hWnd,IDC_BIGSTEP),WM_GETTEXT,190,(LPARAM) st1);
         sscanf(st1,"%d",&bigstep);
         SendMessage(GetDlgItem(hWnd,IDC_HZOOM),WM_GETTEXT,190,(LPARAM) st1);
         sscanf(st1,"%d",&Zoom);        
         SendMessage(GetDlgItem(hWnd,IDC_VZOOM),WM_GETTEXT,190,(LPARAM) st1);
         sscanf(st1,"%f",&Scale);        
         SendMessage(GetDlgItem(hWnd,IDC_OFFSET),WM_GETTEXT,190,(LPARAM) st1);
         sscanf(st1,"%f",&offset);        
         SendMessage(GetDlgItem(hWnd,IDC_FONT),WM_GETTEXT,190,(LPARAM) FontName);
         SendMessage(GetDlgItem(hWnd,IDC_DEFUNIT),WM_GETTEXT,190,(LPARAM) DefUnit);
         if(Zoom<1) Zoom=1;
         InvalidateRect(g_hWnd,0,TRUE);
         EndDialog(hWnd,1);
        }
        break;
       case IDC_SELFONT:
        {
         CHOOSEFONT font;
         LOGFONT lf;
         SendMessage(GetDlgItem(hWnd,IDC_FONT),WM_GETTEXT,190,(LPARAM) lf.lfFaceName);
         lf.lfHeight=15;
         lf.lfWidth=10;
         lf.lfWeight=FW_NORMAL;
         
         memset(&font,0,sizeof(font));
         memset(&lf,0,sizeof(lf));
         font.lStructSize=sizeof(font);
         font.lpLogFont=&lf;
         font.nSizeMin=1;
         font.nSizeMax=50;
         font.hwndOwner=hWnd;
         font.Flags=CF_BOTH|CF_TTONLY;
         
         if(ChooseFont(&font))
          {        
           SendMessage(GetDlgItem(hWnd,IDC_FONT),WM_SETTEXT,0,(LPARAM) lf.lfFaceName);
          }
        return 0;
        }
       }  
      }
     break;
     case WM_SYSCOMMAND:
      {
       switch(wParam)
        {
         case SC_CLOSE:
         {
         EndDialog(hWnd,0);
         }
         break;
        }
      }
      break;  
     }
   return FALSE; 
   }


BOOL WINAPI Dialog4_DlgProc(HWND hWnd,
                    UINT wMsg,
                    WPARAM wParam,
                    LPARAM lParam)
   {
   switch (wMsg)
     {
     case WM_INITDIALOG:
      {
      char st1[200];
      struct tm *tmBuf;
      
      tmBuf=localtime(&Aktzeit);
      sprintf(st1,"%02d.%02d.%04d",
                tmBuf->tm_mday,tmBuf->tm_mon+1,tmBuf->tm_year+1900);
      SendMessage(GetDlgItem(hWnd,IDC_DATE),WM_SETTEXT,0,(LPARAM) st1);
      sprintf(st1,"%02d:%02d:%02d",
                tmBuf->tm_hour,tmBuf->tm_min,tmBuf->tm_sec);
      SendMessage(GetDlgItem(hWnd,IDC_TIME),WM_SETTEXT,0,(LPARAM) st1);
      SetFocus(GetDlgItem(hWnd,IDOK));
      }
      break;
     case WM_COMMAND:
      {
      switch (LOWORD(wParam))
       {
       case IDOK:
        {
         int monat,jahr;
         char st1[200];
         struct tm t;
         time_t t1;
         memset(&t,0,sizeof(t));
         SendMessage(GetDlgItem(hWnd,IDC_DATE),WM_GETTEXT,190,(LPARAM) st1);
                  sscanf(st1,"%d.%d.%d",&t.tm_mday,&monat,&jahr);

         SendMessage(GetDlgItem(hWnd,IDC_TIME),WM_GETTEXT,190,(LPARAM) st1);
         sscanf(st1,"%d:%d:%d",&t.tm_hour,&t.tm_min,&t.tm_sec);
         t.tm_mon=monat-1;
         t.tm_year=jahr-1900;
         t.tm_isdst=-1;
         t1=mktime(&t);
         if((t1<Startzeit)||(t1>Endzeit))
          {
          MessageBox(hWnd,"Uhrzeit nicht innerhalb der Aufzeichnung!","Fehler",MB_OK);
          return 0;
          }
         Aktzeit=t1;
         InvalidateRect(g_hWnd,0,TRUE);
         EndDialog(hWnd,1);
        }
        break;                        
       }  
      }
     break;
     case WM_SYSCOMMAND:
      {
       switch(wParam)
        {
         case SC_CLOSE:
         {
         EndDialog(hWnd,0);
         }
         break;
        }
      }
      break;  
     }
   return FALSE; 
   }

BOOL WINAPI Dialog5_DlgProc(HWND hWnd,
                    UINT wMsg,
                    WPARAM wParam,
                    LPARAM lParam)
   {
   static int ActItem=-1,Modify=0;
   switch (wMsg)
     {
     case WM_INITDIALOG:
      {
       int a;
       char st1[300];
       /* Das ListView erzeugen */
	LV_COLUMN lvc;
        LV_ITEM lvitem;
        FILTER *fp;

        if(Testmode) SendMessage(GetDlgItem(hWnd,IDC_TESTMODE),BM_SETCHECK,BST_CHECKED,0);
        else SendMessage(GetDlgItem(hWnd,IDC_TESTMODE),BM_SETCHECK,BST_UNCHECKED,0);
	g_hWndLv=CreateWindowEx(0,WC_LISTVIEW,"", 
			       WS_CHILD|WS_VISIBLE|WS_BORDER|WS_VSCROLL
			       |WS_HSCROLL|LVS_REPORT|WS_TABSTOP
			       |LVS_SHOWSELALWAYS, 
			       5,5,530,150, 
			       hWnd,(HMENU) IDC_LISTVIEW,
			       g_hInst,NULL);       

	ListView_SetExtendedListViewStyle(g_hWndLv, LVS_EX_GRIDLINES|LVS_EX_FULLROWSELECT);
        
        //Die Columnen erzeugen      
	lvc.mask=LVCF_TEXT| LVCF_WIDTH| LVCF_SUBITEM;
	lvc.fmt=LVCFMT_LEFT;
	lvc.cx=40;
	lvc.cchTextMax=40;
	lvc.iSubItem=0;
	lvc.pszText="Erweiterung";
	ListView_InsertColumn(g_hWndLv,0,&lvc);
	//Die zweite Spalte erzeugen
	lvc.iSubItem=1;
	lvc.cx=160;
	lvc.cchTextMax=160;
	lvc.pszText="Name";
	ListView_InsertColumn(g_hWndLv,1,&lvc);
	//Die dritte Spalte erzeugen
	lvc.iSubItem=2;
	lvc.cx=160;
	lvc.cchTextMax=160;
	lvc.pszText="Konverter";
	ListView_InsertColumn(g_hWndLv,2,&lvc);
	//Die vierte Spalte erzeugen
	lvc.iSubItem=3;
	lvc.cx=160;
	lvc.cchTextMax=160;
	lvc.pszText="Konfig";
	ListView_InsertColumn(g_hWndLv,3,&lvc);
        
        a=0;
        fp=Filter;
        while(fp)
         {
          lvitem.mask=LVIF_TEXT;
          lvitem.iItem=a+1;
          lvitem.state=0;
          lvitem.pszText=fp->ext;
          lvitem.cchTextMax=20;
          lvitem.lParam=0;
          lvitem.iSubItem=0;
          ListView_InsertItem(g_hWndLv, &lvitem);
          ListView_SetItemText(g_hWndLv,a,1,fp->name);
          ListView_SetItemText(g_hWndLv,a,2,fp->konverter);
          ListView_SetItemText(g_hWndLv,a,3,fp->konfig);
          fp=fp->next;
          a++;
         }
        
      SetFocus(GetDlgItem(hWnd,IDOK));
      }
      break;
      
     case WM_NOTIFY:
      {
      switch(wParam)
       {
       case IDC_LISTVIEW:
        {
        NM_LISTVIEW *lv=(NM_LISTVIEW*)lParam;
        
        if(lv->hdr.code==LVN_ITEMCHANGED)
         {
         char st1[400];
         if(Modify) return 0;
         if((lv->uChanged & LVIF_STATE)
          &&(lv->uNewState & LVIS_SELECTED)) /* neue Selektion */
          ActItem=lv->iItem;
          ListView_GetItemText(g_hWndLv,lv->iItem,0,st1,390);
	  SendMessage(GetDlgItem(hWnd,IDC_EXTENSION),WM_SETTEXT,0,(LPARAM) st1);
          ListView_GetItemText(g_hWndLv,lv->iItem,1,st1,390);
	  SendMessage(GetDlgItem(hWnd,IDC_NAME),WM_SETTEXT,0,(LPARAM) st1);
          ListView_GetItemText(g_hWndLv,lv->iItem,2,st1,390);
	  SendMessage(GetDlgItem(hWnd,IDC_KONVERTER),WM_SETTEXT,0,(LPARAM) st1);
          ListView_GetItemText(g_hWndLv,lv->iItem,3,st1,390);
	  SendMessage(GetDlgItem(hWnd,IDC_KONFIG),WM_SETTEXT,0,(LPARAM) st1);
         }
        return 0;
        }
       }
      return 0;
      }
      
     case WM_COMMAND:
      {
      switch (LOWORD(wParam))
       {
       case IDOK:
        {
         char st1[300];
         /* alte Struktur abrumen */
         PFILTER *fpp;
         FILTER *fp;
         int a,c;
         FiltClear();
         c=ListView_GetItemCount(g_hWndLv);
         fpp=&Filter;
         for(a=0;a<c;a++)
          {
          *fpp=calloc(1,sizeof(FILTER));
          fp=*fpp;
          ListView_GetItemText(g_hWndLv,a,0,fp->ext,19);
          ListView_GetItemText(g_hWndLv,a,1,fp->name,29);
          ListView_GetItemText(g_hWndLv,a,2,fp->konverter,299);
          ListView_GetItemText(g_hWndLv,a,3,fp->konfig,299);
          fp->next=NULL;
          fpp=&(fp->next);
          }         
          if(SendMessage(GetDlgItem(hWnd,IDC_TESTMODE),BM_GETCHECK,0,0)==BST_CHECKED)
           Testmode=1;
          else
           Testmode=0;
         EndDialog(hWnd,1);
         return 0;
        }
        
       case IDC_DEL:
        {
        if(ActItem<0) return 0;
        ListView_DeleteItem(g_hWndLv,ActItem);
        /* das, jetzt hochgerutschte, Item markieren */        
        ListView_SetItemState(g_hWndLv,ActItem,LVIS_SELECTED,LVIS_SELECTED);
        return 0;
        }
        
       case IDC_SELKONVERT:
        {
         OPENFILENAME ofn;
         char FileName[300];
         SendMessage(GetDlgItem(hWnd,IDC_KONVERTER),WM_GETTEXT,290,(LPARAM) FileName);
         ZeroMemory(&ofn,sizeof(ofn));
         ofn.lStructSize=sizeof(ofn);
         ofn.lpstrFilter="Programme\0*.exe\0"
                         "Batchdateien\0*.bat\0"
                         "alle Dateien\0*.*\0";
         ofn.hwndOwner=hWnd;
         ofn.lpstrFile=FileName;
         ofn.nMaxFile=300;
         ofn.lpstrTitle="Konverter Programm whlen!";
         ofn.Flags=OFN_FILEMUSTEXIST;
	             
         if(GetOpenFileName(&ofn))
           {
	    SendMessage(GetDlgItem(hWnd,IDC_KONVERTER),WM_SETTEXT,0,(LPARAM) FileName);
           }
        return 0;
        }
        
       case IDC_SELKONFIG:
        {
         OPENFILENAME ofn;
         char FileName[300];
         SendMessage(GetDlgItem(hWnd,IDC_KONFIG),WM_GETTEXT,290,(LPARAM) FileName);
         ZeroMemory(&ofn,sizeof(ofn));
         ofn.lStructSize=sizeof(ofn);
         ofn.lpstrFilter="Textdateien\0*.txt\0"
                         "CSV-Dateien\0*.csv\0"
                         "alle Dateien\0*.*\0";
         ofn.hwndOwner=hWnd;
         ofn.lpstrFile=FileName;
         ofn.nMaxFile=300;
         ofn.lpstrTitle="Konfig Datei whlen!";
         ofn.Flags=OFN_FILEMUSTEXIST;
	             
         if(GetOpenFileName(&ofn))
           {
	    SendMessage(GetDlgItem(hWnd,IDC_KONFIG),WM_SETTEXT,0,(LPARAM) FileName);
           }
        return 0;
        }
        
       case IDC_ADD:
        {
        char st1[400];
        LV_ITEM lvitem;
        strcpy(st1,"");
        lvitem.mask=LVIF_TEXT;
        if(ActItem<0) ActItem=ListView_GetItemCount(g_hWndLv);
        lvitem.iItem=ActItem;
        lvitem.state=0;
        lvitem.pszText=st1;
        lvitem.cchTextMax=20;
        lvitem.lParam=0;
        lvitem.iSubItem=0;
        ListView_InsertItem(g_hWndLv, &lvitem);
        Modify=1;
	SendMessage(GetDlgItem(hWnd,IDC_EXTENSION),WM_GETTEXT,390,(LPARAM) st1);
        ListView_SetItemText(g_hWndLv,ActItem,0,st1);
	SendMessage(GetDlgItem(hWnd,IDC_NAME),WM_GETTEXT,390,(LPARAM) st1);
        ListView_SetItemText(g_hWndLv,ActItem,1,st1);
	SendMessage(GetDlgItem(hWnd,IDC_KONVERTER),WM_GETTEXT,390,(LPARAM) st1);
        ListView_SetItemText(g_hWndLv,ActItem,2,st1);
	SendMessage(GetDlgItem(hWnd,IDC_KONFIG),WM_GETTEXT,390,(LPARAM) st1);
        ListView_SetItemText(g_hWndLv,ActItem,3,st1);
        Modify=0;

        return 0;
        }
       case IDC_MODIFY:
        {
        char st1[400];
        if(ActItem<0) return 0;
        Modify=1;
	SendMessage(GetDlgItem(hWnd,IDC_EXTENSION),WM_GETTEXT,390,(LPARAM) st1);
        ListView_SetItemText(g_hWndLv,ActItem,0,st1);
	SendMessage(GetDlgItem(hWnd,IDC_NAME),WM_GETTEXT,390,(LPARAM) st1);
        ListView_SetItemText(g_hWndLv,ActItem,1,st1);
	SendMessage(GetDlgItem(hWnd,IDC_KONVERTER),WM_GETTEXT,390,(LPARAM) st1);
        ListView_SetItemText(g_hWndLv,ActItem,2,st1);
	SendMessage(GetDlgItem(hWnd,IDC_KONFIG),WM_GETTEXT,390,(LPARAM) st1);
        ListView_SetItemText(g_hWndLv,ActItem,3,st1);
        Modify=0;
        return 0;
        }
       case IDCANCEL:
        {
        EndDialog(hWnd,0);
        return 0;
        }
       }
      return 0;
      }

     case WM_SYSCOMMAND:
      {
       switch(wParam)
        {
         case SC_CLOSE:
         {
         EndDialog(hWnd,0);
         }
         break;
        }
      }
      break;  
     }
   return FALSE; 
   }
