/*----------------------------------------------------------------------------
 *
 *  FILE NAME
 *      uart.h
 *
 *  DESCRIPTION
 *      Interruptgesteuert und gepufferte Datenbertragung.
 *
 *  AUTHOR
 *
 *
 *  MODIFICATION HISTORY
 *          Date      Name                Modification
 *
 *----------------------------------------------------------------------------
 */
#if !defined _UART_H_
#define _UART_H_

 
/* ---- MACROS & DEFINES -------------------------------------------------- */
/* RS232 receive buffer parameter, must be a power of 2 */
#define UART_RX_BUF_LEN     32
#define UART_RX_BUF_MSK     (UART_RX_BUF_LEN - 1)

/* RS232 transmit buffer parameter, must be a power of 2 */
#define UART_TX_BUF_LEN     32
#define UART_TX_BUF_MSK     (UART_TX_BUF_LEN - 1)

/* Port define */
#define UART0_RS232_SEL P3SEL
#define UART0_RS232_TX_PIN 0x10
#define UART0_RS232_RX_PIN 0x20

/* ---- LOCAL VARIABLES --------------------------------------------------- */


/* ---- GLOBAL FUNCTIONS -------------------------------------------------- */ 
void RS232_Init(void);
void RS232_Transmit(unsigned char value);
unsigned char RS232_Receive(void);

/* ---- LOCAL FUNCTIONS --------------------------------------------------- */
#endif /* _UART_H_ */