// --- [ eeprom.c ] -----------------------------------------------------------

#include <avr/io.h>
#include <avr/interrupt.h>
#include <stdlib.h>
#include "global.h"
#include "rs232.h"
// ----------------------------------------------------------------------------
// Schreibt genau 1 Byte an die angegebene Adresse im Eeprom

void ee_write_byte(uint8_t eeprom_adr, uint8_t data)
{
	while (EECR & (1<<EEPE));
/* ATMEGA88
	EEARH = (uint8_t) (eeprom_adr >> 8);	// Adresse schreiben
*/	EEARL  = (uint8_t) eeprom_adr;

	EEDR  = data;									// Daten schreiben

	cli();
	EECR |= (1<<EEMPE);
	EECR |= (1<<EEPE);
	sei();
}

// ----------------------------------------------------------------------------
// Liest genau 1 Byte an der angegebenen Adresse aus dem Eeprom
uint8_t ee_read_byte(uint8_t eeprom_adr)
{
	while (EECR & (1<<EEPE));
/* ATMEGA88
	EEARH = (uint8_t) (eeprom_adr >> 8);	// Adresse schreiben
*/	EEARL = (uint8_t) eeprom_adr;
	EECR |= (1<<EERE);							// Eeprom lesen
	return(EEDR);
}

// -----------------------------------------------------------------------------
// Gibt einen Speicherauszug des Eeproms aus
// in Zeile 1 werden die Variablen Autostart (0/255) und das Messintervall ausgegeben
// ab Zeile 2 folgen die Sensoren
void ee_print_eeprom(void)
{
uint8_t i, j;

put_c(13);											// Leerzeile ausgeben
put_c(13);
for (i = 0; i < EEPROM_SIZE; i += 8)		// Speicherauszug Eeprom drucken
	{
	for(j = 0; j < 8; j++)						// jeweils 8 Byte pro Zeile = 1 Sensor
		{
		put_s(utoa(ee_read_byte(i + j), msg, 16));
		put_c(' ');
		}
		put_c(13);
	}
}

// --- [ eof ] ----------------------------------------------------------------