/*******************************************************

					FT245.c

********************************************************/

#include "FT245.h"

#define FALSE 0
#define TRUE !0

// berprfung der Gltigkeit der FT245 Adresse
#if(FT245_ADRESS<0x9FFF || FT245_ADRESS>0xAFFF)
#error Adresse vom FT245 auerhalb des gltigen Bereiches!
#endif

// Konstanter Pointer, der auf die Adresse des FT245 zeigt
// wird fr das Einlesen bzw. Schreiben der Daten verwendet
uint8_t* ft245 = (uint8_t*) FT245_ADRESS;


/********************************************************
	Initialisiert TXE und RXF

Parameter:		NONE

Rckgabewert:	NONE
*********************************************************/

void ft245_init(void)
{
	TXE_DDR &= ~(1 << TXE_BIT);
	TXE_PORT |= (1 << TXE_BIT);
	RXF_DDR &= ~(1 << RXF_BIT);
	RXF_PORT |= (1 << RXF_BIT);
}


/********************************************************
	Schreibt ein Byte in den FIFO des FT245

Parameter:		byte	Datenbyte, das bertragen
						werden soll

Rckgabewert:	NONE
*********************************************************/

uint8_t ft245_write_byte(uint8_t byte)
{
	if(FT245_TXE_LOW())
	{
		*ft245 = byte;
		return 1;
	}
	else 
		return 0;
}

/********************************************************
	Liest ein Byte aus dem FIFO des FT245

Parameter:		NONE

Rckgabewert:	byte	ausgelesenes Datenbyte
*********************************************************/

uint8_t ft245_get_byte(volatile uint8_t* byte)
{
	if(FT245_RXF_LOW())
	{
		*byte = *ft245;
		return 1;
	}
	
	else 
		return 0;
}

