#include <avr/io.h>
#include "USB.h"
#include "rprintf.h"
#include "uart.h"

void initExtmem (void) __attribute__ ((naked)) __attribute__ ((section (".init0")));

void initExtmem (void)
{
	/* Enable XMEM Interface, No Waitstates */
	MCUCR |= (1 << SRE);
}

int main (void)
{	
	DDRG |=(1<<PG3);
	PORTG |= (1<<PG3);
	
	usbInit();
	uartInit();
	uartSetBaudRate(115200);

	while(1);
}
