/****************************************************************************
	COMMUNICATION.C

	Functions for communication over RS232 or USB

*****************************************************************************/
#include "communication.h"

#if COMM_MODE == RS232

 /* send single byte to USART, wait until transmission is completed */

void sendchar(char c)
{	
	UART_DATA_REG = c;                                   		// prepare transmission
    while (!(UART_STATUS_REG & (1 << UART_TRANSMIT_COMPLETE)));	// wait until byte sent
    UART_STATUS_REG |= (1 << UART_TRANSMIT_COMPLETE);          	// delete TXC flag
}

 /* Read single byte from USART, block if no data available */

unsigned char recchar(void)
{
    while(!(UART_STATUS_REG & (1 << UART_RECEIVE_COMPLETE)));  // wait for data
    return UART_DATA_REG;
}

unsigned char newDataAvailable(void)
{
	return UART_STATUS_REG & (1 << UART_RECEIVE_COMPLETE);
}
#endif


#if COMM_MODE == USB_FDXX

// berprfung der Gltigkeit der FT245 Adresse
#if(FT245_ADRESS<0xA000 || FT245_ADRESS>0xAFFF)
#error Adresse vom FT245 auerhalb des gltigen Bereiches!
#endif

// Konstanter Pointer, der auf die Adresse des FT245 zeigt
// wird fr das Einlesen bzw. Schreiben der Daten verwendet
uint8_t* ft245 = (uint8_t*) FT245_ADRESS;

/* Sendefunktion fr den FTS245 */

void sendchar(char c)
{
	while(ft245_TXE_HIGH());
	*ft245 = c;
}

/* Empfangsfunktion fr den FT245 */

unsigned char recchar(void)
{
	while(ft245_RXF_HIGH());
	return *ft245;
}

unsigned char newDataAvailable(void)
{
	return ft245_RXF_LOW();
}
#endif





