 
/* MalZeit 06/2014 */

#ifndef LED_PORTS_H
#define LED_PORTS_H

#include <avr/io.h>

#ifndef DDR_OFFSET
  #define DDR_OFFSET(X) (*(&X-1))
#endif
#ifndef PIN_OFFSET
  #define PIN_OFFSET(X) (*(&X-2))
#endif

#define LED1          (PORTD)
#define LED1_PIN      (1<<PD2)
#define LED2          (PORTD)
#define LED2_PIN      (1<<PD3)
#define LED3          (PORTD)
#define LED3_PIN      (1<<PD4)
#define LED4          (PORTD)
#define LED4_PIN      (1<<PD5)
#define LED5          (PORTD)
#define LED5_PIN      (1<<PD6)
#define LED6          (PORTD)
#define LED6_PIN      (1<<PD7)

void LedPortsDisable(void);
void LedPortsEnable(void);
void LedPortsInit(void);
// void LedPortsIo(uint8_t data, uint8_t num); // private ???
void LedPortsSetzen(uint8_t bits);

#endif // LED_PORTS_H

// EOF
