
/* MalZeit 08/2014 */


#include "kodierer_ports.h"

#include <avr/io.h>

#ifndef DDR_OFFSET
  #define DDR_OFFSET(X) (*(&X-1))
#endif
#ifndef PIN_OFFSET
  #define PIN_OFFSET(X) (*(&X-2))
#endif


#define KODIERER1          (PORTC)
#define KODIERER1_PIN      (1<<PC0)
#define KODIERER2          (PORTC)
#define KODIERER2_PIN      (1<<PC1)
#define KODIERER4          (PORTC)
#define KODIERER4_PIN      (1<<PC2)
#define KODIERER8          (PORTC)
#define KODIERER8_PIN      (1<<PC3)


void KodiererPortsInit(void);
uint8_t KodiererPortsLesen(void);
 
/**
 * 
 * 
 * 
 * 
 */
void KodiererPortsInit(void)
{
  // Als Eingänge definieren
  DDR_OFFSET(KODIERER1) &= ~KODIERER1_PIN;
  DDR_OFFSET(KODIERER2) &= ~KODIERER2_PIN;
  DDR_OFFSET(KODIERER4) &= ~KODIERER4_PIN;
  DDR_OFFSET(KODIERER8) &= ~KODIERER8_PIN;

  // Pull-up-Widerstand Ein
  KODIERER1 |= KODIERER1_PIN;
  KODIERER2 |= KODIERER2_PIN;
  KODIERER4 |= KODIERER4_PIN;
  KODIERER8 |= KODIERER8_PIN;  
}

/**
 * 
 * 
 * 
 * 
 */
uint8_t KodiererPortsLesen(void)
{
  uint8_t result = 0;
  if( (PIN_OFFSET(KODIERER1) & KODIERER1_PIN) == 0) {
    result |= 1<<0;
  }
  if( (PIN_OFFSET(KODIERER2) & KODIERER2_PIN) == 0) {
    result |= 1<<1;
  }
  if( (PIN_OFFSET(KODIERER4) & KODIERER4_PIN) == 0) {
    result |= 1<<2;
  }
  if( (PIN_OFFSET(KODIERER8) & KODIERER8_PIN) == 0) {
    result |= 1<<3;
  }
  return result;  
}

// EOF
