



#include "logarithmierer.h"

#include <math.h>

/**
 *
 *
 * Umsetzung eins 16-Bit wertes in einen logarithmierten 16-Bit-Wertes
 *
 */ 


void LogarithmiererErzeugeSkala(uint16_t pStufen[], uint8_t stufenZahl, int8_t bereich_dB);


uint8_t LogarithmiererBildeWert(uint16_t wert, uint16_t pStufen[], uint8_t stufenZahl);


/**
 * 
 * 
 * 
 */

uint8_t LogarithmiererBildeWert(uint16_t wert, uint16_t pStufen[], uint8_t stufenZahl)
{
  uint8_t ret;
  
  for (ret = 0; ret < stufenZahl; ret++) {
    if(wert < pStufen[stufenZahl-1-ret]) { // bei der niederwertigsten Stufe beginnen
      break;
    }
  }
  
  return ret;  
}

/**
 * 
 * 
 * pStufen Array das in absteigender Reihenfolge die 
 * stufenZahl Anzahl der Stufen
 * bereich_dB Niedriegster anzeigbarer Dezibel-Wert
 * 
 */

/*
 * Zaunpfahlproblem
 * * Der Schwellwert liegt zwischen der Stufenteilung
 */

/**
 * Algorithmus:
 * 
 * Beispiel 3 Stufen -30 dB Bereich
 *   * <- LED
 * 
 *  --- (0 dB)
 *   *  -5 dB
 *  --- (-10 dB)
 *   *  -15 dB
 *  --- (-20 dB)
 *   *  -25 dB
 *  --- (-30 dB)
 * 
 *  2*n+1 Teilung
 *  Die ausgegebenen Schwellwerte ohne Klammern aus 7 Teilstufen
 * 
 **/

void LogarithmiererErzeugeSkala(uint16_t pStufen[], uint8_t stufenZahl, int8_t bereich_dB)
{
  uint8_t teilStufungen = stufenZahl * 2 + 1; // 2n+1
  float schrittweite = (float) bereich_dB / (float) teilStufungen;
  
  for(uint8_t zaehler = 0; zaehler < teilStufungen; zaehler++) {
    // nur bei ungeraden Werten Berechnen
    if(zaehler%2 != 0) {
      float dB = schrittweite * zaehler;
      float faktor = pow(10, dB/20);
      uint16_t schwelle = faktor * 0xffff;
      if(zaehler/2 < stufenZahl) { // zur Sicherheit
        pStufen[zaehler/2] = schwelle;
      } else {
	// TODO Fehlerfall
      }
    }  
  }
}
