
/* MalZeit 06/2014 */

#include <avr/io.h>


#ifndef AD_WANDLER_H
#define AD_WANDLER_H

#ifdef USING_ADC
#warning "ADC already used"
#endif
#define USING_ADC

#ifdef USING_TIMER1
#warning "Timer1 already used"
#endif
#define USING_TIMER1


#if F_CPU != 8000000UL
  #warning "F_CPU != 8000000UL"
#endif

#define AD_WANDLER_START_ATOMIC (ADCSRA &= ~_BV(ADIE))
#define AD_WANDLER_STOP_ATOMIC (ADCSRA |= _BV(ADIE))



void AdWandlerInit(void);
void AdWandlerStart(void);

void AdWandlerRegistriereCb(void (*callback) (uint16_t analog));





#endif // AD_WANDLER_H
