
/**
 * 
 * 
 * 
 */

#include "led_balken.h"

#include <math.h>

#include "logarithmierer.h"
#include "led_ports.h"


#define STUFEN_ZAHL 6
#define BEREICH_DB -15

static uint16_t gStufen[STUFEN_ZAHL] = {0};

void LedBalkenInit(void);
void LedBalkenSetzeWert(uint16_t wert);
void LedBalkenErzeugeSkala(uint16_t *pStufen, uint8_t stufenZahl, int8_t bereich_dB);

/**
 * 
 * 
 * 
 * 
 */

void LedBalkenInit(void)
{
  LedPortsInit();
  LogarithmiererErzeugeSkala(gStufen, STUFEN_ZAHL, BEREICH_DB);
  
}

/**
 * 
 * 
 * 
 */

void LedBalkenSetzeWert(uint16_t wert)
{
  uint8_t anzeige;
static uint16_t vorWert = 0;
  uint16_t temp = wert;
  wert = (vorWert/2) + (wert/2);
  vorWert = temp;
  anzeige = LogarithmiererBildeWert(wert, gStufen, STUFEN_ZAHL);
  
  LedPortsSetzen((1<<anzeige)-1);  

}


// EOF

