
/* MalZeit 06/2014 */

#include <avr/io.h>


#ifndef DMX_UART_H
#define DMX_UART_H

#ifdef USING_USART0
#warning "USART0 already used"
#endif
#define USING_USART0


#if F_CPU != 8000000UL
  #warning "F_CPU != 8000000UL"
#endif


// Ausnahmsweise #include <utils/atomic.h> verwenden


void DmxUartInit(void);
void DmxUartStart(void);

void DmxUartRegistriereCb(void (*callback) (void));

void DmxUartClearTxPort(void);
void DmxUartSetTxPort(void);
void DmxUartEnableDataTx(void);

void DmxUartWarteAufTxc(void);

void DmxUartTxData(uint8_t data);
void DmxUartTxBreak(void);

#endif // DMX_UART_H 
