 
/* MalZeit 06/2014 */

#include <avr/io.h>

#include <led_ports.h>

/**
 * 
 * 
 * 
 */

#ifndef DDR_OFFSET
  #define DDR_OFFSET(X) (*(&X-1))
#endif
#ifndef PIN_OFFSET
  #define PIN_OFFSET(X) (*(&X-2))
#endif

#define LED1          (PORTD)
#define LED1_PIN      (1<<PD2)
#define LED2          (PORTD)
#define LED2_PIN      (1<<PD3)
#define LED3          (PORTD)
#define LED3_PIN      (1<<PD4)
#define LED4          (PORTD)
#define LED4_PIN      (1<<PD5)
#define LED5          (PORTD)
#define LED5_PIN      (1<<PD6)
#define LED6          (PORTD)
#define LED6_PIN      (1<<PD7)


void LedPortsInit(void);
void LedPortsSetzen(uint8_t bits);

/**
 * 
 * 
 * 
 * 
 */

void LedPortsInit(void)
{
  // ausgang
  DDR_OFFSET(LED1) |= LED1_PIN; 
  DDR_OFFSET(LED2) |= LED2_PIN; 
  DDR_OFFSET(LED3) |= LED3_PIN; 
  DDR_OFFSET(LED4) |= LED4_PIN; 
  DDR_OFFSET(LED5) |= LED5_PIN; 
  DDR_OFFSET(LED6) |= LED6_PIN;

/*
  DDR_OFFSET(LED1) &= ~LED1_PIN; 
  DDR_OFFSET(LED2) &= ~LED2_PIN; 
  DDR_OFFSET(LED3) &= ~LED3_PIN; 
  DDR_OFFSET(LED4) &= ~LED4_PIN; 
  DDR_OFFSET(LED5) &= ~LED5_PIN; 
  DDR_OFFSET(LED6) &= ~LED6_PIN; 
*/
  // alles aus
  LED1 &= ~LED1_PIN;
  LED2 &= ~LED2_PIN;
  LED3 &= ~LED3_PIN;
  LED4 &= ~LED4_PIN;
  LED5 &= ~LED5_PIN;
  LED6 &= ~LED6_PIN;
 
}

/**
 * 
 * 
 * 
 */

void LedPortsSetzen(uint8_t bits)
{
  for(uint8_t i = 0; i < 6; i++) {
    uint8_t bit = 1<<i;
    if((bits & bit) != 0) {
      switch(i) { // setzen
        case 0: LED1 |= LED1_PIN; break; 
        case 1: LED2 |= LED2_PIN; break;
        case 2: LED3 |= LED3_PIN; break;
        case 3: LED4 |= LED4_PIN; break;
        case 4: LED5 |= LED5_PIN; break;
        case 5: LED6 |= LED6_PIN; break;
      }
    } else {
      switch(i) { // löschen
        case 0: LED1 &= ~LED1_PIN; break; 
        case 1: LED2 &= ~LED2_PIN; break;
        case 2: LED3 &= ~LED3_PIN; break;
        case 3: LED4 &= ~LED4_PIN; break;
        case 4: LED5 &= ~LED5_PIN; break;
        case 5: LED6 &= ~LED6_PIN; break;
      }
    }
  } 
}



// EOF
