 
/* MalZeit 06/2014 */


/**
 * 
 * Systemzeigeber
 * 
 * Aktivierung jede Millisekunde
 * 
 */

#include <avr/io.h>


#ifndef SYSTEMZEITGEBER_H
#define SYSTEMZEITGEBER_H

#ifdef USING_TIMER0
#warning "Timer0 already used"
#endif
#define USING_TIMER0

#if F_CPU != 8000000UL
  #warning "F_CPU != 8000000UL"
#endif


#define SYSTEMZEITGEBER_CB_ARRAY 3

#define SYSTEMZEITGEBER_ATOMIC_START (TIMSK0 &= ~_BV(OCIE0A) )
#define SYSTEMZEITGEBER_ATOMIC_ENDE  (TIMSK0 |= _BV(OCIE0A))

void SystemzeitgeberInit(void);
uint8_t SystemzeitgeberHoleWdtId(void);
void SystemzeitgeberRegistriereCb(void (*callback) (void), int8_t ms);
void SystemzeitgeberRegistriereWdtManagerCb(void (*callback) (uint8_t id));
void SystemzeitgeberSetzeWdtId(uint8_t id);
void SystemzeitgeberStart(void);
void SystemzeitgeberStop(void); 
 
#endif // SYSTEMZEITGEBER_H