/*------------------------------------------------------------------------------------------------------------------------------------------------*//**
 * @file display_wc_eng.c
 * 
 *  This files implements the english language specific.
 *
 * \version $Id: display_wc_eng.c 285 2010-03-24 21:43:24Z vt $
 * 
 * \author Copyright (c) 2010 Vlad Tepesch    
 * 
 * \remarks
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 */
 /*-----------------------------------------------------------------------------------------------------------------------------------------------*/


#include <inttypes.h>
#include <avr/io.h>
#include <util/delay.h>
#include <avr/pgmspace.h>

#include "main.h"
#include "display.h"
#include "shift.h"

#include "wceeprom.h"


#if (WC_DISP_ENG == 1)

/* TODO: make PROGMEM if more ram is needed (+10B Progmem)*/
/* TODO: make more flexible */
#define DISP_SETBIT(x) ( 1L << ( (x) -DWP_MIN_FIRST))
/* consider to put translationmatrix to flash  */
static const uint8_t minData[11] =  {
  (DISP_SETBIT(DWP_fiveMin)  | DISP_SETBIT(DWP_past) ),
  (DISP_SETBIT(DWP_tenMin)   | DISP_SETBIT(DWP_past) ),
  (DISP_SETBIT(DWP_quarter)  | DISP_SETBIT(DWP_past) ),
  (DISP_SETBIT(DWP_twenty )  | DISP_SETBIT(DWP_past) ),
  (DISP_SETBIT(DWP_twenty )  | DISP_SETBIT(DWP_fiveMin) | DISP_SETBIT(DWP_past) ),
  (DISP_SETBIT(DWP_half)     | DISP_SETBIT(DWP_past) ),
  (DISP_SETBIT(DWP_twenty )  | DISP_SETBIT(DWP_fiveMin) | DISP_SETBIT(DWP_to) ),
  (DISP_SETBIT(DWP_twenty )  | DISP_SETBIT(DWP_to) ),
  (DISP_SETBIT(DWP_quarter)  | DISP_SETBIT(DWP_to) ),
  (DISP_SETBIT(DWP_tenMin)   | DISP_SETBIT(DWP_to) ),
  (DISP_SETBIT(DWP_fiveMin)  | DISP_SETBIT(DWP_to) ),


};

#undef DISP_SETBIT



DisplayState display_getTimeState (const DATETIME* i_newDateTime)
{
  uint8_t hour    = i_newDateTime->hh;
  uint8_t minutes = i_newDateTime->mm;

  uint8_t minuteLeds = minutes%5;
  uint32_t leds = (1L << DWP_itis);

  minutes = minutes/5;

  if(hour>12)
    hour-=12;

  if(hour==0)
    hour = 12;

  if(minutes>0){
    uint8_t minState ;
    minState = ( minData[minutes-1]);
    if(minutes>6)
      ++hour;
    leds |= ((uint32_t)minState)<<DWP_MIN_FIRST;
  }else{
    leds |= (1L << DWP_clock);
  }

  for(;minuteLeds;--minuteLeds){
    leds |= (1L << (minuteLeds-1 + DWP_MIN_LEDS_BEGIN));
  }

  //uint8_t minuteLeds = minutes%5;
  //minutes = (minutes/5 * 5);

  //for(;minuteLeds;--minuteLeds){
  //  leds |= (1<< (minuteLeds-1 + DWP_MIN_LEDS_BEGIN));
  //}
  //if(minutes<5){
  //  leds |= (1<<DWP_clock);
  //}else if(minutes < 10){
  //  leds |= (1<<DWP_fuenfMin);
  //  leds |= (1<<DWP_nach);
  //}else if(minutes < 15){
  //  leds |= (1<<DWP_zehnMin);
  //  leds |= (1<<DWP_nach);
  //}else if(minutes < 20){
  //  leds |= (1<<DWP_viertel);
  //  if(g_displayParams.ossiMode){
  //    leds |= (1<<DWP_nach);
  //  }else{
  //    ++hour;
  //  }
  //}else if(minutes < 25){
  //  leds |= (1<<DWP_zehnMin);
  //  leds |= (1<<DWP_vorMin);
  //  leds |= (1<<DWP_halb);
  //  ++hour;
  //}else if(minutes < 30){
  //  leds |= (1<<DWP_fuenfMin);
  //  leds |= (1<<DWP_vorMin);
  //  leds |= (1<<DWP_halb);
  //  ++hour;
  //}else if(minutes < 35){
  //  leds |= (1<<DWP_halb);
  //  ++hour;
  //}else if(minutes < 40){
  //  leds |= (1<<DWP_fuenfMin);
  //  leds |= (1<<DWP_nach);
  //  leds |= (1<<DWP_halb);
  //  ++hour;
  //}else if(minutes < 45){
  //  leds |= (1<<DWP_zehnMin);
  //  leds |= (1<<DWP_nach);
  //  leds |= (1<<DWP_halb);
  //  ++hour;
  //}else if(minutes < 50){
  //  leds |= (1<<DWP_viertel);
  //  ++hour;
  //  if(g_displayParams.ossiMode){
  //    leds |= (1<<DWP_vorHour);
  //  }else{
  //    leds |= (1<<DWP_dreiHour);
  //  }
  //}else if(minutes < 55){
  //  leds |= (1<<DWP_zehnMin);
  //  leds |= (1<<DWP_vorHour);
  //  ++hour;
  //}else if(minutes < 60){
  //  leds |= (1<<DWP_fuenfMin);
  //  leds |= (1<<DWP_vorMin);
  //  ++hour;
  //}


  if(hour>12)
    hour-=12;

  leds |= (1L<< (DWP_HOUR_BEGIN-1 + hour));

  return leds;

}

#endif /* WC_DISP_ENG */