// .----------------------------------------.
// |ASAM - ATtiny Sunny Accumulator Manager |
// '----------------------------------------'
// for charging and protecting against deep discharge of rechargable batteries
// schematic and code by simon[at]mindsnack.net
// Version 1.0

#include <avr/io.h>
#include <stdint.h>
#include <avr/interrupt.h>
#include <avr/wdt.h>
#include <avr/io.h>
#include <avr/sleep.h>

// interne Referenz fr 10bit-ADC: 1,1V
// Abtastschritt = 1,1V / 1024 = 0,00107421875V

// Abtastwert muss durch 11 geteilt werden, wegen Spannungsteiler R2/R4
// Abtastwert = Akkuspannung / 11 / 0,00107421875V

/*
// Lion-Akku
#define CHARGE_LIMIT 346 	 // 4,10V
#define BAT_MIN 321	 	 // 3,8V
#define BAT_LOW 279	 	 // 3,3V
*/

// 4xNiMh-Akku
#define CHARGE_LIMIT 457 // 5,4V
#define BAT_MIN 440	 	 // 5,2V
#define BAT_LOW 372	 	 // 4,4V


/* ADC initialisieren */
void ADC_Init(void) {
 
  uint16_t result;
 
  // interne Referenzspannung als Refernz fr den ADC whlen:
  ADMUX = /*(1<<REFS1) |*/ (1<<REFS0);
  
  // Bit ADFR ("free running") in ADCSRA steht beim Einschalten
  // schon auf 0, also single conversion
  ADCSRA = (1<<ADPS1) | (1<<ADPS0);     // Frequenzvorteiler
  ADCSRA |= (1<<ADEN);                  // ADC aktivieren
 
  /* nach Aktivieren des ADC wird ein "Dummy-Readout" empfohlen, man liest
     also einen Wert und verwirft diesen, um den ADC "warmlaufen zu lassen" */
 
  ADCSRA |= (1<<ADSC);                  // eine ADC-Wandlung 
  while (ADCSRA & (1<<ADSC) ) {         // auf Abschluss der Konvertierung warten
  }
  /* ADCW muss einmal gelesen werden, sonst wird Ergebnis der nchsten
     Wandlung nicht bernommen. */
  result = ADCW;
}
 
/* ADC Einzelmessung */
uint16_t ADC_Read( uint8_t channel )
{
  // Kanal waehlen, ohne andere Bits zu beeinfluen
  ADMUX = (ADMUX & ~(0x1F)) | (channel & 0x1F);
  ADCSRA |= (1<<ADSC);            // eine Wandlung "single conversion"
  while (ADCSRA & (1<<ADSC) ) {   // auf Abschluss der Konvertierung warten
  }
  return ADCW;                    // ADC auslesen und zurckgeben
}
 
 
int main()
{

cli();                   // Interrupts global abschalten
wdt_enable (WDTO_8S);    // Watchdog auf 8 Sekunden -> alle 8 Sekunden eine Messung, sonst Power Save

  uint16_t adcval;
  ADC_Init();

  DDRB |= 0b00010110;	 // PB1=LOW_BATT; PB2=LED; PB4=LOADING
  PORTB &= ~(1<<PB2); 	 // LED aus
  PORTB |= (1<<PB1);  	 // Last wegnehmen
 
  while(5)
	{
	PORTB |= (1<<PB2);		// LED an, zeigt ob und wie lange ATtiny aktiv ist

	adcval = ADC_Read(3);   	// Kanal 3
    

	if (adcval<=CHARGE_LIMIT)			
		{
		PORTB &= ~(1<<PB4);	// Laden
		}
	else
		{
		PORTB |= (1<<PB4);	// stoppe Laden
		}

	if (adcval>=BAT_MIN)
		{
		PORTB &= ~(1<<PB1);	// Mindestakkuspannung OK -> last ein
		}

	if (adcval<=BAT_LOW)
		{
		PORTB |= (1<<PB1);	// Akkuspannung niedrig -> Last aus
		}

	//_delay_ms(50);

	PORTB &= ~(1<<PB2); 	// LED aus		


	set_sleep_mode(SLEEP_MODE_PWR_DOWN);	// sleep mode bis watchdog aufweckt
	sleep_mode();


	}
} 

