#include <SPI.h> 
#include <Ethernet.h>
#include <SD.h> 
#include <EEPROM.h>
#define BUFSZ1  22
#define BUFSZ2  22
#define SS_SD   4
#define SS_Eth 10

byte mac[] = {0xDE, 0xAD, 0xBE, 0xEF, 0xFE, 0xED};
IPAddress ip; 
EthernetServer server(80);                          
File webFile; 
EthernetClient client;
char reqBuf1[BUFSZ1];  //File Buffer, Get Buffer
char reqBuf2[BUFSZ2];  //Post Buffer
char fileName[12];
char pwd[5];  //Geheimer Schlüssel
char sid[5];  //Session-Id
char key[5];  //Zufallswert
byte dat[4];  //Datenspeicher
int pin[4] = {2,3,5,6};
boolean jsEnable=false;
int fehler=0;

void setup() {
  Serial.begin(9600);
  for(byte i=0;i<4;i++) pinMode(pin[i], OUTPUT); // Zugeordnete Anschlüsse auf Ausgabe
  pinMode(SS_SD, OUTPUT);
  pinMode(SS_Eth, OUTPUT);
  digitalWrite(SS_Eth, HIGH);  // Ethernet INACTIVE
  digitalWrite(SS_SD, LOW);  // SD Card ACTIVE
  if (!SD.begin(4)) asm volatile (" jmp 0");  
  if(!(webFile = SD.open("ip.dat"))) asm volatile (" jmp 0");  
  if (webFile){
     while(webFile.available()) {
       webFile.read(reqBuf1,BUFSZ1) ;
       char* ptr = strtok(reqBuf1, ".");
       byte i = 0;
       while(ptr && (i<4)) {
          ip[i++]=atoi(ptr);
          ptr = strtok(NULL,".");
       }
     }  
     webFile.close();
  } 
  digitalWrite(SS_SD, HIGH);  // SD Card INACTIVE
  digitalWrite(SS_Eth, LOW);  // Ethernet ACTIVE
  Ethernet.begin(mac, ip);
  server.begin();   
}

void fileRead(char *filename,EthernetClient client){
   digitalWrite(SS_Eth, HIGH);  // Ethernet INACTIVE
   digitalWrite(SS_SD, LOW);  // SD Card ACTIVE
   if(!(webFile = SD.open(filename))) asm volatile (" jmp 0");
    //  Website von SD-Karte laden
   if (webFile){
     while(webFile.available()) {
       char fcont = (char)webFile.read();
       client.write(fcont); // Website an Client schicken
     }
     webFile.close();
   }
   digitalWrite(SS_SD, HIGH);  // SD Card INACTIVE
   digitalWrite(SS_Eth, LOW);  // Ethernet ACTIVE
}

void loop() {
   EthernetClient client = server.available(); 
   if(client)  {
     boolean blankline = true;
     byte bufInd=0;
     char *pos;  
        for(byte i=0;i<BUFSZ1;i++) reqBuf1[i]=0;
        for(byte i=0;i<BUFSZ2;i++) reqBuf2[i]=0;
     
     while (client.connected()) {
       if (client.available()) {
         char c = client.read();
         if(bufInd < (BUFSZ1-1)) reqBuf1[bufInd++]=c;   
         if (c == '\n' && blankline) { 
           bufInd=0;
           while (client.available()) {    //Postbereich lesen
             char c = client.read();
             if(bufInd < (BUFSZ2-1)) reqBuf2[bufInd++]=c;  
          }
          if (strstr(reqBuf1,"frame.htm")){
          if ((pos=strstr(reqBuf2,"sid"))&&(!strncmp(pos+4,sid,4))&&(fehler==0)){
            if(pos=strstr(reqBuf2,"btn")){
              int bnr=atoi(pos+3);
              char stat[3];
              strncpy(stat,pos+5,3);
              if(!strcmp(stat,"Ein")){
                dat[bnr-1]=1; 
                digitalWrite(pin[bnr-1], HIGH); 
              } else if (!strcmp(stat,"Aus")){
                dat[bnr-1]=0;   
                digitalWrite(pin[bnr-1], LOW); 
              }
            }  
          } else {
            fehler++;
            client.println(F("HTTP/1.1 403 Forbidden"));
            client.println(F("Content-Type: text/html"));
            client.println(F("Connection: close"));
            client.println();
            client.println(F("<!DOCTYPE html><html><head><title>403 - Forbidden</title></head>"));
            client.println(F("<body><h1>Forbidden</h1></body></html>"));
            break;
          }    
            client.println(F("HTTP/1.1 200 OK"));
            client.println(F("Content-Type: text/html"));
            client.println(F("Connection: close"));
            client.println();
            client.println(F("<script> ")); // Übertragung der Zustände aus dem Datenspeicher an den Browser
            for(byte k=1;k<5;k++){
              client.print(F("var newVal"));
              client.print(k);
              client.print(F("=\"")); 
              if (dat[k-1]==0) client.print(F("Ein"));
              else if (dat[k-1]==1) client.print(F("Aus"));  
              client.println(F("\"\; "));
            }  
            client.println(F("</script>"));
            fileRead("frame.htm",client);    
            break;            
          } else if (strstr(reqBuf1,"frdum.htm")){
            client.println(F("HTTP/1.1 200 OK"));
            client.println(F("Content-Type: text/html"));
            client.println(F("Connection: close"));
            client.println();
            fileRead("frdum.htm",client);  
            break;
          } else if (strstr(reqBuf1,"main.htm")){
            if ((pos=strstr(reqBuf2,"sid="))&&(!strncmp(pos+4,sid,4))) {  
              fehler=0;            
              client.println(F("HTTP/1.1 200 OK"));
              client.println(F("Content-Type: text/html"));
              client.println(F("Connection: close"));
              client.println();
              client.print(F("<script> "));
              client.print(F("var sid=\"")); 
              client.print(sid); 
              client.println(F("\" </script>"));
              fileRead("main.htm",client);        //Kennwort richtig    
            } else {
              fehler++;
              client.println(F("HTTP/1.1 301 Redirect"));
              client.println(F("Content-Type: text/html"));
              client.println(F("Connection: close"));
              client.println();
              client.println(F("<!DOCTYPE html><html><head><title>301 Redirect</title>"));
              client.println(F("<meta http-equiv=\"refresh\" content=\""));
              if (fehler<4) client.println(3);
              else client.println(5*fehler);
              client.println(F("; index.htm\"></head>"));
              client.println(F("<body><h1>Falsches Kennwort</h1></body></html>"));
            } 
            break;
          } else if(strstr(reqBuf1,"index.js")){
            client.println(F("HTTP/1.1 200 OK "));
            client.println(F("Content-Type: application/javascript"));
            client.println(F("Connection: close"));
            client.println(); 
            if(jsEnable){
              client.print(F(" var key = \""));
              client.print(key);
              client.println(F("\""));
              fileRead("index.js",client);  
            }
            jsEnable = false;
            break;        
          } else if(strstr(reqBuf1,"GET / ") || strstr(reqBuf1,"index.htm" )){      
            int seed = 17135;  //x-beliebiger Ausgangswert 
                   // Kennwort aus Datei auslesen
            digitalWrite(SS_Eth, HIGH); 
            digitalWrite(SS_SD, LOW);  
            File pwdFile;
            if(!(pwdFile= SD.open("pwd.dat", FILE_READ))) asm volatile (" jmp 0"); 
            int i=0;
            while (pwdFile.available()&& i<5  ) pwd[i++] = pwdFile.read();
            pwdFile.close(); 
            digitalWrite(SS_SD, HIGH);  
            digitalWrite(SS_Eth, LOW); 
            for(i=0;i<4;i++) seed = seed * 7 + (int)EEPROM.read(i);                 
            randomSeed(seed);
            sprintf(key,"%4d",random(100,9999));
            key[0] = (key[0]==' ')? '0':key[0];
                 // Verschlüsseln durch Vertauschen und übertragslose Addition
            byte exc[] = {3,1,0,2}; 
            Serial.println((int)pwd[4]);
            if ((int)pwd[4]>52){
              exc[1]= 2;
              exc[3]= 1;
            }
            for(byte i=0;i<4;i++){  
              int j = (exc[i]+ (int)pwd[4]-48) %4 ; //Rotation der Vertauschung der Stellen                   
              int sum =((int)pwd[j] + (int)key[j]);
              sum -= (sum > 105)? 58:48;
              sid[i]= (char)sum;
              EEPROM.write(i,sum);  
            }
            sid[4]='\0';
            client.println(F("HTTP/1.1 200 OK"));
            client.println(F("Content-Type: text/html"));
            client.println(F("Connection: close"));
            client.println();
            fileRead("index.htm",client);
            jsEnable = true;
            break;
          } else {
            client.println(F("HTTP/1.1 403 Forbidden"));
            client.println(F("Content-Type: text/html"));
            client.println(F("Connection: close"));
            client.println();
            client.println(F("<!DOCTYPE html><html><head><title>403 - Forbidden</title></head>"));
            client.println(F("<body><h1>Forbidden</h1></body></html>"));
            break;
          }   // end index
        } //end if c=='\n'...
        if (c == '\n') {
          blankline = true;
        } 
        else if (c != '\r') {
          blankline = false;
        }
      } // end if client available
    } // end while connected
    delay(10);
    client.stop();
  }  // end if client 
} //end loop

