/*------------------------------------------------------------------------------------------------------------------------------------------------*//**
 * @file display_eng.h
 * 
 *  This files contain the english language specific definitions that are required for display.
 *
 * $Id$
 * 
 * \author Vlad Tepesch    Copyright (c) 2009 
 * 
 * \remarks
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 */
 /*-----------------------------------------------------------------------------------------------------------------------------------------------*/


#ifndef _WC_DISPLAY_ENG_H_
#define _WC_DISPLAY_ENG_H_

#ifdef __cplusplus
extern "C"
{
#endif 


/**
 * This Enum defines how the led words are connected to the Board and the position 
 * in the state data (	that's why the minutes (gpio, not shift register) are also in this enum )
 * @details In different languages at least the constants for the 
 *          hours (DWP_one to DWP_twelve), the it-is (DWP_itis), the four minutes (DWP_min[1234]) and 
 *          clock (DWP_clock) have to exist, so they can be used for interface
 *          the minute words are too diffrent and should not be used outside of display_[language].h/c
 *          Following two preconditions were made:
 *          - the eight Minute words are placed consecutively
 *            (but not neccessaryly ordered)
 *            and DWP_MIN_FIRST defines the first of them
 *          - the twelve hours are orderd consecutively
 *            and DWP_HOUR_BEGIN defines the first of them
 */
enum e_displayWordPos
{
  DWP_itis = 0,
  DWP_fiveMin ,
  DWP_tenMin ,
  DWP_quarter ,
  DWP_twenty ,
  DWP_half ,
  DWP_to ,
  DWP_past ,
  DWP_one ,
  DWP_two ,
  DWP_three ,
  DWP_four ,
  DWP_five ,
  DWP_six ,
  DWP_seven ,
  DWP_eight ,
  DWP_nine ,
  DWP_ten ,
  DWP_eleven ,
  DWP_twelve ,
  DWP_clock ,
  DWP_min1,
  DWP_min2,
  DWP_min3,
  DWP_min4,

  DWP_WORDSCOUNT  
};

/** the first of the minute words */
#define DWP_MIN_FIRST       DWP_fiveMin
/** the first hour word */
#define DWP_HOUR_BEGIN      DWP_one
/** the last pos in the emu that has acorresponding bit in the shift register */
#define DWP_LAST_SR_POS     DWP_clock
/** the first of the dots that reside on gpio */
#define DWP_MIN_LEDS_BEGIN  DWP_min1




/** a bitmask that contains all minute reated words 
 *  @details Can be used to set minutes to blink in display_setDisplayState
 */
#define DISPLAY_MINUTE_MASK \
  (    ( 1L<< DWP_fiveMin ) \
     | ( 1L<< DWP_tenMin  ) \
     | ( 1L<< DWP_quarter ) \
     | ( 1L<< DWP_twenty  ) \
     | ( 1L<< DWP_half    ) \
     | ( 1L<< DWP_to      ) \
     | ( 1L<< DWP_past    ) \
     | ( 1L<< DWP_min1    ) \
     | ( 1L<< DWP_min2    ) \
     | ( 1L<< DWP_min3    ) \
     | ( 1L<< DWP_min4    ))

/** a bitmask that contains all hour reated words 
 *  @details Can be used to set hours to blink in display_setDisplayState
 */
#define DISPLAY_HOUR_MASK  \
  (    ( 1L<< DWP_one    ) \
     | ( 1L<< DWP_two   ) \
     | ( 1L<< DWP_three   ) \
     | ( 1L<< DWP_four   ) \
     | ( 1L<< DWP_five  ) \
     | ( 1L<< DWP_six  ) \
     | ( 1L<< DWP_seven ) \
     | ( 1L<< DWP_eight   ) \
     | ( 1L<< DWP_nine   ) \
     | ( 1L<< DWP_ten   ) \
     | ( 1L<< DWP_eleven    ) \
     | ( 1l<< DWP_twelve ))


/**
 * contains display paraeters
 * @TODO have to be put into EEPROM
 */
struct DisplayEepromParams{
  uint8_t dummy; 
};

#define DISPLAYEEPROMPARAMS_DEFAULT { \
  /* .dummy = */ 0 \
}




#ifdef __cplusplus
}
#endif 


#endif /* _WC_DISPLAY_ENG_H_ */