/*---------------------------------------------------------------------------------------------------------------------------------------------------
 * irmp.h
 *
 * Copyright (c) 2009 Frank Meyer - frank(at)fli4l.de
 *
 * ATMEGA88 @ 8 MHz
 *
 * $Id$
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *---------------------------------------------------------------------------------------------------------------------------------------------------
 */

#ifndef _WC_IRMP_H_
#define _WC_IRMP_H_

#define IRMP_SIRCS_PROTOCOL                        1                                            // Sony
#define IRMP_NEC_PROTOCOL                          2                                            // NEC, Pioneer, JVC, Toshiba, NoName etc.
#define IRMP_SAMSUNG_PROTOCOL                      3                                            // Samsung
#define IRMP_MATSUSHITA_PROTOCOL                   4                                            // Samsung
#define IRMP_KASEIKYO_PROTOCOL                     5                                            // Kaseikyo (Panasonic etc)
#define IRMP_RECS80_PROTOCOL                       6                                            // Thomson, Nordmende, Telefunken, Saba

#define IRMP_COMMAND_MASK             0xFFFF

typedef struct
{
  uint8_t               protocol;                                                               // protocol, i.e. NEC_PROTOCOL
  uint16_t              address;                                                                // address
  uint16_t              command;                                                                // command
} IRMP_DATA;


/**
 *  Initialize IRMP decoder
 *  @details  Configures IRMP input pin
 */
extern void                           irmp_init (void);

/**
 *  Get IRMP data
 *  @details  gets decoded IRMP data
 *  @param    pointer in order to store IRMP data
 *  @return    TRUE: successful, FALSE: failed
 */
extern uint8_t                        irmp_get_data (IRMP_DATA *);

/**
 *  ISR routine
 *  @details  ISR routine, called 10000 times per second
 */
extern void                           irmp_ISR (void);

#endif /* _WC_IRMP_H_ */
