/*---------------------------------------------------------------------------------------------------------------------------------------------------
 * main.h
 *
 * Copyright (c) 2009 Frank Meyer - frank(at)fli4l.de
 *
 * ATMEGA88 @ 8 MHz
 *
 * $Id$
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *---------------------------------------------------------------------------------------------------------------------------------------------------
 */

#ifndef _WC_X_H_
#define _WC_X_H_

#ifdef __cplusplus
extern "C"
{
#endif


#ifndef F_CPU
#error F_CPU unkown
#endif

#define IR_COMMAND_MASK       IRMP_COMMAND_MASK
#define ir_init               irmp_init
#define ir_get_data           irmp_get_data
#define ir_set_code           irmp_set_code
#define ir_ISR                irmp_ISR

#define TRUE                  1
#define FALSE                 0

// Debugging:
#define MAIN_LOG               0
#define IR_LOGGING             0
#define DISPLAY_LOG_STATE      0
#define USER_LOG_IR_CMD        0
#define USER_LOG_STATE         0
#define USER_LOG_TIME          0
#define USER_LOG_IR_TRAIN      0
#define EEPROM_LOG_INIT        0
#define EEPROM_LOG_WRITEBACK   0



typedef struct
{
  unsigned char  YY;   ///< year    0-99
  unsigned char  MM;   ///< month  1-12
  unsigned char  DD;   ///< day    0-31
  unsigned char  hh;   ///< hour    0-23
  unsigned char  mm;   ///< minutes  0-59
  unsigned char  ss;   ///< seconds  0-59
  unsigned char  wd;   ///< weekday  0-6, 0 = sunday
} DATETIME;

extern void       main_ISR(void);

#ifdef __cplusplus
}
#endif
#endif /* _WC_X_H_ */
