/*---------------------------------------------------------------------------------------------------------------------------------------------------
 * pwm.h
 *
 * Copyright (c) 2009 Frank Meyer - frank(at)fli4l.de
 *
 * ATMEGA88 @ 8 MHz
 *
 * $Id$
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *---------------------------------------------------------------------------------------------------------------------------------------------------
 */

#ifndef _WC_PWM_H_
#define _WC_PWM_H_

#ifdef __cplusplus
extern  "C"
{
#endif


#define MAX_PWM_STEPS         32                    // 32 PWM steps


/**
 *  Initialize the PWM
 *  @details  Configures 0CR0A, 0CR0B and 0CR2B as PWM channels
 */
extern void                   pwm_init (void);

/**
 *  Switch PWM on
 *  @details  Switches PWM on with a narrow spike on all 3 channels -> leds glowing
 */
extern void                   pwm_on (void);

/**
 *  Switch PWM off
 *  @details  Switches PWM off
 */
extern void                   pwm_off (void);

/**
 *  Toggle PWM off/on
 *  @details  Toggles PWM off/on
 */
extern void                   pwm_on_off (void);

/**
 *  Set RGB colors
 *  @details  sets RGB color
 *  @param    red    range 0-255
 *  @param    green  range 0-255
 *  @param    blue   range 0-255
 */
extern void                   pwm_set_colors (uint8_t red, 
                                              uint8_t green, 
                                              uint8_t blue);

/**
 *  Get RGB colors
 *  @details  gets RGB color
 *  @param    redp    pointer to value of red pwm: range 0-255
 *  @param    greenp  pointer to value of green pwm: range 0-255
 *  @param    bluep   pointer to value of blue pwm: range 0-255
 */
extern void                   pwm_get_colors (uint8_t * redp, 
                                              uint8_t * greenp, 
                                              uint8_t * bluep);

/**
 *  Set RGB colors by step values
 *  @details  sets RGB color by step values
 *  @param    red_step    range 0 to MAX_PWM_STEPS
 *  @param    green_step  range 0 to MAX_PWM_STEPS
 *  @param    blue_step   range 0 to MAX_PWM_STEPS
 */
extern void                   pwm_set_color_step (uint8_t red_step, 
                                                  uint8_t green_step, 
                                                  uint8_t blue_step);

/**
 *  Get RGB color step values
 *  @details  grts RGB color step values
 *  @param    red_stepp    pointer zo red_step: range 0 to MAX_PWM_STEPS
 *  @param    green_stepp  pointer zo green_step: range 0 to MAX_PWM_STEPS
 *  @param    blue_stepp   pointer zo blue_step: range 0 to MAX_PWM_STEPS
 */
extern void                   pwm_get_color_step (uint8_t * red_stepp, 
                                                  uint8_t * green_stepp, 
                                                  uint8_t * blue_stepp);

/**
 *  Set base brightness by step 0-31
 *  @details  sets base brightness by step 0-31
 *  @param    pwm_idx  pwm step 0-31
 */
extern void                   pwm_set_base_brightness_step (uint8_t pwm_idx);


/**
 *  Step up brightness
 *  @details  Steps up brightness
 */
extern void                   pwm_step_up_brightness (void);

/**
 *  Step down brightness
 *  @details  Steps down brightness
 */
extern void                   pwm_step_down_brightness (void);



#ifdef __cplusplus
}
#endif

#endif /* _WC_PWM_H_ */
