/** Diese Datei steht unter der GPL3
 *  Thorsten Wilmer 2008
 */


#include "font6x8.xbm"

#include "lcd.h"
#include "trace.h"
#include <ch.h>
int dutyCycle = 0xFF / 2;
typedef enum {
	ORIENTATION_BOTTOM, ORIENTATION_TOP

} eOrientation;
eOrientation curOrientation=ORIENTATION_TOP;

void setLcdCmd(unsigned char value) {
	AT91F_PIO_ClearOutput(LCD_PIO, LCD_A0);
	AT91F_SPI_PutChar(LCD_SPI, value, 0);
	while ((LCD_SPI->SPI_SR & AT91C_SPI_TDRE) == 0)
		;
}
void setLcdData(unsigned char value) {
	AT91F_SPI_PutChar(LCD_SPI, value, 0);
	while ((LCD_SPI->SPI_SR & AT91C_SPI_TDRE) == 0)
		;
}

void printLine(int line, const char *str) {
	int displayPos = 0;
	const unsigned  char *font;
	if(curOrientation==ORIENTATION_BOTTOM)
		font=font6x8_bits;
	else
		font=font6x8_bits;

	while (displayPos < 132) {

		int subPos = 0;
		for (subPos = 0; subPos < 6; subPos++) {
			int charDataPos;
			if (*str >= ' ' && *str <= '~') {
				charDataPos = 6 * (*str - 0x20) + subPos;
			} else {
				charDataPos = 0;
			}

			if (charDataPos < sizeof(font6x8_bits)) {
				displayData[line][subPos + displayPos] = font[charDataPos];
			}
		}
		displayPos += 6;
		if (*str != 0)
			str++;
	}
	while (displayPos < 132) {
		displayData[line][displayPos] = 0;
		displayPos++;
	}

}
void printDisplayData() {
	int line;
	// setLcdCmd(0x40);
		setDisplayOrientation(curOrientation);
		setLcdCmd(0xA6);
		setLcdCmd(0xA2);
		setLcdCmd(0x2F);
		setLcdCmd(0xF8);
		setLcdCmd(0x00);
		setLcdCmd(0x23);
		setLcdCmd(0x81);
		setLcdCmd(0x1F);
		setLcdCmd(0xAC);
		setLcdCmd(0x00);
		setLcdCmd(0xAF);
	for(line=0; line<LCD_LINES; line++)
	{
	setLcdCmd(0xB0 | line); // Page0
	setLcdCmd(0x10);
	setLcdCmd(0x10);
	setLcdCmd(0x00);
	setLcdCmd(0x00);
	AT91F_PIO_SetOutput(LCD_PIO, LCD_A0);
	int i;



	for (i = 0; i < 132; i++) {
		setLcdData(displayData[line][i]);
	}
	AT91F_PIO_ClearOutput(LCD_PIO, LCD_A0);
	}
}

int lastState = 0xF00;
int pos = 0x20;
int dir = 0;

int access = 0;
const int TICKS_PER_SECOND=46875;
int ticks  =0;
void INTERRUPT ISR_Timer()
{
	int status=AT91C_BASE_TC0->TC_SR;
	if(status& AT91C_TC_CPCS)
		dir=3;

	int dummy=AT91C_BASE_TC0->TC_IMR;
		dummy=dummy;
	access++;
	ticks+=TICKS_PER_SECOND;

   END_INTERRUPT();
}

int lastRecieverState=0;
int lastMeasureTime=0;
int curMeasureTime=0;
int measured=0;
int lastDuration=0;
int measeureArray[40];
int measeureArrayL[40];
void irToggled()
{
	curMeasureTime=ticks+AT91C_BASE_TC0->TC_CV;
	lastDuration=curMeasureTime-lastMeasureTime;
		lastMeasureTime=curMeasureTime;

	if(measured<40)
	{
		if(lastDuration>255) lastDuration=0;
		measeureArray[measured]=lastDuration;
		measeureArrayL[measured]=lastRecieverState !=0 ? 1 : 0;
		measured++;
	}



}
void INTERRUPT ISR_Button(void) {

	int curState = 0;
	access++;

	AT91F_PIO_GetInterruptStatus(LCD_PIO);
	unsigned int value = AT91F_PIO_GetInput(LCD_PIO);

	int receiverState=value  & IR_IN;
	if(receiverState!=lastRecieverState)
	{
		lastRecieverState=receiverState;
		irToggled();

	}


	curState = 0;
	if (value & BUTTON_ROT_A) {
		curState = 2;
	}
	if (value & BUTTON_ROT_B) {
		curState += 1;
	}

	if (curState != lastState) {

		switch (lastState << 2 | curState) {
		case B8(1101):
			dir = -1;
			break;
		case B8(1110):
			dir = 1;
			break;
		case B8(0001):
			dir = 1;
			break;
		case B8(0010):
			dir = -1;
			break;
		case B8(0111):
			dir = 1;
			break;
		case B8(0100):
			dir = -1;
			break;
		case B8(1000):
			dir = 1;
			break;
		case B8(1011):
			dir = -1;
			break;
		default:
			dir = 0;
		}
		pos += dir;
		if (pos < 0)
			pos = 99;
		if (pos > 99)
			pos = 0;
		lastState = curState;
	}
	access--;
   END_INTERRUPT();
}

void setDisplayOrientation(eOrientation orientation) {
	if (orientation == ORIENTATION_BOTTOM) {
		setLcdCmd(0xA1);
		setLcdCmd(0xC0);
	} else {
		setLcdCmd(0xA0);
		setLcdCmd(0xC8);
	}

}
void toggleOrientation() {
	if (curOrientation == ORIENTATION_BOTTOM) {
		curOrientation = ORIENTATION_TOP;
	} else {
		curOrientation = ORIENTATION_BOTTOM;
	}
	setLcdCmd(curOrientation);
}

void print(char *data)
{
	int i;
	for(i=0;i<LCD_WIDTH/6;i++)
	{
		charData[1][i]=charData[2][i];
		charData[2][i]=charData[3][i];
		charData[3][i]=0;
	}
	for(i=0; i<LCD_WIDTH/6 && data[i]!=0; i++)
	{
		charData[3][i]=data[i];
	}


}
void initialize_lcd() {



	AT91F_AIC_AcknowledgeIt(AT91C_BASE_AIC);

	AT91F_SPI_CfgPMC();
	AT91F_PIOA_CfgPMC();
	AT91F_TC0_CfgPMC();

	AT91F_PIO_CfgPullupDisable(LCD_PIO, (LCD_CSB | // Disable All Pullups
			LCD_RS | LCD_A0 | LCD_SCK | LCD_LED | LCD_MOSI));

	AT91F_PIO_CfgOutput(LCD_PIO, LCD_RS | LCD_A0 | LCD_LED);
	AT91F_PIO_ClearOutput(LCD_PIO, LCD_LED);
	AT91F_PIO_SetOutput(LCD_PIO, LCD_LED);
	AT91F_PIO_ClearOutput(LCD_PIO, LCD_LED);
	AT91F_PIO_SetOutput(LCD_PIO, LCD_LED);
	AT91F_PIO_ClearOutput(LCD_PIO, LCD_RS);
	AT91F_PIO_CfgPeriph(LCD_PIO, LCD_PIO_A, LCD_PIO_B);
	AT91F_SPI_Reset(LCD_SPI);
	AT91F_SPI_Disable(LCD_SPI);
	AT91F_SPI_Enable(LCD_SPI);
	TRACE_INFO("Habe SPI configuriert...\n");
	AT91F_SPI_CfgMode(LCD_SPI, AT91C_SPI_MSTR | // Use Master
			AT91C_SPI_PS_FIXED | // Fixed CS
			~AT91C_SPI_PCSDEC | // Only plain CS lines
			AT91C_SPI_MODFDIS // No fault detection
	);

	AT91F_SPI_CfgPCS(LCD_SPI, 0);
	AT91F_PIO_SetOutput(LCD_PIO, LCD_RS);
	delay(10);
	AT91F_PIO_ClearOutput(LCD_PIO, LCD_RS);
	delay(100);
	AT91F_PIO_SetOutput(LCD_PIO, LCD_RS);
	delay(100);
	int cs;
	for (cs = 0; cs < 4; cs++) {
		int value = AT91C_SPI_CPOL | // 1 nicht active clock high
				AT91C_SPI_CSAAT | //  CS nicht sofort  anziehn
				AT91C_SPI_BITS_8 | //  8 Bit Transfer
				(AT91C_SPI_SCBR & (3 << 8)) | // 48 Mhz durch 1
				(AT91C_SPI_DLYBS & (10 << 16)) | // Delay zwischen eine Frames
				(AT91C_SPI_DLYBCT & (10 << 24)); // Delay zum umschalten
		AT91F_SPI_CfgCs(LCD_SPI, cs, value);
	}
	TRACE_INFO("2.VersuchOK\n");

	setLcdCmd(0xE2); // Reset
	setLcdCmd(0x40);
	setDisplayOrientation(curOrientation);
	setLcdCmd(0xA6);
	setLcdCmd(0xA2);
	setLcdCmd(0x2F);
	setLcdCmd(0xF8);
	setLcdCmd(0x00);
	setLcdCmd(0x23);
	setLcdCmd(0x81);
	setLcdCmd(0x1F);
	setLcdCmd(0xAC);
	setLcdCmd(0x00);
	setLcdCmd(0xAF);

	int row;
	int i;
	char displayData[132];
	for (i = 0; i < 132; i++) {
		displayData[i] = i;
	}
	for (row = 0; row < 9; row++) {
		setLcdCmd(0xB0 | row); // Page0
		setLcdCmd(0x10);
		setLcdCmd(0x10);
		setLcdCmd(0x00);
		setLcdCmd(0x00);
		AT91F_PIO_SetOutput(LCD_PIO, LCD_A0);
		/*while(0!= AT91F_SPI_SendFrame(LCD_SPI, displayData, 132, 0, 0));
		 TRACE_INFO("Warte auf PDC\n");
		 while (! AT91F_PDC_IsTxEmpty( (AT91PS_PDC) &(LCD_SPI->SPI_RPR)));
		 TRACE_INFO("Warte auf PDC ... done\n");*/

		for (i = 0; i < 132; i++) {
			setLcdData(0x00);

		}

		AT91F_PIO_ClearOutput(LCD_PIO, LCD_A0);

	}

	char *test = "Dies ist ein Text   !";
	printLine(3,test);
	printLine(2,"Zeile1");
	printLine(1,"Zeile2");
	TRACE_INFO("Display text gezeigt\n");

	AT91F_PIO_CfgPullupDisable(LCD_PIO, BUTTON_E | BUTTON_D | BUTTON_ROT_A
			| BUTTON_ROT_B | BUTTON_ROT_C | IR_IN);
	AT91F_PIO_CfgInput(LCD_PIO, BUTTON_E | BUTTON_D | BUTTON_ROT_A
			| BUTTON_ROT_B | BUTTON_ROT_C | IR_IN);
	AT91F_PIO_CfgInputFilter(LCD_PIO, BUTTON_E | BUTTON_D | BUTTON_ROT_A
			| BUTTON_ROT_B | BUTTON_ROT_C | IR_IN);

	AT91F_PIO_CfgPeriph(LCD_PIO, LCD_PIO_A, LCD_PIO_B);
	AT91F_PWMC_CfgPMC(); // Enable PWM

	AT91F_PWMC_CfgChannel(AT91C_BASE_PWMC, AT91C_PWMC_CHID0, 1, 0xFF, dutyCycle);
	AT91F_PWMC_StartChannel(AT91C_BASE_PWMC, AT91C_PWMC_CHID0);



	AT91F_AIC_ConfigureIt(AT91C_BASE_AIC, AT91C_ID_PIOA,
			AT91C_AIC_PRIOR_LOWEST, AT91C_AIC_SRCTYPE_HIGH_LEVEL, //AT91C_AIC_SRCTYPE_INT_HIGH_LEVEL,
			ISR_Button);
	AT91F_PIO_InterruptEnable(LCD_PIO, BUTTON_E | BUTTON_ROT_A | BUTTON_ROT_B | IR_IN);
	AT91F_AIC_EnableIt(AT91C_BASE_AIC, AT91C_ID_PIOA );


	AT91F_AIC_ConfigureIt(AT91C_BASE_AIC, AT91C_ID_TC0,
			AT91C_AIC_PRIOR_LOWEST, AT91C_AIC_SRCTYPE_HIGH_LEVEL, //AT91C_AIC_SRCTYPE_INT_HIGH_LEVEL,
			ISR_Timer);


	AT91C_BASE_TCB->TCB_BMR=0;
	AT91C_BASE_TC0->TC_CMR=AT91C_TC_CLKS_TIMER_DIV5_CLOCK
	                   |   (AT91C_TC_CLKI*0)
	                   | AT91C_TC_BURST_NONE
	                   | AT91C_TC_WAVESEL_UP_AUTO
	                   | AT91C_TC_WAVE ;

	AT91C_BASE_TC0->TC_RC=TICKS_PER_SECOND ;// TC0 Timer interval 1 second
	AT91C_BASE_TC0->TC_RA=0xFFFF;
	AT91C_BASE_TC0->TC_RB=0xFFFF;


	AT91C_BASE_TC0->TC_IER=AT91C_TC_CPCS ; // Interrupt on RC
	AT91C_BASE_TCB->TCB_BCR=1;
	int dummy=AT91C_BASE_TC0->TC_IMR;
	AT91C_BASE_TC0->TC_CCR=AT91C_TC_CLKEN
	                  | AT91C_TC_SWTRG;
	dummy=dummy;
	AT91F_AIC_EnableIt(AT91C_BASE_AIC, AT91C_ID_TC0 );


}


void updateData()
{
	chSysLock();
	printLine(1,charData[1]);
	printLine(2,charData[2]);
	printLine(3,charData[3]);
	chSysUnlock();

	char data[15];
			data[14] = 0;
			data[0] = 'a';
			data[1] = 'b';
			data[2] = 'c';
			data[3] = 'd';
			data[4] = 'e';
			data[5] = 'f';
			if (AT91F_PIO_IsInputSet(LCD_PIO, BUTTON_ROT_A)) {
				data[0] = 'A';

			}
			if (AT91F_PIO_IsInputSet(LCD_PIO, BUTTON_ROT_B)) {
				data[1] = 'B';

			}

			if (AT91F_PIO_IsInputSet(LCD_PIO, BUTTON_ROT_C))
				data[2] = 'C';
			if (AT91F_PIO_IsInputSet(LCD_PIO, BUTTON_D))
				data[3] = 'D';
			else {
				dutyCycle -= 1;
				if (dutyCycle < 0)
					dutyCycle = 1;
				TRACE_INFO("Duty %d\n", dutyCycle);
				AT91F_PWMC_UpdateChannel(AT91C_BASE_PWMC, AT91C_PWMC_CHID0,
						dutyCycle);
			}



			if (AT91F_PIO_IsInputSet(LCD_PIO, BUTTON_E))
				data[4] = 'E';
			else {
				dutyCycle += 1;
				if (dutyCycle > 0xFF)
					dutyCycle = 0xFE;
				AT91F_PWMC_UpdateChannel(AT91C_BASE_PWMC, AT91C_PWMC_CHID0,
						dutyCycle);
				TRACE_INFO("Duty %d\n", dutyCycle);
			}
			if (AT91F_PIO_IsInputSet(LCD_PIO, IR_IN))
						data[5] = 'F';

			data[6] = pos % 100 / 10 + '0';
			data[7] = pos % 10 / 1 + '0';
			data[8] = ' ';

			data[9] = access % 100 / 10 + '0';
			data[10] = access % 10 / 1 + '0';
			data[11] = 'O';
			if (dir > 0)
				data[11] = '>';
			if (dir < 0)
				data[11] = '<';
			if (dir ==3)
						data[11] = '3';

			int value=AT91C_BASE_TC0->TC_CV;
			data[12] = value % 100 / 10 + '0';
			data[13] = value % 10 / 1 + '0';
			printLine(0,data);
			if(measured>0)
			{

				TRACE_INFO("New Measure\n");
				int i;
				for(i=0;i<measured;i++)
				{
					TRACE_INFO("%d %d %x\n",i,  measeureArrayL[i], measeureArray[i]);
				}
				measured=0;

			}
}
