/** Dise Datei steht unter der GPL3
 *  Thorsten Wilmer 2008
 */


#ifndef LCD_DISPLAY_H
#define LCD_DISPLAY_H

#include "common.h"
#include "device.h"
#include "board.h"

#if defined(AT91SAM7SEK)
#define LCD_LED         AT91C_PIO_PA0
#define LCD_CSB         AT91C_PIO_PA11
#define LCD_RS          AT91C_PIO_PA12
#define LCD_A0          AT91C_PIO_PA24
#define LCD_SCK         AT91C_PIO_PA14
#define LCD_MOSI        AT91C_PIO_PA13
#define LCD_PIO         AT91C_BASE_PIOA
#define LCD_PIO_ID      AT91C_ID_PIOA
// Define which peripherial Port has to be used
#define LCD_PIO_A       LCD_MOSI |  LCD_SCK | LCD_CSB  | LCD_LED  | AT91C_PIO_PA1
#define LCD_PIO_B      0

#define LCD_SPI         AT91C_BASE_SPI

#define BUTTON_E        AT91C_PIO_PA17
#define BUTTON_D        AT91C_PIO_PA28
#define BUTTON_ROT_A        AT91C_PIO_PA31
#define BUTTON_ROT_B        AT91C_PIO_PA30
#define BUTTON_ROT_C        AT91C_PIO_PA29

#define IR_IN       AT91C_PIO_PA5
#elif
#error please define the Board setup
#endif

void initialize_lcd();
void sendCharData();
void printDisplayData();
void print(char *data);
void updateData();
#define LCD_LINES 4
#define LCD_WIDTH 132
char displayData[LCD_LINES][132];
char charData[LCD_LINES][22];
 int dutyCycle;


#endif
