
#include "AT91SAM7S64.h"
#include "lib_AT91SAM7S64.h"
#include "common.h"
#include "device.h"
#include "board.h"

#include "ch.h"
#include "aic.h"

/*
 * SYS IRQ handling here.
 */
__attribute__((naked))
static void SYSIrqHandler(void) {

  chSysIRQEnterI();

  if (AT91C_BASE_PITC->PITC_PISR & AT91C_PITC_PITS) {
    (void) AT91C_BASE_PITC->PITC_PIVR;
    chSysTimerHandlerI();
  }
  AT91C_BASE_AIC->AIC_EOICR = 0;                                        \

  chSysIRQExitI();
}


/*
 * Board initialization code.
 */
void hwinit_os(void) {
  /*
   * PIT Initialization.
   */
  AIC_ConfigureIT(AT91C_ID_SYS,
                  AT91C_AIC_SRCTYPE_HIGH_LEVEL | (AT91C_AIC_PRIOR_HIGHEST - 1),
                  SYSIrqHandler);
  AIC_EnableIT(AT91C_ID_SYS);
  AT91C_BASE_PITC->PITC_PIMR = (AT91C_MASTER_CLOCK / 16 / CH_FREQUENCY) - 1;
  AT91C_BASE_PITC->PITC_PIMR |= AT91C_PITC_PITEN | AT91C_PITC_PITIEN;


}

extern void default_irq_handler(void);

/*
 * Initialize the Advanced Interrupt Controller with stub handlers and
 * all interrupts disabled.
 */
void hwinit() {
  int i;
AT91F_AIC_CfgPMC();

  AT91C_BASE_AIC->AIC_IDCR = 0xFFFFFFFF;
  AT91C_BASE_AIC->AIC_FFDR = 0xFFFFFFFF;
  AT91C_BASE_AIC->AIC_ICCR = 0xFFFFFFFF;
  AT91C_BASE_AIC->AIC_EOICR = 0xFFFFFFFF;

  AT91C_BASE_AIC->AIC_DCR = 0x1;

  AT91C_BASE_AIC->AIC_SVR[0] = (long int) default_irq_handler;
  for (i=1; i<31; i++) {
    AT91C_BASE_AIC->AIC_SVR[i] = (long int) default_irq_handler;
  }
  AT91C_BASE_AIC->AIC_SPU = (long int) default_irq_handler;


  hwinit_os();

}


