// interrupt-driven serial debug output routines (USAR1)
// Diese Datei steht unter der GPL3, bis auf die Methoden Namen wurde
// Die Programmlogik komplett überarbeitet.
// test

#include <stdarg.h>
#include "common.h"
#include "device.h"
#include "board.h"
#include "vxprintf.h"
#include "trace.h"
#include <ch.h>

#define TXBUF_SIZE 256                          // size of transmit buffer
static char txbuf[3][TXBUF_SIZE]; // transmit buffer (FIFO queue)
static int txlen[3];
static int nextBufferToSend;

/* Mutex for console*/
void doTrace(const char *data) {
	while (*data != 0) {
		while (!AT91F_US_TxReady(AT91C_BASE_US1))
			;
		AT91F_US_PutChar(AT91C_BASE_US1, *data);

		data++;
	}
	return;
}


/** used to switch to the Next buffer*/
void switchToNextBuffer() {
	nextBufferToSend++;
	if (nextBufferToSend >= 3)

		nextBufferToSend = 0;
}
/** Interrupt routine to send Trace Messages.
 *   If no data are available Interrupt is disabled
 */
void INTERRUPT trace_txint() {
	END_INTERRUPT();

	if(txlen[nextBufferToSend]==0)
	{

		AT91C_BASE_US1->US_TCR =0;
		AT91C_BASE_US1->US_TNCR =0;
		AT91F_US_DisableIt( // disable interrupts (so int doesn't mess with queue too)
				(AT91PS_USART) AT91C_BASE_US1, AT91C_US_ENDTX);
		return;
	}

	if (AT91C_BASE_US1->US_TCR == 0) {
		AT91C_BASE_US1->US_TPR = (unsigned int) txbuf[nextBufferToSend];
		AT91C_BASE_US1->US_TCR = txlen[nextBufferToSend];
		txlen[nextBufferToSend] = 0;
		switchToNextBuffer();

	} else if (AT91C_BASE_US1->US_TNCR == 0) {
		AT91C_BASE_US1->US_TNPR = (unsigned int) txbuf[nextBufferToSend];
		AT91C_BASE_US1->US_TNCR = txlen[nextBufferToSend];
		txlen[nextBufferToSend] = 0;
		switchToNextBuffer();
	}

}

// initialise debug routine
void trace_init(void) {
	// init buffer variables
	AT91F_US1_CfgPMC();
	AT91F_AIC_CfgPMC();
	AT91F_US_Configure(AT91C_BASE_US1, AT91C_MASTER_CLOCK, AT91C_US_ASYNC_MODE,
			115200, 0);

	AT91F_US_EnableTx(AT91C_BASE_US1);

	AT91F_PIO_CfgPeriph(AT91C_BASE_PIOA, AT91C_PA22_TXD1, 0);

	AT91F_AIC_ConfigureIt(AT91C_BASE_AIC, AT91C_ID_US1, AT91C_AIC_PRIOR_LOWEST,
			AT91C_AIC_SRCTYPE_INT_HIGH_LEVEL, trace_txint);
	AT91F_AIC_EnableIt(AT91C_BASE_AIC, AT91C_ID_US1 );

	nextBufferToSend = 0;
	txlen[0] = txlen[1] = txlen[2] = 0;

}

// transmit byte (and return it, or -1 if queue full and byte not sent)
int trace_tx(char c) {

	/*while(!AT91F_US_TxReady(AT91C_BASE_US1));
	 AT91F_US_PutChar(AT91C_BASE_US1,c);
	 return c;*/

	if (txlen[nextBufferToSend] >= TXBUF_SIZE) {
		return -1;
	}
	AT91F_US_DisableIt( // disable interrupts (so int doesn't mess with queue too)
			(AT91PS_USART) AT91C_BASE_US1, AT91C_US_ENDTX);
	txbuf[nextBufferToSend][txlen[nextBufferToSend]++] = c;

	AT91F_US_EnableIt( // re-enable transmit ready interrupt
			(AT91PS_USART) AT91C_BASE_US1, AT91C_US_ENDTX);

	return c;
}

// our cut-down version of printf(), but send to debug port

void trace(char *fmt, ...) {

	va_list args;
	va_start(args, fmt);
	vxprintf(trace_tx, fmt, args);
	va_end(args);
}

