/* ----------------------------------------------------------------------------
 *         ATMEL Microcontroller Software Support  -  ROUSSET  -
 * ----------------------------------------------------------------------------
 * Copyright (c) 2006, Atmel Corporation

 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * - Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaiimer below.
 *
 * - Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the disclaimer below in the documentation and/or
 * other materials provided with the distribution.
 *
 * Atmel's name may not be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * DISCLAIMER: THIS SOFTWARE IS PROVIDED BY ATMEL "AS IS" AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE
 * DISCLAIMED. IN NO EVENT SHALL ATMEL BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
 * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * ----------------------------------------------------------------------------
 */

/*
$Id: trace.h 108 2006-10-16 08:33:33Z jjoannic $
*/

#ifndef _TRACE_H
#define _TRACE_H

void trace_init(void);
void trace(char *fmt, ...);

#if !defined(NOTRACES)

//------------------------------------------------------------------------------
//      Includes
//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
//      Definitions
//------------------------------------------------------------------------------

#define TR_INFO
#define TR_WARNING
#define TR_ERROR
#define TR_FATAL
#define TR_DEBUG_H
#define TR_DEBUG_M          // Class-level debug
#define TR_DEBUG_L          // USB-level debug


#endif // !defined(NOTRACES)
#define DBGU_BAUDRATE    115200 // 115200

//------------------------------------------------------------------------------
//      Macro
//------------------------------------------------------------------------------

#if !defined(NOTRACES)
    #define TRACE_INIT()    trace_init()
#else
    #define TRACE_INIT(...)
#endif

#if defined(TR_DEBUG_H)
    #define TRACE_DEBUG_H(...)      trace(__VA_ARGS__)
#else
    #define TRACE_DEBUG_H(...)
#endif // TR_DEBUG_H

#if defined(TR_DEBUG_M)
    #define TRACE_DEBUG_M(...)      trace(__VA_ARGS__)
#else
    #define TRACE_DEBUG_M(...)
#endif // TR_DEBUG_M

#ifdef TR_DEBUG_L
    #define TRACE_DEBUG_L(...)      trace(__VA_ARGS__)
#else
    #define TRACE_DEBUG_L(...)
#endif // TR_DEBUG_L

#if defined(TR_DEBUG_L) || defined(TR_DEBUG_M) || defined(TR_DEBUG_H)
    #define TRACE_DEBUG_ALL(...)    trace(__VA_ARGS__)
#else
    #define TRACE_DEBUG_ALL(...)
#endif

#ifdef TR_INFO
    #define TRACE_INFO(...)         trace(__VA_ARGS__)
#else
    #define TRACE_INFO(...)
#endif // TR_INFO

#ifdef TR_WARNING
    #define TRACE_WARNING(...)      trace(__VA_ARGS__)
#else
    #define TRACE_WARNING(...)
#endif // TR_WARNING

#ifdef TR_ERROR
    #define TRACE_ERROR(...)        trace(__VA_ARGS__)
#else
    #define TRACE_ERROR(...)
#endif // TR_ERROR

#ifdef TR_FATAL
    #define TRACE_FATAL(...)        trace(__VA_ARGS__)
#else
    #define TRACE_FATAL(...)
#endif // TR_FATAL

#endif // _TRACE_H
