// printf-like formatted output

#include "vxprintf.h"

// output a decimal number (with '-' sign in front if negative)
void txdecimal(int txchar(unsigned char), int number) {
	char buf[10], *p;

	if (number<0) {								// negative, output sign first
		txchar('-');
		number = -number;
	}

	p = buf;
	if (number)
		for (; number>0; number/=10)			// put chars in buffer backwards
			*p++ = (number%10)+'0';
	else
		*p++ = '0';								// number is zero, ensure we output one '0'
	while (p>buf)								// then output them forwards
		txchar(*--p);
}

// output an 8-digit hex number
void txhex(int txchar(unsigned char), unsigned int number, int ndigits) {
	int i;
	char digit;

	number <<= 4*(8-ndigits);
	for (i=0; i<ndigits; i++,number<<=4) {
		digit = number>>28;
		if (digit>9) digit += 7;
		txchar(digit+'0');
	}
}

// cut-down printf (handles %c %d %x %X %s %%), output each char with txchar()
void vxprintf(int txchar( char), char *fmt, va_list args) {
	char *s;

	for (; *fmt; fmt++) {
		if (*fmt!='%') {
			txchar(*fmt);						// not '%' escape, just output it
		} else {
			fmt++;								// go to char after '%'
			switch (*fmt) {
				case 'c':						// character
					txchar((unsigned char)va_arg(args, int));
					break;
				case 'd':						// decimal number
					txdecimal(txchar, va_arg(args, int));
					break;
				case 'x':
				case 'X':						// 2- or 8-digit hex number
					txhex(txchar, va_arg(args, unsigned int),
						*fmt=='x'?2:8);
					break;
				case 's':						// string (character pointer)
					s = va_arg(args, char *);
					while (*s) txchar(*s++);
					break;
				case '%':						// print an actual '%'
					txchar('%');
			}
		}
	}
}
