/*---------------------------------------------------------------------------------------------------------------------------------------------------
 * @file mtest.c - demo program using mcurses lib
 *
 * Copyright (c) 2011 Frank Meyer - frank(at)fli4l.de
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *---------------------------------------------------------------------------------------------------------------------------------------------------
 */

#include <stdio.h>
#include <stdlib.h>

#ifdef unix
#include <unistd.h>
#else
#include <avr/io.h>
#include <util/delay.h>
#endif

#include "mcurses.h"

#ifdef unix
#define         SLOW                            fflush (stdout), sleep (1)
#define         VERYSLOW                        fflush (stdout), sleep (1)
static char *   myitoa(uint8_t x, char * buf)   { sprintf (buf, "%d", x); return buf; }
#else
#define         SLOW                            _delay_ms (500);
#define         VERYSLOW                        _delay_ms (1000);
#define         myitoa(x,buf)                   itoa ((x), buf, 10)
#endif

static void
show_top_line (void)
{
    int     col;

    move (1, 0);
    attrset (A_REVERSE);

    for (col = 0; col < COLS; col++)
    {
        addch (' ');
    }

    mvaddstr_P (1, 2, "TOP LINE 2");
    attrset (A_NORMAL);
}

static void
show_bottom_line (void)
{
    int     col;

    move (LINES - 3, 0);
    attrset (A_REVERSE);

    for (col = 0; col < COLS; col++)
    {
        addch (' ');
    }

    mvaddstr_P (LINES - 3, 2, "BOTTOM LINE 22");
    attrset (A_NORMAL);
}

static void
message_P (char * msg)
{
    move (LINES - 2, 0);
    addstr_P (msg);
    clrtoeol ();
}

int
main ()
{
    char    buf[10];
    int     line;
    int     col;
    int     ch;

    initscr ();

    while (1)
    {
        clear ();
        move (10, 20);
        addstr_P (PSTR("MCURSES LIB DEMO"));
        attrset (A_NORMAL);
        SLOW;

        for (line = 0; line < 3; line++)
        {
            scroll ();
            SLOW;
        }

        move (7, 15);
        for (line = 0; line < 3; line++)
        {
            insertln ();
            SLOW;
        }

        move (10, 18);
        for (col = 0; col < 3; col ++)
        {
            insch (' ');
            SLOW;
        }

        move (10, 18);
        for (col = 0; col < 3; col ++)
        {
            delch ();
            SLOW;
        }

        clear ();

        show_top_line ();
        show_bottom_line ();

        setscrreg (2, LINES - 4);

        message_P (PSTR("line positioning test"));

        for (line = 2; line <= LINES - 4; line++)
        {
            move (line, 0);
            addstr (myitoa (line + 1, buf));
        }

        SLOW;
        message_P (PSTR("BOLD attribute test"));
        attrset (A_BOLD);
        mvaddstr_P (10, 10, PSTR("BOLD"));
        attrset (A_NORMAL);

        SLOW;
        message_P (PSTR("REVERSE attribute test"));
        attrset (A_REVERSE);
        mvaddstr_P (11, 10, PSTR("REVERSE"));
        attrset (A_NORMAL);

        SLOW;
        message_P (PSTR("insert test"));
        for (col = 10; col <= 22; col += 2)
        {
            mvinsch (11, col, ' ');
        }
        SLOW;

        message_P (PSTR("UNDERLINE attribute test"));
        attrset (A_UNDERLINE);
        mvaddstr_P (12, 10, PSTR("UNDERLINE"));
        attrset (A_NORMAL);

        SLOW;
        message_P (PSTR("insert line test"));
        move (11, 10);
        insertln ();
        SLOW;
        addstr_P (PSTR("Inserted line, will be deleted soon..."));

        SLOW;
        message_P (PSTR("delete line test"));
        move (11, 10);
        deleteln ();

        SLOW;
        message_P (PSTR("scroll up line test"));
        scroll ();
        SLOW;
        clear ();

        while (1)
        {
            move (10, 10);
            addstr_P (PSTR("Press a key (2x ESC to quit): "));

            ch = getch ();

            switch (ch)
            {
                case KEY_ESCAPE:    addstr_P (PSTR("KEY_ESCAPE"));  break;
                case KEY_DOWN:      addstr_P (PSTR("KEY_DOWN"));    break;
                case KEY_UP:        addstr_P (PSTR("KEY_UP"));      break;
                case KEY_LEFT:      addstr_P (PSTR("KEY_LEFT"));    break;
                case KEY_RIGHT:     addstr_P (PSTR("KEY_RIGHT"));   break;
                case KEY_HOME:      addstr_P (PSTR("KEY_HOME"));    break;
                case KEY_DC:        addstr_P (PSTR("KEY_DC"));      break;
                case KEY_IC:        addstr_P (PSTR("KEY_IC"));      break;
                case KEY_NPAGE:     addstr_P (PSTR("KEY_NPAGE"));   break;
                case KEY_PPAGE:     addstr_P (PSTR("KEY_PPAGE"));   break;
                case KEY_END:       addstr_P (PSTR("KEY_END"));     break;
                case KEY_BTAB:      addstr_P (PSTR("KEY_BTAB"));    break;
                case KEY_F(1):      addstr_P (PSTR("KEY_F(1)"));    break;
                case KEY_F(2):      addstr_P (PSTR("KEY_F(2)"));    break;
                case KEY_F(3):      addstr_P (PSTR("KEY_F(3)"));    break;
                case KEY_F(4):      addstr_P (PSTR("KEY_F(4)"));    break;
                case KEY_F(5):      addstr_P (PSTR("KEY_F(5)"));    break;
                case KEY_F(6):      addstr_P (PSTR("KEY_F(6)"));    break;
                case KEY_F(7):      addstr_P (PSTR("KEY_F(7)"));    break;
                case KEY_F(8):      addstr_P (PSTR("KEY_F(8)"));    break;
                case KEY_F(9):      addstr_P (PSTR("KEY_F(9)"));    break;
                case KEY_F(10):     addstr_P (PSTR("KEY_F(10)"));   break;
                case KEY_F(11):     addstr_P (PSTR("KEY_F(11)"));   break;
                case KEY_F(12):     addstr_P (PSTR("KEY_F(12)"));   break;
                default:            addch (ch);                     break;
            }

            clrtoeol ();

            if (ch == KEY_ESCAPE)
            {
                break;
            }
        }
    }
    endwin ();

    return 0;
}
