/*---------------------------------------------------------------------------------------------------------------------------------------------------
 * @file uart-flash.c
 *
 * Copyright (c) 2011 Robert & Frank Meyer - frank(at)fli4l.de
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *---------------------------------------------------------------------------------------------------------------------------------------------------
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "sndtx.h"

#define TRUE        1
#define FALSE       0

/*------------------------------------------------------------------------------------------------------------------------
 * usage ()
 *------------------------------------------------------------------------------------------------------------------------
 */
static void
usage (char * pgm_name)
{
    fprintf (stderr, "usage: [-f] %s file\n", pgm_name);
    exit (1);
}

/*------------------------------------------------------------------------------------------------------------------------
 * main ()
 *------------------------------------------------------------------------------------------------------------------------
 */
int
main (int argc, char ** argv)
{
    char *          file;
    FILE *          fp;
    unsigned char * buf;
    unsigned char * bufp;
    long            cnt;
    long            bufsize;
    char *          pgmname;
    char            ch;
    int             do_flash = FALSE;
    int             rtc = 0;
    int             offset = 0;

    pgmname = argv[0];

    while (argc > 2)
    {
        if (! strcmp (argv[1], "-f"))
        {
            do_flash = TRUE;
            offset++;
            argc--;
            argv++;
        }
        else
        {
            usage (pgmname);
        }
    }

    if (argc != 2)
    {
        usage (pgmname);
    }

    file = argv[1];

    fp = fopen (file, "rb");

    if (! fp)
    {
        perror (file);
        exit (1);
    }

    fseek (fp, 0L, SEEK_END);
    bufsize = ftell (fp);
    rewind (fp);
    buf = malloc (bufsize+offset);

    if (! buf)
    {
        perror ("malloc");
        exit (1);
    }

    if (do_flash)
    {
        buf[0] = '$';
    }

    for (bufp = buf + offset, cnt = 0; cnt < bufsize && (ch = getc (fp)) != EOF; bufp++, cnt++)
    {
        *bufp = ch;
    }

    fclose (fp);
    if (sound_play (buf, bufsize + offset) == ERR)
    {
        rtc = 1; 
    }

    free (buf);
    return (rtc);
}
