/*---------------------------------------------------------------------------------------------------------------------------------------------------
 * @file sndrxconfig.h
 *
 * Copyright (c) 2011 Robert Meyer, Frank Meyer - frank(at)fli4l.de
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *---------------------------------------------------------------------------------------------------------------------------------------------------
 */

/*---------------------------------------------------------------------------------------------------------------------------------------------------
 * Number of samples per second, typ. 12000
 *---------------------------------------------------------------------------------------------------------------------------------------------------
 */
#define SNDRX_F_SAMPLES                     12000               // wave format: samples per second, default is 12000

/*---------------------------------------------------------------------------------------------------------------------------------------------------
 * Enable/Disable logging
 *---------------------------------------------------------------------------------------------------------------------------------------------------
 */
#define SNDRX_LOGGING                       0                   // flag: 0: don't log, 1: log on uart, default is 0
#define SNDRX_RINGBUFSIZE                   32                  // size of ringbuffer

/*---------------------------------------------------------------------------------------------------------------------------------------------------
 * Change hardware pin here:
 *---------------------------------------------------------------------------------------------------------------------------------------------------
 */
#define SNDRX_PORT                          PORTD
#define SNDRX_DDR                           DDRD
#define SNDRX_PIN                           PIND
#define SNDRX_BIT                           0                   // use PD0 as sound input

#define input(x)                            ((x) & (1 << SNDRX_BIT))
