/*---------------------------------------------------------------------------------------------------------------------------------------------------
 * @file sndrx.h
 *
 * Copyright (c) 2011 Robert Meyer, Frank Meyer - frank(at)fli4l.de
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *---------------------------------------------------------------------------------------------------------------------------------------------------
 */

/*---------------------------------------------------------------------------------------------------------------------------------------------------
 *  Return values of sndrx_status():
 *---------------------------------------------------------------------------------------------------------------------------------------------------
 */
#define SNDRX_INFO_IDLE                         0                   // INFO:  sndrx is idle
#define SNDRX_INFO_TRANSMIT                     1                   // INFO:  sender is transmitting
#define SNDRX_ERROR_FRAME                       2                   // ERROR: frame error occured
#define SNDRX_ERROR_OVERFLOW                    3                   // ERROR: ringbuffer overflow
#define SNDRX_ERROR_TIMEOUT                     4                   // ERROR: timeout occured (buffer underrun)

#if SNDRX_LOGGING == 1                                              // only for debugging, here not used
extern void     sndrx_log (void);
#endif

extern void     sndrx_init (void);                                  // initialize SOUNDRX
extern int8_t   sndrx_poll (uint8_t *, uint16_t);                   // poll with given timeout (msec)
extern uint8_t  sndrx_status (void);                                // get current status
