/*---------------------------------------------------------------------------------------------------------------------------------------------------
 * @file sndrxconfig.h
 *
 * Copyright (c) 2011 Robert Meyer, Frank Meyer - frank(at)fli4l.de
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *---------------------------------------------------------------------------------------------------------------------------------------------------
 */

/*---------------------------------------------------------------------------------------------------------------------------------------------------
 * Samples per second, typ. 44100
 *---------------------------------------------------------------------------------------------------------------------------------------------------
 */
#define SNDRX_F_SAMPLES                     44100               // wave format: samples per second, min is 8000, max. is 44100

/*---------------------------------------------------------------------------------------------------------------------------------------------------
 * Size of ringbuffer, typ. 32, max is 255
 *---------------------------------------------------------------------------------------------------------------------------------------------------
 */
#define SNDRX_RINGBUFSIZE                   32                  // size of ringbuffer, if == 0, ringbuffer will be disabled

/*---------------------------------------------------------------------------------------------------------------------------------------------------
 * Change hardware pin here:
 *---------------------------------------------------------------------------------------------------------------------------------------------------
 */
#define SNDRX_PORT                          PORTB
#define SNDRX_DDR                           DDRB
#define SNDRX_PIN                           PINB
#define SNDRX_BIT                           2                   // use PB2 as sound input

/*---------------------------------------------------------------------------------------------------------------------------------------------------
 * Input pin macro, DO NOT CHANGE
 *---------------------------------------------------------------------------------------------------------------------------------------------------
 */
#define input(x)                            !((x) & (1 << SNDRX_BIT))

/*---------------------------------------------------------------------------------------------------------------------------------------------------
 * Enable/Disable logging, DO NOT CHANGE
 *---------------------------------------------------------------------------------------------------------------------------------------------------
 */
#define SNDRX_LOGGING                       0                   // flag: 0: don't log, 1: log on uart, default is 0
