/*---------------------------------------------------------------------------------------------------------------------------------------------------
 * @file main.c
 *
 * Copyright (c) 2011 Robert & Frank Meyer - frank(at)fli4l.de
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *---------------------------------------------------------------------------------------------------------------------------------------------------
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "sndtx.h"

#define TRUE                1
#define FALSE               0

#define F_SAMPLES           44100

#define SPM_PAGESIZE        128
#define LINES_PER_PAGE      8

typedef                     unsigned char uint8_t;

/*------------------------------------------------------------------------------------------------------------------------
 * usage ()
 *------------------------------------------------------------------------------------------------------------------------
 */
static void
usage (char * pgm_name)
{
    fprintf (stderr, "usage: %s [-s samples] file [outputfile.wav]\n", pgm_name);
    exit (1);
}

/*------------------------------------------------------------------------------------------------------------------------
 * main ()
 *------------------------------------------------------------------------------------------------------------------------
 */
int
main (int argc, char ** argv)
{
    char *          file;
    char *          target = (char *) NULL;
    FILE *          fp;
    unsigned char * buf;
    unsigned char * bufp;
    int             samples;
    long            cnt;
    long            bufsize;
    char *          pgmname;
    char            ch;
    int             rtc = 0;

    samples = F_SAMPLES;

    pgmname = argv[0];

    while (argc > 1 && *argv[1] == '-')
    {
        if (argc > 2 && ! strcmp (argv[1], "-s"))
        {
            argc--;
            argv++;
            samples = atoi (argv[1]);

            if (samples < 5000)
            {
                fprintf (stderr, "%s: invalid value of samples: %s, minimum is 5000.\n", pgmname, argv[1]);
                exit (1);
            }

            if (samples > 44100)
            {
                fprintf (stderr, "%s: invalid value of samples: %s, maximum is 44100.\n", pgmname, argv[1]);
                exit (1);
            }
            argc--;
            argv++;
        }
        else
        {
            usage (pgmname);
        }
    }

    if (argc == 3)
    {
        file = argv[1];
        target = argv[2];
    }
    else if (argc == 2)
    {
        file = argv[1];
    }
    else
    {
        usage (pgmname);
    }

    fp = fopen (file, "rb");

    if (! fp)
    {
        perror (file);
        exit (1);
    }

    fseek (fp, 0L, SEEK_END);
    bufsize = ftell (fp);
    rewind (fp);
    buf = malloc (bufsize);

    if (! buf)
    {
        perror ("malloc");
        exit (1);
    }

    for (bufp = buf, cnt = 0; cnt < bufsize && (ch = getc (fp)) != EOF; bufp++, cnt++)
    {
        *bufp = ch;
    }

    fclose (fp);

    if (sound_play (buf, bufsize, samples, target) == ERR)
    {
        rtc = 1; 
    }

    free (buf);
    return (rtc);
}
