/*---------------------------------------------------------------------------------------------------------------------------------------------------
 * @file sndrxconfig.h
 *
 * Copyright (c) 2011 Robert Meyer, Frank Meyer - frank(at)fli4l.de
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *---------------------------------------------------------------------------------------------------------------------------------------------------
 */

/*---------------------------------------------------------------------------------------------------------------------------------------------------
 * Samples per second, typ. 41667
 *
 * Some possible values:
 *
 * Samples      Avg. speed      8MHz    12MHz   16MHz   20MHz
 *  41667       2083 ch/sec      *                *
 *  39063       1953 ch/sec                               *
 *  37500       1875 ch/sec               *
 *  35714       1786 ch/sec                       *
 *  31250       1563 ch/sec      *        *       *       *
 *  20833       1042 ch/sec      *        *       *       *
 *  15625        781 ch/sec      *        *       *       *
 *  12500        625 ch/sec      *        *       *      (*)
 *---------------------------------------------------------------------------------------------------------------------------------------------------
 */
#define SNDRX_F_SAMPLES                     41667               // wave format: samples per second, min is 12500, max. is 44100

/*---------------------------------------------------------------------------------------------------------------------------------------------------
 * Size of ringbuffer, typ. 32, max is 255
 *---------------------------------------------------------------------------------------------------------------------------------------------------
 */
#define SNDRX_RINGBUFSIZE                   32                  // size of ringbuffer, if == 0, ringbuffer will be disabled

/*---------------------------------------------------------------------------------------------------------------------------------------------------
 * Change hardware pin here:
 *---------------------------------------------------------------------------------------------------------------------------------------------------
 */
#define SNDRX_PRT                           'B'                 // Port B
#define SNDRX_BIT                           2                   // use PB2 as sound input

/*---------------------------------------------------------------------------------------------------------------------------------------------------
 * Input pin macro, DO NOT CHANGE
 *---------------------------------------------------------------------------------------------------------------------------------------------------
 */
#define input(x)                            ((x) & (1 << SNDRX_BIT))

/*---------------------------------------------------------------------------------------------------------------------------------------------------
 * Enable/Disable logging, DO NOT CHANGE
 *---------------------------------------------------------------------------------------------------------------------------------------------------
 */
#define SNDRX_CALIBRATE                     0                   // flag: 0: don't calibrate, 1: calibrate, default is 0

/*---------------------------------------------------------------------------------------------------------------------------------------------------
 * Enable/Disable logging, DO NOT CHANGE
 *---------------------------------------------------------------------------------------------------------------------------------------------------
 */
#define SNDRX_LOGGING                       0                   // flag: 0: don't log, 1: log on uart, default is 0


