//-----------------------------------------------------------------------------
// INCLUDES
//-----------------------------------------------------------------------------
#include <avr/io.h>
#include "adc.h"


//-----------------------------------------------------------------------------
uint16_t adc_readChannel( uint8_t mux ) {
  uint8_t   i;
  uint16_t  result;
 
  ADMUX = mux;
  
  // Referenzspannung: interne 1.1V
  ADMUX |= (1 << REFS1) | (1 << REFS0);
 
  // Prescaler: 
  // min = 1MHz / 200kHz = 5;   max = 1MHz / 50kHz = 20;    --> 16
  // 50kHz <= f_adcckl <= 200kHz
  ADCSRA = (1 << ADEN) | (1 << ADPS2);
 
  // ADC aktivieren
  ADCSRA |= (1<<ADSC);
  while ( ADCSRA & (1<<ADSC) ) { ; }
  result = ADCW;
 
  /* Eigentliche Messung - Mittelwert aus 4 aufeinanderfolgenden Wandlungen */
  result = 0; 
  for( i=0; i<4; i++ ) {
    ADCSRA |= (1<<ADSC);            // eine Wandlung "single conversion"
    while ( ADCSRA & (1<<ADSC) ) { ; }
    result += ADCW;
  }
  // ADC deaktivieren
  ADCSRA &= ~(1<<ADEN);
 
  result /= 4;
  return result;
}
