#ifndef _FIFO_H_
#define _FIFO_H_

//-----------------------------------------------------------------------------
/// \file
/// fifo.h
/// \date
/// Create: 24.02.2009 Kae <br>
/// Modify: 02.02.2010 Kae
/// \brief
/// FIFO Puffer zur zwischenspeicherung der Busdaten
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// INCLUDES
//-----------------------------------------------------------------------------
#include <stdint.h>
#include "stdDefs.h"


//-----------------------------------------------------------------------------
// OPTIMAZIONS
//-----------------------------------------------------------------------------
#define DO_NOT_USE_fifo_GetData


//-----------------------------------------------------------------------------
// GLOBAL DEFINES
//-----------------------------------------------------------------------------
#define  BUFFER_SIZE       96        // <= 255


//-----------------------------------------------------------------------------
// GLOBAL TYPE DEFINITIONS
//-----------------------------------------------------------------------------
typedef struct {
  uint8_t array[BUFFER_SIZE]; // Ring-Puffer mit Daten
  uint8_t read;               // zeigt auf das Feld mit den aeltesten Daten,
                              // welche noch nicht gelesen wurden
  uint8_t write;              // zeigt immer auf ein leeres Feld
} FIFO_BUFFER;


//-----------------------------------------------------------------------------
// GLOBAL VARIABLES
//-----------------------------------------------------------------------------
extern FIFO_BUFFER sReceiveFifo;   // RxD Queue


//-----------------------------------------------------------------------------
// GLOBAL PROTOTYPS
//-----------------------------------------------------------------------------

BOOL      fifo_AddData                ( uint8_t DataToAdd, FIFO_BUFFER *pFIFO );

BOOL      fifo_GetData                ( uint8_t *pData, FIFO_BUFFER *pFIFO );

uint8_t   fifo_ReadData               ( uint8_t Addr, FIFO_BUFFER *pFIFO );

uint8_t   fifo_GetAvaiableDataCount   ( FIFO_BUFFER *pFIFO );

// RxD Queue
#define Rx_AddData(arg)             (fifo_AddData ( arg, &sReceiveFifo ))
#define Rx_GetData(arg)             (fifo_GetData ( arg, &sReceiveFifo ))
#define Rx_ReadData(arg)            (fifo_ReadData ( arg, &sReceiveFifo ))
#define Rx_GetAvaiableDataCount()   (fifo_GetAvaiableDataCount ( &sReceiveFifo ))

#endif // _FIFO_H_

//-----------------------------------------------------------------------------
// end of file
//-----------------------------------------------------------------------------
