//-----------------------------------------------------------------------------
// INCLUDES
//-----------------------------------------------------------------------------
#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/sleep.h>

#include "application.h"
#include "fifo.h"
#include "cmd_parser.h"
#include "digitalIo.h"
#include "uart.h"
#include "timer.h"
#include "led.h"

int main ( void ) {
  uint8_t   dataByte;
  
  // Initialisierung
  // ---------------
  USART_Init(2400);
  initLed();
  initTimer2();
  initDigitalIo();
  initApp();
  sei();

  // Hauptprogramm
  // -------------

  while (1) {
    if (uart_isData() == TRUE) {
      dataByte = (uint8_t)uart_getc();
    
      Rx_AddData(dataByte);
      if (dataByte == '\r') {
        copyAndInterpretCommand();
        uart_putc('>');
        Rx_AddData('>');
      }
  }

    if (doSleep == TRUE) {
      set_sleep_mode(SLEEP_MODE_PWR_SAVE);
      sleep_mode();
    }
  }
}
