#ifndef _APPLICATION_H_
#define _APPLICATION_H_

//-----------------------------------------------------------------------------
// INCLUDES
//-----------------------------------------------------------------------------
#include <stdint.h>
#include "stdDefs.h"


//-----------------------------------------------------------------------------
// ENUMERATIONS AND TYPES
//-----------------------------------------------------------------------------
typedef struct {
  uint8_t   sec;
  uint8_t   min;
  uint8_t   hour;
  uint8_t   weekday;  // 0 So, 6 Sa
} TimeAndDate;

typedef struct {
  /// Zeit welche die Pumpe pro aktiviertem Wochentag laufen soll [s]
  uint16_t  active;
  /// Tageszeit zu der die Pumpe laufen soll (Stunden)
  uint8_t   hour;
  /// Tageszeit zu der die Pumpe laufen soll (Minuten)
  uint8_t   min;
  /// Wochentage an denen die Pumpe laufen soll (0 So , 6 Sa)
  BOOL      days[7];
  /// Aktuelle Batteriespannung [mV]
  uint16_t  voltage;
  /// LED soll Blinken (wird von voltageControlTick gesetzt)
  BOOL      flashLed;
} Settings;


//-----------------------------------------------------------------------------
// FUNCTIONS
//-----------------------------------------------------------------------------
void    initApp                     ( void );

void    setTime                     ( uint8_t hour, uint8_t min );
void    setWeekday                  ( uint8_t wDay );
void    setDays                     ( BOOL arr[] );
void    setActiveTime               ( uint16_t period );
void    setDayTime                  ( uint8_t hour, uint8_t min );

void    sendStatus                  ( void );

void    secTick                     ( void );

void    checkVoltageAvaiableTick    ( void );


#endif
