//-----------------------------------------------------------------------------
// INCLUDES
//-----------------------------------------------------------------------------
#include "pump.h"
#include "digitalIo.h"


//-----------------------------------------------------------------------------
// VARIABELS
//-----------------------------------------------------------------------------
uint16_t  secCnt;


//-----------------------------------------------------------------------------
void pumpControlSecTick ( const TimeAndDate *time, const Settings *setting ) {
  
  if   ( (time->min == setting->min)
      && (time->hour == setting->hour)
      && (time->sec == 0)
      && (setting->days[time->weekday] == TRUE) )
  {
    secCnt = setting->active + 1;
  }
  
  if (secCnt > 1) {
    secCnt--;
    setPump(TRUE);
  } else if (secCnt == 1) {
    secCnt = 0;
    setPump(FALSE);
  }
}
